/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesBuilder {
    public static final HashSet<String> STANDARD_SYSTEM_PROPERTIES = SystemProperties.STANDARD_SYSTEM_PROPERTY_NAMES;
    private LinkedHashMap<String, Property> properties = new LinkedHashMap();

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Map<String, String> properties) {
        this();
        for (String name : properties.keySet()) {
            this.properties.put(name, new Property(name, properties.get(name)));
        }
    }

    public PropertiesBuilder(Properties properties) {
        this();
        for (String key : properties.stringPropertyNames()) {
            this.properties.put(key, new Property(key, properties.getProperty(key)));
        }
    }

    public PropertiesBuilder(PropertiesBuilder propertiesBuilder) {
        this();
        for (String name : propertiesBuilder.getPropertyNames()) {
            this.properties.put(name, new Property(propertiesBuilder.properties.get(name)));
        }
    }

    public int size() {
        return this.properties.size();
    }

    public PropertiesBuilder setProperty(String name, Iterator<?> iterator) {
        if (this.containsProperty(name)) {
            this.properties.get(name).setValue(iterator);
        } else {
            this.properties.put(name, new Property(name, iterator));
        }
        return this;
    }

    public PropertiesBuilder setPropertyIfAbsent(String name, Iterator<?> iterator) {
        if (this.containsProperty(name)) {
            return this;
        }
        return this.setProperty(name, iterator);
    }

    public PropertiesBuilder setProperty(String name, Object value) {
        if (this.containsProperty(name)) {
            this.properties.get(name).setValue(value);
        } else {
            this.properties.put(name, new Property(name, value));
        }
        return this;
    }

    public PropertiesBuilder setPropertyIfAbsent(String name, Object value) {
        if (this.containsProperty(name)) {
            return this;
        }
        return this.setProperty(name, value);
    }

    public PropertiesBuilder setProperties(PropertiesBuilder propertiesBuilder) {
        this.properties.putAll(propertiesBuilder.properties);
        return this;
    }

    public PropertiesBuilder addProperties(PropertiesBuilder propertiesBuilder) {
        this.setProperties(propertiesBuilder);
        return this;
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            Property property = this.properties.get(name);
            return property.getValue();
        }
        return null;
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public void clear() {
        this.properties.clear();
    }

    public Iterable<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Properties realize(PropertiesBuilder overrides) {
        return this.realize(overrides, null);
    }

    public Properties realize(PropertiesBuilder overrides, Platform platform) {
        Properties properties = new Properties();
        if (overrides != null) {
            properties.putAll((Map<?, ?>)overrides.realize());
        }
        for (String name : this.getPropertyNames()) {
            Object value;
            if (properties.containsKey(name) || (value = this.getProperty(name)) == null) continue;
            if (value instanceof Iterator) {
                Iterator iterator = (Iterator)value;
                if (iterator.hasNext()) {
                    properties.put(name, iterator.next().toString());
                    continue;
                }
                throw new IndexOutOfBoundsException(String.format("No more values available for the property [%s]", name));
            }
            properties.put(name, value.toString());
        }
        return properties;
    }

    public Properties realize() {
        return this.realize(null);
    }

    public static PropertiesBuilder fromPropertiesFile(String fileName) throws IOException {
        Properties properties = new Properties();
        URL url = ClassLoader.getSystemResource(fileName);
        properties.load(url.openStream());
        return new PropertiesBuilder(properties);
    }

    public static PropertiesBuilder fromCurrentEnvironmentVariables() {
        return new PropertiesBuilder(System.getenv());
    }

    public static PropertiesBuilder fromCurrentNonStandardSystemProperties() {
        Properties systemProperties = System.getProperties();
        Properties properties = new Properties();
        for (String propertyName : systemProperties.stringPropertyNames()) {
            if (STANDARD_SYSTEM_PROPERTIES.contains(propertyName)) continue;
            properties.put(propertyName, systemProperties.get(propertyName));
        }
        return new PropertiesBuilder(properties);
    }

    private static class Property {
        private String name;
        private Object value;

        public Property(Property property) {
            this.name = property.getName();
            this.value = property.getValue();
        }

        public Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public String toString() {
            return String.format("{name=%s, value=%s}", this.name, this.value);
        }
    }
}

