/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Infrastructure;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.PlatformPredicate;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;

public class StaticInfrastructure
implements Infrastructure {
    private ArrayList<Platform> platforms = new ArrayList();

    StaticInfrastructure(Platform ... platforms) {
        if (platforms != null) {
            for (Platform platform : platforms) {
                this.platforms.add(platform);
            }
        }
    }

    public static Infrastructure of(Platform ... platforms) {
        return new StaticInfrastructure(platforms);
    }

    @Override
    public Platform getPlatform(Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        PlatformPredicate predicate = (PlatformPredicate)optionsByType.getOrDefault(PlatformPredicate.class, (Option)PlatformPredicate.any());
        Optional platform = ((Stream)this.platforms.stream().filter(predicate).unordered()).findFirst();
        return platform.isPresent() ? (Platform)platform.get() : null;
    }
}

