/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent.callable;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.util.ReflectionHelper;
import java.io.Serializable;
import java.lang.reflect.Method;

public class RemoteMethodInvocation<T>
implements RemoteCallable<Object> {
    private RemoteCallable<T> instanceProducer;
    private String methodName;
    private Object[] arguments;
    private Interceptor interceptor;

    public RemoteMethodInvocation(RemoteCallable<T> instanceProducer, String methodName, Object[] arguments, Interceptor interceptor) {
        this.instanceProducer = instanceProducer;
        this.methodName = methodName;
        this.arguments = arguments;
        this.interceptor = interceptor;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public Object call() throws Exception {
        Object instance = this.instanceProducer.call();
        if (instance == null) {
            throw new NullPointerException("Remote Instance is null");
        }
        Method method = ReflectionHelper.getCompatibleMethod(instance.getClass(), (String)this.methodName, (Object[])this.arguments);
        if (method == null) {
            throw new NoSuchMethodException(this.methodName);
        }
        method.setAccessible(true);
        if (this.interceptor != null) {
            this.interceptor.onBeforeInvocation(instance, method, this.arguments);
        }
        try {
            Object result = method.invoke(instance, this.arguments);
            if (this.interceptor != null) {
                result = this.interceptor.onAfterInvocation(instance, method, this.arguments, result);
            }
            return result;
        }
        catch (Exception e) {
            if (this.interceptor == null) {
                throw e;
            }
            throw this.interceptor.onInvocationException(instance, method, this.arguments, e);
        }
    }

    public static interface Interceptor
    extends Serializable {
        public void onBeforeRemoteInvocation(Method var1, Object[] var2);

        public Object onAfterRemoteInvocation(Method var1, Object[] var2, Object var3);

        public Exception onRemoteInvocationException(Method var1, Object[] var2, Exception var3);

        public void onBeforeInvocation(Object var1, Method var2, Object[] var3);

        public Object onAfterInvocation(Object var1, Method var2, Object[] var3, Object var4);

        public Exception onInvocationException(Object var1, Method var2, Object[] var3, Exception var4);
    }
}

