/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.console.AbstractPipedApplicationConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CapturingApplicationConsole
extends AbstractPipedApplicationConsole {
    private int maximumLines;
    private ConcurrentLinkedQueue<String> stdoutBuffer;
    private ConcurrentLinkedQueue<String> stderrBuffer;
    protected Thread stdoutThread;
    protected Thread stderrThread;

    public CapturingApplicationConsole() {
        this(Integer.MAX_VALUE, false, 1024);
    }

    public CapturingApplicationConsole(int maximumLines) {
        this(maximumLines, false, 1024);
    }

    public CapturingApplicationConsole(int maximumLines, boolean diagnosticMode) {
        this(maximumLines, diagnosticMode, 1024);
    }

    public CapturingApplicationConsole(int maximumLines, boolean diagnosticMode, int pipeSize) {
        super(pipeSize, diagnosticMode);
        this.maximumLines = maximumLines;
        this.stdoutBuffer = new ConcurrentLinkedQueue();
        this.stderrBuffer = new ConcurrentLinkedQueue();
        this.stdoutThread = new Thread(new OutputCaptor(this.stdoutReader, this.stdoutBuffer));
        this.stderrThread = new Thread(new OutputCaptor(this.stderrReader, this.stderrBuffer));
        this.stdoutThread.start();
        this.stderrThread.start();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.stdoutThread.join();
            this.stderrThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Queue<String> getCapturedOutputLines() {
        return this.stdoutBuffer;
    }

    public Queue<String> getCapturedErrorLines() {
        return this.stderrBuffer;
    }

    public PrintWriter getInputWriter() {
        return this.stdinWriter;
    }

    class OutputCaptor
    implements Runnable {
        BufferedReader reader;
        ConcurrentLinkedQueue<String> lines;

        OutputCaptor(BufferedReader reader, ConcurrentLinkedQueue<String> lines) {
            this.reader = reader;
            this.lines = lines;
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    if (this.lines.size() >= CapturingApplicationConsole.this.maximumLines) {
                        this.lines.poll();
                    }
                    this.lines.add(line);
                    line = this.reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

