/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.runtime.java.ClassPath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathScanner {
    public List<String> getResources(ClassPath classPath, Pattern pattern) throws Exception {
        if (pattern == null) {
            pattern = Pattern.compile(".*");
        }
        ArrayList<String> result = new ArrayList<String>();
        URLClassLoader loader = new URLClassLoader(classPath.getURLs());
        Enumeration<URL> resources = loader.getResources("");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            File file = new File(url.toURI());
            for (String resource : this.getResources(file, pattern)) {
                if (!resource.endsWith(".class")) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private Collection<String> getResources(File file, Pattern pattern) throws IOException {
        ArrayList<String> retval = new ArrayList<String>();
        if (file.isDirectory()) {
            retval.addAll(this.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(this.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private List<String> getResourcesFromJarFile(File file, Pattern pattern) throws IOException {
        if (!ClassPath.isResourceAnArchive(file.getCanonicalPath())) {
            return Collections.emptyList();
        }
        ArrayList<String> retval = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (!pattern.matcher(fileName).matches()) continue;
                retval.add(fileName);
            }
        }
        return retval;
    }

    private List<String> getResourcesFromDirectory(File directory, Pattern pattern) throws IOException {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (File file : fileList) {
            if (file.isDirectory()) {
                list.addAll(this.getResourcesFromDirectory(file, pattern));
                continue;
            }
            String fileName = file.getCanonicalPath();
            if (!pattern.matcher(fileName).matches()) continue;
            list.add(fileName);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        Pattern pattern = null;
        if (args.length > 0) {
            pattern = Pattern.compile(args[0]);
        }
        ClassPath path = ClassPath.ofClass(ClassPathScanner.class);
        List<String> list = new ClassPathScanner().getResources(path, pattern);
        for (String name : list) {
            System.out.println(name);
        }
    }
}

