/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteMethodInvocation;
import com.oracle.bedrock.runtime.java.SimpleJavaApplication;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public interface JavaApplication
extends Application,
RemoteChannel {
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";
    public static final String JAVA_NET_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    public static final String JAVA_NET_PREFER_IPV6_STACK = "java.net.preferIPv6Stack";

    public Properties getSystemProperties();

    public String getSystemProperty(String var1);

    default public <T> T invoke(RemoteCallable<T> callable, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        Timeout timeout = (Timeout)optionsByType.getOrDefault(Timeout.class, (Option)((Timeout)this.getOptions().get(Timeout.class, new Object[0])));
        CompletableFuture future = this.submit(callable, options);
        try {
            return future.get(timeout.to(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getProxyFor(Class<T> var1, RemoteCallable<T> var2, RemoteMethodInvocation.Interceptor var3);

    public static class MetaClass
    implements com.oracle.bedrock.runtime.MetaClass<JavaApplication> {
        @OptionsByType.Default
        public MetaClass() {
        }

        @Override
        public Class<? extends JavaApplication> getImplementationClass(Platform platform, OptionsByType optionsByType) {
            return SimpleJavaApplication.class;
        }

        @Override
        public void onLaunch(Platform platform, OptionsByType optionsByType) {
        }

        @Override
        public void onLaunching(Platform platform, OptionsByType optionsByType) {
        }

        @Override
        public void onLaunched(Platform platform, JavaApplication application, OptionsByType optionsByType) {
        }
    }
}

