/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class Headless
implements Profile,
Option {
    private boolean enabled;

    private Headless(boolean enabled) {
        this.enabled = enabled;
    }

    public static Headless enabled(boolean enabled) {
        return new Headless(enabled);
    }

    public static Headless enabled() {
        return new Headless(true);
    }

    public static Headless disabled() {
        return new Headless(false);
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null && this.enabled) {
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of("java.awt.headless", true, new Option[0]));
            optionsByType.add((Option)systemProperties);
        }
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Headless)) {
            return false;
        }
        Headless headless = (Headless)o;
        return this.enabled == headless.enabled;
    }

    public int hashCode() {
        return this.enabled ? 1 : 0;
    }
}

