/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.java.options.JavaAgent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class JavaAgents
implements Option.Collector<JavaAgent, JavaAgents> {
    private LinkedHashSet<JavaAgent> agents = new LinkedHashSet();

    @OptionsByType.Default
    public JavaAgents() {
    }

    public JavaAgents(JavaAgent ... agents) {
        this();
        if (agents != null) {
            for (JavaAgent agent : agents) {
                this.agents.add(agent);
            }
        }
    }

    public JavaAgents(JavaAgents javaAgents) {
        this();
        Iterator<JavaAgent> iterator = javaAgents.iterator();
        while (iterator.hasNext()) {
            JavaAgent javaAgent = iterator.next();
            this.agents.add(javaAgent);
        }
    }

    public JavaAgents with(JavaAgent agent) {
        JavaAgents result = new JavaAgents(this);
        result.agents.add(agent);
        return result;
    }

    public JavaAgents without(JavaAgent agent) {
        JavaAgents result = new JavaAgents(this);
        result.agents.remove(agent);
        return result;
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(JavaAgent.class)) {
            return this.agents;
        }
        return Collections.EMPTY_LIST;
    }

    public Iterator<JavaAgent> iterator() {
        return this.agents.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaAgents)) {
            return false;
        }
        JavaAgents agents1 = (JavaAgents)o;
        return this.agents != null ? this.agents.equals(agents1.agents) : agents1.agents == null;
    }

    public int hashCode() {
        return this.agents != null ? this.agents.hashCode() : 0;
    }
}

