/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.profiles;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.Freeform;
import java.lang.management.ManagementFactory;

public class CommercialFeatures
implements Profile,
Option {
    private boolean enabled;

    private CommercialFeatures(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (this.enabled) {
            optionsByType.add((Option)new Freeform("-XX:+UnlockCommercialFeatures"));
        }
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public static CommercialFeatures enabled() {
        return new CommercialFeatures(true);
    }

    public static CommercialFeatures disabled() {
        return new CommercialFeatures(false);
    }

    @OptionsByType.Default
    public static CommercialFeatures autoDetect() {
        try {
            return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(arg -> arg.contains("-XX:+UnlockCommercialFeatures")).findFirst().isPresent() ? CommercialFeatures.enabled() : CommercialFeatures.disabled();
        }
        catch (Throwable t) {
            System.err.println("Error trying to determine commercial features status - " + t.getMessage());
            return CommercialFeatures.disabled();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommercialFeatures)) {
            return false;
        }
        CommercialFeatures that = (CommercialFeatures)o;
        return this.enabled == that.enabled;
    }

    public int hashCode() {
        return this.enabled ? 1 : 0;
    }
}

