/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import java.io.NotSerializableException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class DeferredRemoteExecution<T>
implements Deferred<T> {
    private RemoteChannel remoteChannel;
    private RemoteCallable<T> callable;
    private boolean hasSubmittedCallable;
    private boolean hasResult;
    private T result;
    private Throwable throwable;

    public DeferredRemoteExecution(RemoteChannel remoteChannel, RemoteCallable<T> callable) {
        this.remoteChannel = remoteChannel;
        this.callable = callable;
        this.hasSubmittedCallable = false;
        this.hasResult = false;
        this.result = null;
        this.throwable = null;
    }

    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        DeferredRemoteExecution deferredRemoteExecution = this;
        synchronized (deferredRemoteExecution) {
            if (this.hasResult) {
                this.hasResult = false;
                this.hasSubmittedCallable = false;
                if (this.throwable == null) {
                    return this.result;
                }
                throw new TemporarilyUnavailableException((Deferred)this, this.throwable);
            }
            if (this.hasSubmittedCallable) {
                throw new TemporarilyUnavailableException((Deferred)this);
            }
            this.hasSubmittedCallable = true;
            this.hasResult = false;
            this.result = null;
            this.throwable = null;
            try {
                this.remoteChannel.submit(this.callable, new Option[0]).handle((result, exception) -> {
                    DeferredRemoteExecution deferredRemoteExecution = this;
                    synchronized (deferredRemoteExecution) {
                        if (!this.hasResult) {
                            if (exception == null) {
                                this.hasResult = true;
                                this.result = result;
                                this.throwable = null;
                            } else {
                                this.hasResult = true;
                                this.result = null;
                                this.throwable = exception;
                            }
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                throw new PermanentlyUnavailableException((Deferred)this, (Throwable)e);
            }
            if (this.throwable instanceof NotSerializableException) {
                throw new PermanentlyUnavailableException((Deferred)this, this.throwable);
            }
            throw new TemporarilyUnavailableException((Deferred)this);
        }
    }

    public Class<T> getDeferredClass() {
        for (Type type : this.callable.getClass().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(RemoteCallable.class)) continue;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("Could not determine the type of the specified Callable");
    }
}

