/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Assembly;
import com.oracle.bedrock.runtime.AssemblyBuilder;
import com.oracle.bedrock.testsupport.junit.AbstractBaseAssembly;
import java.util.ArrayList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public abstract class AbstractAssemblyResource<A extends Application, G extends Assembly<A>, R extends AbstractAssemblyResource<A, G, R>>
extends AbstractBaseAssembly<A, G, R>
implements TestRule {
    protected AbstractAssemblyResource() {
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AbstractAssemblyResource.this.before();
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    try {
                        AbstractAssemblyResource.this.after();
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    @Override
    protected abstract AssemblyBuilder<A, G, ?> createBuilder();

    protected void before() throws Throwable {
        this.start();
    }

    protected void after() {
        this.close();
    }
}

