/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.console.EventsApplicationConsole;
import com.oracle.bedrock.testsupport.MavenProjectFileUtils;
import com.oracle.bedrock.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTestLogs
implements ApplicationConsoleBuilder {
    public static final Logger LOGGER = Logger.getLogger(AbstractTestLogs.class.getName());
    protected Class<?> testClass;
    protected String methodName;
    protected File outputDirectory;

    public void init(Class<?> clsTest, String sMethodName) {
        this.testClass = clsTest;
        this.methodName = sMethodName;
        this.outputDirectory = MavenProjectFileUtils.ensureTestOutputBaseFolder(this.testClass);
        this.outputDirectory.mkdirs();
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public File getOutputFolder() {
        return this.outputDirectory;
    }

    public ConsoleBuilder builder() {
        return new ConsoleBuilder(this);
    }

    public ApplicationConsole build(String name) {
        File dir = new File(this.outputDirectory, this.testClass.getSimpleName());
        dir.mkdir();
        if (this.methodName != null && this.methodName.trim().length() > 0) {
            dir = new File(dir, this.methodName);
            dir.mkdir();
        }
        File logFile = new File(dir, name + ".log");
        int count = 1;
        while (logFile.exists()) {
            logFile = new File(dir, name + " (" + count++ + ").log");
        }
        try {
            LOGGER.info("Logging output from '" + name + "' to " + logFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to write log file location", e);
        }
        return new Console(logFile);
    }

    public static class ConsoleBuilder
    implements ApplicationConsoleBuilder {
        private AbstractTestLogs m_testLogs;
        private List<Pair<Predicate<String>, EventsApplicationConsole.Listener>> stdOutListeners = new ArrayList<Pair<Predicate<String>, EventsApplicationConsole.Listener>>();
        private List<Pair<Predicate<String>, EventsApplicationConsole.Listener>> stdErrListeners = new ArrayList<Pair<Predicate<String>, EventsApplicationConsole.Listener>>();

        public ConsoleBuilder(AbstractTestLogs testLogs) {
            this.m_testLogs = testLogs;
        }

        public ApplicationConsole build(String name) {
            Console console = (Console)this.m_testLogs.build(name);
            this.stdOutListeners.stream().filter(pair -> pair.getX() == null).map(Pair::getY).forEach(arg_0 -> ((Console)console).withStdOutListener(arg_0));
            this.stdErrListeners.stream().filter(pair -> pair.getX() == null).map(Pair::getY).forEach(arg_0 -> ((Console)console).withStdErrListener(arg_0));
            this.stdOutListeners.stream().filter(pair -> pair.getX() != null).forEach(pair -> console.withStdOutListener((Predicate)pair.getX(), (EventsApplicationConsole.Listener)pair.getY()));
            this.stdErrListeners.stream().filter(pair -> pair.getX() != null).forEach(pair -> console.withStdErrListener((Predicate)pair.getX(), (EventsApplicationConsole.Listener)pair.getY()));
            return console;
        }

        public void clearListeners() {
            this.stdErrListeners.clear();
            this.stdOutListeners.clear();
        }

        public ConsoleBuilder addStdOutListener(EventsApplicationConsole.Listener listener) {
            this.stdOutListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(null, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdOutListener(Predicate<String> predicate, EventsApplicationConsole.Listener listener) {
            this.stdOutListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(predicate, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdErrListener(EventsApplicationConsole.Listener listener) {
            this.stdErrListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(null, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdErrListener(Predicate<String> predicate, EventsApplicationConsole.Listener listener) {
            this.stdErrListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(predicate, (Object)listener));
            return this;
        }
    }

    public static class Console
    extends EventsApplicationConsole {
        private final File file;
        private final FileWriter writer;

        private Console(File file) {
            try {
                this.file = file;
                this.writer = new FileWriter(file);
                this.withStdOutListener(this::write);
                this.withStdErrListener(this::write);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void write(String line) {
            try {
                this.writer.write(line);
                this.writer.write(10);
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return "Console(file:" + this.file.getName() + ")";
        }
    }
}

