/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.testsupport.junit.options.TestClasses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Tests
implements Option.Collector<TestClasses, Tests> {
    private final List<TestClasses> listOfTestClasses;

    private Tests(List<TestClasses> list) {
        this.listOfTestClasses = list;
    }

    public boolean isEmpty() {
        return this.listOfTestClasses.isEmpty();
    }

    public Iterator<TestClasses> iterator() {
        return this.listOfTestClasses.iterator();
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(TestClasses.class)) {
            return this.listOfTestClasses;
        }
        return Collections.emptyList();
    }

    public Tests with(TestClasses testClasses) {
        ArrayList<TestClasses> list = new ArrayList<TestClasses>(this.listOfTestClasses);
        list.add(testClasses);
        return new Tests(list);
    }

    public Tests with(Tests tests) {
        ArrayList<TestClasses> list = new ArrayList<TestClasses>(this.listOfTestClasses);
        list.addAll(tests.listOfTestClasses);
        return new Tests(list);
    }

    public Tests without(TestClasses testClasses) {
        ArrayList<TestClasses> list = new ArrayList<TestClasses>(this.listOfTestClasses);
        list.remove(testClasses);
        return new Tests(list);
    }

    @OptionsByType.Default
    public static Tests none() {
        return new Tests(Collections.emptyList());
    }
}

