/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class CacheConfig
implements Profile,
Option {
    public static final String PROPERTY = "coherence.cacheconfig";
    private String uri;

    private CacheConfig(String uri) {
        if (uri == null) {
            throw new NullPointerException("CacheConfig must not be null");
        }
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static CacheConfig of(String uri) {
        return new CacheConfig(uri);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.uri, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheConfig)) {
            return false;
        }
        CacheConfig executable = (CacheConfig)o;
        return this.uri.equals(executable.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "CacheConfig(uri='" + this.uri + "')";
    }
}

