/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hnswlib;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.hnswlib.Hnswlib;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.tangosol.util.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

final class HnswlibFactory {
    private static Hnswlib instance;

    private HnswlibFactory() {
    }

    static synchronized Hnswlib getInstance() {
        if (instance == null) {
            try {
                HnswlibFactory.checkIfLibraryProvidedNeedsToBeLoadedIntoSO();
                instance = (Hnswlib)Native.load((String)Hnswlib.LIBRARY_NAME, Hnswlib.class);
            }
            catch (IOException | NullPointerException | UnsatisfiedLinkError e) {
                Logger.err((String)"Failed to load Coherence HNSW library", (Throwable)e);
                throw new UnsatisfiedLinkError("It's not possible to use the pre-generated dynamic libraries on your system. Please compile it yourself (if not done yet) and set the \"jna.library.path\" property with correct path to where \"" + HnswlibFactory.getLibraryFileName() + "\" is located.");
            }
        }
        return instance;
    }

    private static String getLibraryFileName() {
        String extension = Platform.isLinux() ? "so" : (Platform.isWindows() ? "dll" : "dylib");
        return String.format("libhnswlib-%s.%s", Platform.ARCH, extension);
    }

    private static void copyPreGeneratedLibraryFiles(Path folder, String fileName) throws IOException {
        URL url = Resources.findFileOrResource((String)fileName, (ClassLoader)Classes.getContextClassLoader());
        InputStream libraryStream = url.openStream();
        Files.copy(libraryStream, folder.resolve(fileName.replace(".libw", ".lib")), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void checkIfLibraryProvidedNeedsToBeLoadedIntoSO() throws IOException {
        String property = System.getProperty("jna.library.path");
        if (property == null) {
            Path libraryFolder = Files.createTempDirectory(Hnswlib.LIBRARY_NAME, new FileAttribute[0]);
            HnswlibFactory.copyPreGeneratedLibraryFiles(libraryFolder, HnswlibFactory.getLibraryFileName());
            if (Platform.isWindows()) {
                HnswlibFactory.copyPreGeneratedLibraryFiles(libraryFolder, "libhnswlib-x86-64.exp");
                HnswlibFactory.copyPreGeneratedLibraryFiles(libraryFolder, "libhnswlib-x86-64.libw");
            }
            System.setProperty("jna.library.path", libraryFolder.toString());
            libraryFolder.toFile().deleteOnExit();
        } else {
            Logger.info((String)("Coherence HNSW: jna.library.path set to: " + property));
        }
    }
}

