/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hnswlib;

import com.oracle.coherence.hnswlib.ConcurrentIndex;
import com.oracle.coherence.hnswlib.Hnswlib;
import com.oracle.coherence.hnswlib.HnswlibFactory;
import com.oracle.coherence.hnswlib.QueryTuple;
import com.oracle.coherence.hnswlib.SpaceName;
import com.oracle.coherence.hnswlib.exception.IndexAlreadyInitializedException;
import com.oracle.coherence.hnswlib.exception.IndexNotInitializedException;
import com.oracle.coherence.hnswlib.exception.ItemCannotBeInsertedIntoTheVectorSpaceException;
import com.oracle.coherence.hnswlib.exception.OnceIndexIsClearedItCannotBeReusedException;
import com.oracle.coherence.hnswlib.exception.UnableToCreateNewIndexInstanceException;
import com.oracle.coherence.hnswlib.exception.UnexpectedNativeException;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Optional;

public class Index
implements Closeable {
    protected static final int NO_ID = -1;
    private static final int RESULT_SUCCESSFUL = 0;
    private static final int RESULT_QUERY_NO_RESULTS = 3;
    private static final int RESULT_ITEM_CANNOT_BE_INSERTED_INTO_THE_VECTOR_SPACE = 4;
    private static final int RESULT_ONCE_INDEX_IS_CLEARED_IT_CANNOT_BE_REUSED = 5;
    private static final int RESULT_INDEX_NOT_INITIALIZED = 8;
    private static final Hnswlib hnswlib = HnswlibFactory.getInstance();
    private Pointer reference;
    private volatile boolean initialized;
    private volatile boolean cleared;
    private volatile boolean referenceReused;
    private final SpaceName spaceName;
    private final int dimension;

    public Index(SpaceName spaceName, int dimension) {
        this.spaceName = spaceName;
        this.dimension = dimension;
        this.reference = hnswlib.createNewIndex(spaceName.toString(), dimension);
        if (this.reference == null) {
            throw new UnableToCreateNewIndexInstanceException();
        }
    }

    public static float[] normalize(float[] array) {
        int n = array.length;
        float norm = 0.0f;
        for (float v : array) {
            norm += v * v;
        }
        norm = (float)(1.0 / (Math.sqrt(norm) + (double)1.0E-30f));
        for (int i = 0; i < n; ++i) {
            array[i] = array[i] * norm;
        }
        return array;
    }

    public static Index synchronizedIndex(Index index) {
        ConcurrentIndex concurrentIndex = new ConcurrentIndex(index.spaceName, index.dimension);
        concurrentIndex.reference = index.reference;
        concurrentIndex.cleared = index.cleared;
        concurrentIndex.initialized = index.initialized;
        index.referenceReused = true;
        return concurrentIndex;
    }

    public void initialize() {
        this.initialize(1000000);
    }

    public void initialize(int maxNumberOfElements) {
        this.initialize(maxNumberOfElements, 16, 200, 100, false);
    }

    public void initialize(int maxNumberOfElements, int m, int efConstruction, int randomSeed, boolean allowReplaceDeleted) {
        if (this.initialized) {
            throw new IndexAlreadyInitializedException();
        }
        this.checkResultCode(hnswlib.initNewIndex(this.reference, maxNumberOfElements, m, efConstruction, randomSeed, allowReplaceDeleted));
        this.initialized = true;
    }

    public void addItem(float[] item) {
        this.addItem(item, -1, false);
    }

    public void addItem(float[] item, int id) {
        this.addItem(item, id, false);
    }

    public void addItem(float[] item, int id, boolean replaceDeleted) {
        this.checkResultCode(hnswlib.addItemToIndex(this.reference, item, id, replaceDeleted));
    }

    public int getLength() {
        return hnswlib.getIndexLength(this.reference);
    }

    public int getMaxLength() {
        return hnswlib.getMaxIndexLength(this.reference);
    }

    void resize(int maxSize) {
        hnswlib.resizeIndex(this.reference, maxSize);
    }

    public QueryTuple knnQuery(float[] input, int k) {
        return this.knnQuery(input, k, null);
    }

    public QueryTuple knnQuery(float[] input, int k, Hnswlib.QueryFilter filter) {
        int length = this.getLength();
        if (length == 0) {
            this.checkIndexIsInitialized();
            return QueryTuple.EMPTY;
        }
        int kActual = Math.min(k, length);
        QueryTuple queryTuple = new QueryTuple(kActual);
        if (filter == null) {
            boolean empty = this.checkResultCode(hnswlib.knnQuery(this.reference, input, kActual, queryTuple.ids, queryTuple.coefficients));
            if (empty) {
                return QueryTuple.EMPTY;
            }
        } else {
            CapturingFilter capturingFilter = new CapturingFilter(kActual, filter);
            boolean empty = this.checkResultCode(hnswlib.knnFilterQuery(this.reference, input, kActual, capturingFilter, queryTuple.ids, queryTuple.coefficients));
            if (empty) {
                if (capturingFilter.count == 0) {
                    return QueryTuple.EMPTY;
                }
                int[] ids = capturingFilter.ids;
                queryTuple = new QueryTuple(ids);
                queryTuple.count(capturingFilter.count);
                float[] coefficients = queryTuple.coefficients;
                for (int i = 0; i < capturingFilter.count; ++i) {
                    float[] vector = new float[this.dimension];
                    hnswlib.getData(this.reference, ids[i], vector, this.dimension);
                    coefficients[i] = this.computeSimilarity(input, vector);
                }
            }
        }
        return queryTuple;
    }

    public void save(Path path) {
        this.checkResultCode(hnswlib.saveIndexToPath(this.reference, path.toAbsolutePath().toString()));
    }

    public void load(Path path, int maxNumberOfElements) {
        this.checkResultCode(hnswlib.loadIndexFromPath(this.reference, maxNumberOfElements, path.toAbsolutePath().toString()));
    }

    public void clear() {
        this.checkResultCode(hnswlib.clearIndex(this.reference));
        this.cleared = true;
    }

    @Override
    public void close() {
        if (!this.cleared && !this.referenceReused) {
            this.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private boolean checkResultCode(int resultCode) {
        switch (resultCode) {
            case 0: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new ItemCannotBeInsertedIntoTheVectorSpaceException();
            }
            case 5: {
                throw new OnceIndexIsClearedItCannotBeReusedException();
            }
            case 8: {
                throw new IndexNotInitializedException();
            }
        }
        throw new UnexpectedNativeException();
    }

    public boolean hasId(int id) {
        return hnswlib.hasId(this.reference, id) == 0;
    }

    public Optional<float[]> getData(int id) {
        float[] vector = new float[this.dimension];
        int success = hnswlib.getData(this.reference, id, vector, this.dimension);
        if (success == 0) {
            return Optional.of(vector);
        }
        return Optional.empty();
    }

    public float computeSimilarity(float[] vector1, float[] vector2) {
        this.checkIndexIsInitialized();
        return hnswlib.computeSimilarity(this.reference, vector1, vector2);
    }

    public int getM() {
        this.checkIndexIsInitialized();
        return hnswlib.getM(this.reference);
    }

    public int getEf() {
        this.checkIndexIsInitialized();
        return hnswlib.getEf(this.reference);
    }

    public void setEf(int ef) {
        this.checkResultCode(hnswlib.setEf(this.reference, ef));
    }

    public int getEfConstruction() {
        this.checkIndexIsInitialized();
        return hnswlib.getEfConstruction(this.reference);
    }

    public void markDeleted(int id) {
        this.checkResultCode(hnswlib.markDeleted(this.reference, id));
    }

    private void checkIndexIsInitialized() {
        if (!this.initialized) {
            throw new IndexNotInitializedException();
        }
    }

    protected static class CapturingFilter
    implements Hnswlib.QueryFilter {
        private final int max;
        private final int[] ids;
        private final Hnswlib.QueryFilter delegate;
        private int count;

        public CapturingFilter(int k, Hnswlib.QueryFilter delegate) {
            this.max = k;
            this.ids = new int[k];
            this.delegate = delegate;
            this.count = 0;
        }

        @Override
        public boolean filter(int id) {
            boolean match = this.delegate.filter(id);
            if (match && this.count < this.max) {
                this.ids[this.count++] = id;
            }
            return match;
        }
    }
}

