/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ons.ConfigurationException;
import oracle.ons.DefaultSocketManager;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ThreadPoolWorkloadManager;
import oracle.ons.spi.SocketManager;
import oracle.ons.spi.WorkloadManager;

public class NotificationManager {
    private WorkloadManager wm;
    private SocketManager sm;
    private final AtomicInteger activeNetworks = new AtomicInteger(0);
    Logger logger = Logger.getLogger(ONS.class.getCanonicalName());
    private final ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> networks = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Node> nodes = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Long> nodeHistory = new ConcurrentHashMap();
    private static volatile NotificationManager instance = null;
    private volatile MaintenanceTask maintenanceTask = null;

    private NotificationManager(WorkloadManager wm, SocketManager sm) {
        String debugprop = System.getProperty("oracle.ons.debug", "none");
        this.logger.setUseParentHandlers(false);
        if (debugprop.equalsIgnoreCase("true")) {
            this.logger.setLevel(Level.ALL);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(consoleHandler);
        }
        this.wm = wm;
        this.sm = sm;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(WorkloadManager wm, SocketManager sm) throws ONSException {
        Class<NotificationManager> clazz = NotificationManager.class;
        synchronized (NotificationManager.class) {
            if (instance != null) {
                throw new ConfigurationException("Only one implicit ONS Manager is allowed per JVM");
            }
            instance = new NotificationManager(wm != null ? wm : new ThreadPoolWorkloadManager(), sm != null ? sm : new DefaultSocketManager());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void initialize() throws ONSException {
        NotificationManager.initialize(null, null);
    }

    public static NotificationManager getNotificationManager() {
        if (instance == null) {
            try {
                NotificationManager.initialize();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return instance;
    }

    protected WorkloadManager getWorkloadManager() {
        return this.wm;
    }

    protected SocketManager getSocketManager() {
        return this.sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotificationNetwork getNetwork(ONSConfiguration configuration) throws ONSException {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            NotificationNetwork network;
            WeakReference<NotificationNetwork> n = this.networks.get(configuration.getFingerprint());
            NotificationNetwork notificationNetwork = network = n == null ? null : (NotificationNetwork)n.get();
            if (network == null) {
                this.logger.log(Level.FINE, "Creating notification network (implicit) : " + configuration.toString());
                network = new NotificationNetwork(configuration);
                this.networks.put(configuration.getFingerprint(), new WeakReference<NotificationNetwork>(network));
            }
            return network;
        }
    }

    protected void onNodeUp(Node node) {
        this.logger.fine("ONS node up : " + node.toString());
    }

    protected void onNodeDown(Node node) {
        this.logger.fine("ONS node down : " + node.toString());
        this.nodes.remove(node.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ONSConfiguration.NodeList nodeList, Set<NodeAddress> localAddressList, int maxConnections, NotificationNetwork network) {
        int connectedCount = 0;
        if (maxConnections == 0) {
            return;
        }
        if (nodeList.failedTo != null) {
            maxConnections = 1;
        }
        ArrayList<NodeAddress> fullNodeList = new ArrayList<NodeAddress>();
        fullNodeList.addAll(localAddressList);
        Iterator iterator = fullNodeList.iterator();
        while (iterator.hasNext()) {
            Node node = this.nodes.get(iterator.next());
            if (node == null) continue;
            this.logger.finest("Node found : " + node.getAddress().toString());
            ++connectedCount;
            iterator.remove();
        }
        if (connectedCount >= maxConnections) {
            return;
        }
        Collections.sort(fullNodeList, new Comparator<NodeAddress>(){

            @Override
            public int compare(NodeAddress x, NodeAddress y) {
                Long xstamp = (Long)NotificationManager.this.nodeHistory.get(x);
                Long ystamp = (Long)NotificationManager.this.nodeHistory.get(y);
                if (xstamp != null && ystamp != null) {
                    return xstamp.compareTo(ystamp);
                }
                if (xstamp != null) {
                    return 1;
                }
                if (ystamp != null) {
                    return -1;
                }
                return 0;
            }
        });
        for (NodeAddress nodeAddress : fullNodeList) {
            Node tryNode;
            Node node = this.nodes.putIfAbsent(nodeAddress, tryNode = new Node(this, nodeAddress, network.config));
            if (node == null) {
                node = tryNode;
                this.logger.finest("Trying node : " + node.getAddress().toString());
            }
            if (!node.register(network)) continue;
            this.nodeHistory.put(nodeAddress, System.currentTimeMillis());
            NotificationNetwork notificationNetwork = network;
            synchronized (notificationNetwork) {
                nodeList.pending.add(node);
            }
            if (node.isConnected()) {
                network.onNodeUp(node);
            }
            if (++connectedCount < maxConnections) continue;
            break;
        }
    }

    protected void onNetworkUp(NotificationNetwork network) {
        if (this.maintenanceTask == null) {
            this.maintenanceTask = new MaintenanceTask();
            this.wm.scheduleDelayed(this.maintenanceTask, Node.PING_TIMEOUT / 2L);
        }
        this.activeNetworks.incrementAndGet();
    }

    protected void onNetworkDown(NotificationNetwork network) {
        this.networks.remove(network.config.getFingerprint());
        this.activeNetworks.decrementAndGet();
    }

    private class MaintenanceTask
    implements Runnable {
        private MaintenanceTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList nodeList = new ArrayList();
            ArrayList<NotificationNetwork> networkList = new ArrayList<NotificationNetwork>();
            long time = System.currentTimeMillis();
            int connectedNodes = 0;
            Iterator iterator = NotificationManager.this.networks;
            synchronized (iterator) {
                for (WeakReference n : NotificationManager.this.networks.values()) {
                    NotificationNetwork x = (NotificationNetwork)n.get();
                    if (x == null) continue;
                    networkList.add(x);
                }
            }
            for (NotificationNetwork notificationNetwork : networkList) {
                notificationNetwork.releaseIfUnused();
            }
            nodeList.addAll(NotificationManager.this.nodes.values());
            for (Node node : nodeList) {
                if (node.isConnected()) {
                    node.checkConnection(time);
                }
                if (node.isGarbage()) continue;
                ++connectedNodes;
            }
            if (connectedNodes == 0) {
                NotificationManager.this.maintenanceTask = null;
            } else if (NotificationManager.this.maintenanceTask == this) {
                NotificationManager.this.wm.scheduleDelayed(NotificationManager.this.maintenanceTask, Node.PING_TIMEOUT / 2L);
            }
        }
    }
}

