/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.sql.BFILE;
import oracle.sql.OPAQUE;

@ProxyFor(value={oracle.jdbc.internal.OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableStatement
extends TxnReplayableBase
implements JDBCReplayable,
OracleStatement.BindChecksumListener {
    private static final Method GETCLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getClob", Integer.TYPE);
    private static final Method GETCLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getClob", String.class);
    private static final Method GETNCLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getNClob", Integer.TYPE);
    private static final Method GETNCLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getNClob", String.class);
    private static final Method GETBLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getBlob", Integer.TYPE);
    private static final Method GETBLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getBlob", String.class);
    private static final Method GETBFILE_METHOD = TxnReplayableStatement.getGetLobMethod("getBfile", Integer.TYPE);
    private static final Method GETOBJECT_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE);
    private static final Method GETOBJECT_WITH_TYPE_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE, Class.class);
    private static final Method GETOBJECT_WITH_MAP_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE, Map.class);
    private static final Method GETOBJECT_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getObject", String.class);
    private static final Method GETOBJECT_WITH_NAME_AND_TYPE_METHOD = TxnReplayableStatement.getMethod("getObject", String.class, Class.class);
    private static final Method GETOBJECT_WITH_NAME_AND_MAP_METHOD = TxnReplayableStatement.getMethod("getObject", String.class, Map.class);
    private static final Method GETREF_METHOD = TxnReplayableStatement.getMethod("getRef", Integer.TYPE);
    private static final Method GETREF_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getRef", String.class);
    private static final Method GETARRAY_METHOD = TxnReplayableStatement.getMethod("getArray", Integer.TYPE);
    private static final Method GETARRAY_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getArray", String.class);

    protected TxnReplayableStatement() {
        this.thisProxyNameInLog = "STMT" + this.thisProxyNameInLog;
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected void preForExecuteQuery(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="sendBatch", args={}), @Signature(name="executeBatch", args={})})
    protected void preForBatches(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="getOPAQUE", args={int.class}), @Signature(name="setOPAQUE", args={String.class, OPAQUE.class}), @Signature(name="setOPAQUE", args={int.class, OPAQUE.class}), @Signature(name="setOPAQUEAtName", args={String.class, OPAQUE.class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setBlob", args={String.class, InputStream.class}), @Signature(name="setBlob", args={String.class, InputStream.class, long.class}), @Signature(name="setClob", args={String.class, Reader.class}), @Signature(name="setClob", args={String.class, Reader.class, long.class}), @Signature(name="setNClob", args={String.class, Reader.class}), @Signature(name="setNClob", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setUnicodeStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBlob", args={int.class, InputStream.class}), @Signature(name="setBlob", args={int.class, InputStream.class, long.class}), @Signature(name="setClob", args={int.class, Reader.class}), @Signature(name="setClob", args={int.class, Reader.class, long.class}), @Signature(name="setNClob", args={int.class, Reader.class}), @Signature(name="setNClob", args={int.class, Reader.class, long.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBlobAtName", args={String.class, InputStream.class}), @Signature(name="setBlobAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setClobAtName", args={String.class, Reader.class}), @Signature(name="setClobAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNClobAtName", args={String.class, Reader.class}), @Signature(name="setNClobAtName", args={String.class, Reader.class, long.class})})
    protected void preForSetStreams(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setObject", args={String.class, Object.class}), @Signature(name="setObject", args={String.class, Object.class, int.class}), @Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @Signature(name="setObject", args={int.class, Object.class}), @Signature(name="setObject", args={int.class, Object.class, int.class}), @Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
    protected void preForSetObjects(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (objectArray[1] instanceof InputStream || objectArray[1] instanceof Reader) {
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        } else {
            this.preForAll(method, object, objectArray);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="getResultSet", args={})})
    protected ResultSet postForGetResultSet(Method method, ResultSet resultSet) {
        this.postForAll(method, resultSet);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry = this.tailSameProxy;
                    while (callHistoryEntry != this.headSameProxy) {
                        if ("execute".equals(callHistoryEntry.method.getName()) && callHistoryEntry.result instanceof Integer) {
                            ((TxnReplayableResultSet)((Object)resultSet)).creatorCallEntry = callHistoryEntry;
                        }
                        callHistoryEntry = callHistoryEntry.prevEntrySameProxy;
                    }
                    break;
                }
            }
        }
        return resultSet;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method method, ResultSet resultSet) {
        this.postForAll(method, resultSet);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    ((TxnReplayableResultSet)((Object)resultSet)).creatorCallEntry = this.tailSameProxy;
                    break;
                }
            }
        }
        return resultSet;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(int n2) throws SQLException {
        if (GETCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(int)");
        }
        Method method = GETCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Clob clob = callableStatement.getClob(n2);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(String string) throws SQLException {
        if (GETCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(String)");
        }
        Method method = GETCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Clob clob = callableStatement.getClob(string);
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(int n2) throws SQLException {
        if (GETNCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(int)");
        }
        Method method = GETNCLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            NClob nClob = callableStatement.getNClob(n2);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(String string) throws SQLException {
        if (GETNCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(String)");
        }
        Method method = GETNCLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            NClob nClob = callableStatement.getNClob(string);
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(int n2) throws SQLException {
        if (GETBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(int)");
        }
        Method method = GETBLOB_METHOD;
        this.preForAll(method, this, n2);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Blob blob = callableStatement.getBlob(n2);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(String string) throws SQLException {
        if (GETBLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(String)");
        }
        Method method = GETBLOB_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Blob blob = callableStatement.getBlob(string);
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(int n2) throws SQLException {
        if (GETBFILE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(int)");
        }
        Method method = GETBFILE_METHOD;
        this.preForAll(method, this, n2);
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.getDelegate();
            BFILE bFILE = oracleCallableStatement.getBfile(n2);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2) throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int)");
        }
        Method method = GETOBJECT_METHOD;
        this.preForAll(method, this, n2);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Object object = callableStatement.getObject(n2);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int,Class<T>)");
        }
        Method method = GETOBJECT_WITH_TYPE_METHOD;
        this.preForAll(method, this, n2, clazz);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            T t2 = callableStatement.getObject(n2, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int, Map)");
        }
        Method method = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(method, this, n2, map);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Object object = callableStatement.getObject(n2, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string) throws SQLException {
        if (GETOBJECT_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String)");
        }
        Method method = GETOBJECT_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Object object = callableStatement.getObject(string);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String,Class<T>)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
        this.preForAll(method, this, string, clazz);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            T t2 = callableStatement.getObject(string, clazz);
            if (!(t2 instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(method, proxyFactory.proxyFor(t2));
            }
            return (T)this.postForAll(method, t2);
        }
        catch (SQLException sQLException) {
            return (T)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String, Map)");
        }
        Method method = GETOBJECT_WITH_NAME_AND_MAP_METHOD;
        this.preForAll(method, this, string, map);
        try {
            ProxyFactory proxyFactory;
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Object object = callableStatement.getObject(string, map);
            if (!(object instanceof OracleConcreteProxy) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(int n2) throws SQLException {
        if (GETREF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(int)");
        }
        Method method = GETREF_METHOD;
        this.preForAll(method, this, n2);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Ref ref = callableStatement.getRef(n2);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(String string) throws SQLException {
        if (GETREF_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(String)");
        }
        Method method = GETREF_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Ref ref = callableStatement.getRef(string);
            return (Ref)this.postForAll(method, ref);
        }
        catch (SQLException sQLException) {
            return (Ref)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(int n2) throws SQLException {
        if (GETARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(int)");
        }
        Method method = GETARRAY_METHOD;
        this.preForAll(method, this, n2);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Array array = callableStatement.getArray(n2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(String string) throws SQLException {
        if (GETARRAY_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(String)");
        }
        Method method = GETARRAY_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            CallableStatement callableStatement = (CallableStatement)this.getDelegate();
            Array array = callableStatement.getArray(string);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    private static final Method getGetLobMethod(String string, Class<?> clazz) {
        try {
            return oracle.jdbc.internal.OracleCallableStatement.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getMethod(String string, Class<?> ... classArray) {
        try {
            return oracle.jdbc.internal.OracleCallableStatement.class.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method method, SQLException sQLException) throws SQLException {
        if (sQLException instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public boolean shouldContinue(long l2) {
        boolean bl = true;
        TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry = this.failoverMngr.getCallHistoryTail();
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.currentBindChecksum = l2;
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                if (callHistoryEntry.checksum == 0L) break;
                if (callHistoryEntry.checksum == l2) break;
                this.failoverMngr.disableReplayInternal(callHistoryEntry.method, 388, "Replay failed because of checksum mismatch", null);
                bl = false;
            }
        }
        callHistoryEntry = null;
        return bl;
    }
}

