/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

@Supports(value={Feature.CONNECT})
@DefaultLogger(value="oracle.jdbc")
final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName = null;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    static final int ZTVT_SHA512 = 18453;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ = true;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final int KPZ_LOGON_SYSBKP = 0x1000000;
    static final int KPZ_LOGON_SYSDGD = 0x2000000;
    static final int KPZ_LOGON_SYSKMT = 0x4000000;
    static final int KPZ_CPW_AUTH = 16;
    static final int KPZ_OPASSWD_ENCRYPTED = 32;
    static final int KPZ_NPASSWD_ENCRYPTED = 64;
    static final int KPZ_NPASSWD_OBFUSCATE = 65536;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_NEWPASSWORD = "AUTH_NEWPASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_DB_ID = "AUTH_DB_ID";
    static final String AUTH_QCACHE_MAXSIZE = "AUTH_QCACHE_MAXSIZE";
    static final String AUTH_QCACHE_CACHELAG = "AUTH_QCACHE_CACHELAG";
    static final String AUTH_GLOBALLY_UNIQUE_DBID = "AUTH_GLOBALLY_UNIQUE_DBID";
    static final String AUTH_QCACHE_CACHEID = "AUTH_QCACHE_CACHEID";
    static final String AUTH_QCACHE_REGID = "AUTH_QCACHE_REGID";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SC_DB_DOMAIN = "AUTH_SC_DB_DOMAIN";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXNLSCOMP = "AUTH_NLS_LXNLSCOMP";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String AUTH_KPPL_CONN_CLASS = "AUTH_KPPL_CONN_CLASS";
    static final String AUTH_KPPL_PURITY = "AUTH_KPPL_PURITY";
    static final String AUTH_KPPL_TAG = "AUTH_KPPL_TAG";
    static final String AUTH_KPPL_IS_MULTIPROP_TAG = "AUTH_KPPL_IS_MULTIPROP_TAG";
    static final String AUTH_KPPL_FIXUP_CB = "AUTH_KPPL_FIXUP_CB";
    static final String AUTH_KPPL_WAIT = "AUTH_KPPL_WAIT";
    static final String AUTH_PBKDF2_SPEEDY_KEY = "AUTH_PBKDF2_SPEEDY_KEY";
    static final String KPPL_PURITY_DEFAULT = "0";
    static final String KPPL_PURITY_NEW = "1";
    static final String KPPL_PURITY_SELF = "2";
    static final String SESS_PURITY_DEFAULT = "DEFAULT";
    static final String SESS_PURITY_NEW = "NEW";
    static final String SESS_PURITY_SELF = "SELF";
    static final String[][] KPPL_PURITY = new String[][]{{"DEFAULT", "0"}, {"NEW", "1"}, {"SELF", "2"}};
    static final String AUTH_CONNECT_STRING = "AUTH_CONNECT_STRING";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_AUDIT_BANNER = "AUTH_AUDIT_BANNER";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    public static final int AUTH_FLAG_O5LOGON = 0;
    public static final int AUTH_FLAG_NONO5LOGON = 1;
    String sessionTimeZone = null;
    private T4CKvaldfList keyValList = null;
    private byte[] user = null;
    private long logonMode;
    private byte[][] outKeys = null;
    private byte[][] outValues = null;
    private int[] outFlags = new int[0];
    private int outNbPairs = 0;
    private byte[] PBKDF2Salt;
    private int PBKDF2VgenCount;
    private int PBKDF2SderCount;
    O5Logon o5logonHelper = null;

    T4CTTIoauthenticate(T4CConnection t4CConnection, String string) throws SQLException {
        super(t4CConnection, (byte)3);
        this.ressourceManagerId = string;
        this.setSessionFields(t4CConnection);
        this.isSessionTZ = true;
        this.bUseO5Logon = false;
    }

    @Override
    void marshal() throws IOException {
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(this.logonMode);
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalCHR(this.user);
        }
        this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
    }

    private void doOAUTH(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) throws IOException, SQLException {
        this.setFunCode((short)115);
        this.user = byArray;
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        this.initializeLogonModeForOAUTH(byArray, l2, byArray2, string, bl);
        if (byArray3 != null) {
            this.initializeForOAUTHWithNewPassword(byArray3);
        }
        this.setPasswordKeyValsForOAUTH(byArray2, byArray7);
        this.setProxyLogonKeyValsForOAUTH(byArray4, byArray5, byArray6);
        this.setVSessionKeyValsForOAUTH();
        this.setInternalNameKeyValsForOAUTH();
        this.setAlterSessionKeyValsForOAUTH();
        this.setDriverIdentityKeyValsForOAUTH();
        this.setSessionIdentityKeyValsForOAUTH(n2, n3);
        this.setDRCPKeyValsForOAUTH();
        this.setResultSetCacheKeyValsForOAUTH();
        this.setMiscellaneousKeyValsForOAUTH();
        this.resetStateBeforeCall();
        this.doRPC();
    }

    private final CompletionStage<Void> doOAUTHAsync(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) {
        try {
            this.setFunCode((short)115);
            this.user = byArray;
            this.keyValList = new T4CKvaldfList(this.meg.conv);
            this.initializeLogonModeForOAUTH(byArray, l2, byArray2, string, bl);
            if (byArray3 != null) {
                this.initializeForOAUTHWithNewPassword(byArray3);
            }
            this.setPasswordKeyValsForOAUTH(byArray2, byArray7);
            this.setProxyLogonKeyValsForOAUTH(byArray4, byArray5, byArray6);
            this.setVSessionKeyValsForOAUTH();
            this.setInternalNameKeyValsForOAUTH();
            this.setAlterSessionKeyValsForOAUTH();
            this.setDriverIdentityKeyValsForOAUTH();
            this.setSessionIdentityKeyValsForOAUTH(n2, n3);
            this.setDRCPKeyValsForOAUTH();
            this.setResultSetCacheKeyValsForOAUTH();
            this.setMiscellaneousKeyValsForOAUTH();
            this.resetStateBeforeCall();
        }
        catch (SQLException sQLException) {
            return CompletionStageUtil.failedStage(sQLException);
        }
        return this.doRPCAsync();
    }

    private final void initializeLogonModeForOAUTH(byte[] byArray, long l2, @Blind byte[] byArray2, String string, boolean bl) {
        this.logonMode = l2 | 1L;
        if (this.connection.isResultSetCacheEnabled) {
            this.logonMode |= 0x800000L;
        }
        if (bl) {
            this.logonMode |= 0x400L;
        }
        if (byArray != null && byArray.length != 0 && byArray2 != null && string != "RADIUS") {
            this.logonMode |= 0x100L;
        }
    }

    private final void initializeForOAUTHWithNewPassword(@Blind byte[] byArray) throws SQLException {
        this.logonMode |= 0x12L;
        this.logonMode ^= 1L;
        this.keyValList.add(AUTH_NEWPASSWORD, byArray);
    }

    private final void setPasswordKeyValsForOAUTH(@Blind byte[] byArray, byte[] byArray2) throws SQLException {
        if (byArray != null) {
            this.keyValList.add(AUTH_PASSWORD, byArray);
        }
        if (byArray2 != null) {
            this.keyValList.add(AUTH_PBKDF2_SPEEDY_KEY, byArray2);
        }
        if (this.bUseO5Logon && this.encryptedKB != null) {
            this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
        }
    }

    private final void setProxyLogonKeyValsForOAUTH(byte[] byArray, byte[] byArray2, byte[][] byArray3) throws SQLException {
        if (byArray3 != null) {
            for (int i2 = 0; i2 < byArray3.length; ++i2) {
                this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, byArray3[i2]);
            }
        }
        if (byArray != null) {
            this.keyValList.add(AUTH_CLIENT_DN, byArray);
        }
        if (byArray2 != null) {
            this.keyValList.add(AUTH_CLIENT_CERTIFICATE, byArray2);
        }
    }

    private final void setVSessionKeyValsForOAUTH() throws SQLException {
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        if (this.clientname != null) {
            this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
    }

    private final void setInternalNameKeyValsForOAUTH() throws SQLException {
        if (!this.ressourceManagerId.equals("0000")) {
            byte[] byArray = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            byArray[byArray.length - 1] = 0;
            this.keyValList.add(byArray, this.internalName);
            byArray = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            byArray[byArray.length - 1] = 0;
            this.keyValList.add(byArray, this.externalName);
        }
    }

    private final void setDriverIdentityKeyValsForOAUTH() throws SQLException {
        if (this.editionName != null) {
            this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
        }
        this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
        this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
    }

    private final void setMiscellaneousKeyValsForOAUTH() throws SQLException {
        this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
        this.keyValList.add(AUTH_CONNECT_STRING, this.meg.conv.StringToCharBytes(this.connection.net().getConnectionString()));
        this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
        this.keyValList.add(AUTH_ACL, this.aclValue);
    }

    private final void setAlterSessionKeyValsForOAUTH() throws SQLException {
        this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
    }

    private final void setSessionIdentityKeyValsForOAUTH(int n2, int n3) throws SQLException {
        if (n2 != -1) {
            this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString(n2)));
        }
        if (n3 != -1) {
            this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString(n3)));
        }
    }

    private final void setDRCPKeyValsForOAUTH() throws SQLException {
        if (this.connection.drcpEnabled) {
            if (this.connection.drcpConnectionClass != null && this.connection.drcpConnectionClass != "") {
                this.keyValList.add(AUTH_KPPL_CONN_CLASS, this.meg.conv.StringToCharBytes(this.connection.drcpConnectionClass));
            }
            this.keyValList.add(AUTH_KPPL_PURITY, this.meg.conv.StringToCharBytes(this.getKPPLPurity()));
            if (this.connection.drcpTagName != null) {
                this.keyValList.add(AUTH_KPPL_TAG, this.meg.conv.StringToCharBytes(this.connection.drcpTagName));
                if (this.connection.useDRCPMultipletag) {
                    this.keyValList.add(AUTH_KPPL_IS_MULTIPROP_TAG, this.meg.conv.StringToCharBytes("TRUE"));
                }
            }
            if (this.connection.drcpPLSQLCallback != null && this.connection.drcpPLSQLCallback.length() > 0 && this.connection.getTTCVersion() >= 8) {
                this.keyValList.add(AUTH_KPPL_FIXUP_CB, this.meg.conv.StringToCharBytes(this.connection.drcpPLSQLCallback));
            }
        }
    }

    private final void setResultSetCacheKeyValsForOAUTH() throws SQLException {
        if (this.connection.isResultSetCacheActive()) {
            this.keyValList.add(AUTH_QCACHE_CACHEID, this.connection.getResultSetCacheIdAsNibbles());
            this.keyValList.add(AUTH_QCACHE_REGID, this.meg.conv.StringToCharBytes(Long.toString(this.connection.getResultSetCacheRegistrationId())));
        }
    }

    private final void resetStateBeforeCall() {
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
    }

    void doOSESSKEY(String string, long l2) throws IOException, SQLException {
        this.initializeForOSESSKEY(string, l2);
        this.doRPC();
    }

    final CompletionStage<Void> doOSESSKEYAsync(String string, long l2) {
        try {
            this.initializeForOSESSKEY(string, l2);
        }
        catch (SQLException sQLException) {
            return CompletionStageUtil.failedStage(sQLException);
        }
        return this.doRPCAsync();
    }

    private final void initializeForOSESSKEY(String string, long l2) throws SQLException {
        this.setFunCode((short)118);
        this.user = this.meg.conv.StringToCharBytes(string);
        this.logonMode = l2 | 1L;
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        this.keyValList.add(AUTH_SID, this.sysUserName);
        this.resetStateBeforeCall();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.outNbPairs = this.meg.unmarshalUB2();
        this.outKeys = new byte[this.outNbPairs][];
        this.outValues = new byte[this.outNbPairs][];
        this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
    }

    @Override
    void processError() throws SQLException {
        if (this.getFunCode() == 118) {
            if (this.oer.getRetCode() != 28035L || this.connection.net().getAuthenticationAdaptorName() != "RADIUS") {
                this.oer.processError();
            }
        } else {
            super.processError();
        }
    }

    @Override
    protected void processRPA() throws SQLException {
        if (this.getFunCode() == 115) {
            Properties properties = new Properties();
            for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                String string = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                String string2 = "";
                if (this.outValues[i2] != null) {
                    string2 = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                }
                properties.setProperty(string, string2);
            }
            String string = properties.getProperty(AUTH_VERSION_NO);
            if (string != null) {
                try {
                    int n2 = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            properties.setProperty("SERVER_HOST", properties.getProperty(AUTH_SC_SERVER_HOST, ""));
            properties.setProperty("INSTANCE_NAME", properties.getProperty(AUTH_SC_INSTANCE_NAME, ""));
            properties.setProperty("DATABASE_NAME", properties.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
            properties.setProperty("SERVICE_NAME", properties.getProperty(AUTH_SC_SERVICE_NAME, ""));
            properties.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
            if (this.connection.sessionProperties != null) {
                this.connection.sessionProperties.putAll((Map<?, ?>)properties);
            } else {
                this.connection.sessionProperties = properties;
            }
        } else if (this.getFunCode() == 118) {
            int n3;
            Properties properties = new Properties();
            for (n3 = 0; n3 < this.outNbPairs; ++n3) {
                String string = this.meg.conv.CharBytesToString(this.outKeys[n3], this.outKeys[n3].length).trim();
                String string3 = "";
                if (this.outValues[n3] != null) {
                    string3 = this.meg.conv.CharBytesToString(this.outValues[n3], this.outValues[n3].length).trim();
                }
                if (string.compareTo(AUTH_GLOBALLY_UNIQUE_DBID) != 0 && string.compareTo(AUTH_QCACHE_MAXSIZE) != 0 && string.compareTo(AUTH_QCACHE_CACHELAG) != 0) continue;
                properties.setProperty(string, string3);
            }
            if (this.connection.sessionProperties != null) {
                this.connection.sessionProperties.putAll((Map<?, ?>)properties);
            } else {
                this.connection.sessionProperties = properties;
            }
            if (this.connection.net().getAuthenticationAdaptorName() != "RADIUS") {
                if (this.outKeys == null || this.outKeys.length < 1) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                }
                n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                try {
                    for (int i3 = 0; i3 < this.outKeys.length; ++i3) {
                        String string = new String(this.outKeys[i3], "US-ASCII");
                        if (string.equals(AUTH_SESSKEY)) {
                            n3 = i3;
                        } else if (string.equals(AUTH_VFR_DATA)) {
                            n4 = i3;
                        } else if (string.equals("AUTH_PBKDF2_CSK_SALT")) {
                            n5 = i3;
                        } else if (string.equals("AUTH_PBKDF2_VGEN_COUNT")) {
                            n6 = i3;
                        } else if (string.equals("AUTH_PBKDF2_SDER_COUNT")) {
                            n7 = i3;
                        }
                        if (n4 == -1 || n3 == -1 || n5 == -1 || n6 == -1 || n7 == -1) {
                            continue;
                        }
                        break;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (n3 == -1) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                }
                this.encryptedSK = this.outValues[n3];
                if (n4 != -1) {
                    this.bUseO5Logon = true;
                    this.salt = this.outValues[n4];
                    this.verifierType = this.outFlags[n4];
                    if (this.connection.allowedLogonVersion.equals("12a") && this.verifierType != 18453) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                    }
                    if (this.connection.allowedLogonVersion.equals("12") && this.verifierType != 18453 && (this.verifierType != 6949 && this.verifierType != 45394 || !this.connection.hasServerCompileTimeCapability(4, 2))) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                    }
                }
                if (n5 != -1) {
                    this.PBKDF2Salt = this.outValues[n5];
                }
                if (n6 != -1) {
                    try {
                        this.PBKDF2VgenCount = Integer.parseInt(new String(this.outValues[n6], "US-ASCII"));
                        if (this.PBKDF2VgenCount < 4096) {
                            this.PBKDF2VgenCount = 4096;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n7 != -1) {
                    try {
                        this.PBKDF2SderCount = Integer.parseInt(new String(this.outValues[n7], "US-ASCII"));
                        if (this.PBKDF2SderCount < 3) {
                            this.PBKDF2SderCount = 3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                }
            }
        }
    }

    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2) throws IOException, SQLException {
        this.doOAUTH(string, string2, string3, l2, -1, -1, null);
    }

    final CompletionStage<Void> doOAUTHAsync(String string, @Blind String string2, @Blind String string3, long l2) {
        return this.doOAUTHAsync(string, string2, string3, l2, -1, -1, null);
    }

    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2, int n2, int n3, byte[][] byArray) throws IOException, SQLException {
        String string4 = this.connection.net().getAuthenticationAdaptorName();
        if (string != null && string.length() != 0) {
            byte[] byArray2 = this.meg.conv.StringToCharBytes(string);
            boolean bl = "RADIUS".equals(string4);
            this.validateKeySizeForOAUTH(bl);
            if (string2 != null) {
                String string5 = this.sanitizeInputCredential(string2);
                byte[] byArray3 = this.meg.conv.StringToCharBytes(string5);
                if (bl) {
                    this.doOAUTHWithRadiusAuthentication(byArray3, byArray2, l2, string4, n2, n3, byArray);
                } else {
                    String string6 = this.sanitizeInputCredential(string);
                    if (this.bUseO5Logon) {
                        this.doOAUTHWithO5Logon(string6, string5, byArray3, string3, byArray2, l2, string4, n2, n3, byArray);
                    } else {
                        this.doOAUTHWithO3Logon(string6, string5, byArray3, byArray2, l2, string4, n2, n3, byArray);
                    }
                }
            } else {
                this.doOAUTHWithoutPassword(byArray2, l2, string4, n2, n3, byArray);
            }
        } else {
            this.doOAUTHWithoutUser(l2, string4, n2, n3, byArray);
            if ("KERBEROS5".equals(string4)) {
                this.connection.net().doKeyFoldinForExternalAuth();
            }
        }
    }

    final CompletionStage<Void> doOAUTHAsync(String string, @Blind String string2, @Blind String string3, long l2, int n2, int n3, byte[][] byArray) {
        String string4 = this.connection.net().getAuthenticationAdaptorName();
        if (string != null && string.length() != 0) {
            byte[] byArray2;
            try {
                byArray2 = this.meg.conv.StringToCharBytes(string);
            }
            catch (SQLException sQLException) {
                return CompletionStageUtil.failedStage(sQLException);
            }
            boolean bl = "RADIUS".equals(string4);
            try {
                this.validateKeySizeForOAUTH(bl);
            }
            catch (SQLException sQLException) {
                return CompletionStageUtil.failedStage(sQLException);
            }
            if (string2 != null) {
                byte[] byArray3;
                String string5 = this.sanitizeInputCredential(string2);
                try {
                    byArray3 = this.meg.conv.StringToCharBytes(string5);
                }
                catch (SQLException sQLException) {
                    return CompletionStageUtil.failedStage(sQLException);
                }
                if (bl) {
                    return this.doOAUTHWithRadiusAuthenticationAsync(byArray3, byArray2, l2, string4, n2, n3, byArray);
                }
                String string6 = this.sanitizeInputCredential(string);
                if (this.bUseO5Logon) {
                    return this.doOAUTHWithO5LogonAsync(string6, string5, byArray3, string3, byArray2, l2, string4, n2, n3, byArray);
                }
                return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported with databases  older than version 12"));
            }
            return this.doOAUTHWithoutPasswordAsync(byArray2, l2, string4, n2, n3, byArray);
        }
        CompletionStage<Void> completionStage = this.doOAUTHWithoutUserAsync(l2, string4, n2, n3, byArray);
        if ("KERBEROS5".equals(string4)) {
            completionStage = completionStage.thenRun(() -> this.connection.net().doKeyFoldinForExternalAuth());
        }
        return completionStage;
    }

    private final void validateKeySizeForOAUTH(boolean bl) throws SQLException {
        if (!bl && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
        }
        if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
        }
    }

    private final String sanitizeInputCredential(@Blind String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            return this.removeQuotes(string2);
        }
        return string2;
    }

    private final void doOAUTHWithO5Logon(String string, @Blind String string2, @Blind byte[] byArray, @Blind String string3, byte[] byArray2, long l2, String string4, int n2, int n3, byte[][] byArray3) throws SQLException, IOException {
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        int[] nArray;
        byte[] byArray7;
        String string5;
        boolean bl;
        this.lazyLoadO5LogonHelper();
        this.validateO5VerifierType();
        int[] nArray2 = new int[1];
        byte[] byArray8 = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            byArray8[i2] = 0;
        }
        boolean bl2 = bl = string3 != null;
        if (bl) {
            string5 = this.sanitizeInputCredential(string3);
            byArray7 = this.meg.conv.StringToCharBytes(string5);
            nArray = new int[1];
            byArray6 = new byte[256];
            for (int i3 = 0; i3 < 256; ++i3) {
                byArray6[i3] = 0;
            }
        } else {
            string5 = null;
            byArray7 = null;
            nArray = null;
            byArray6 = null;
        }
        int[] nArray3 = new int[1];
        byte[] byArray9 = new byte[256];
        this.encryptedKB = new byte[this.encryptedSK.length];
        for (int i4 = 0; i4 < this.encryptedKB.length; ++i4) {
            this.encryptedKB[i4] = 1;
        }
        try {
            this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, string, string2, string5, byArray, byArray7, this.encryptedSK, this.encryptedKB, byArray8, byArray6, nArray2, nArray, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, byArray9, nArray3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray10 = new byte[nArray2[0]];
        System.arraycopy(byArray8, 0, byArray10, 0, nArray2[0]);
        if (bl) {
            byArray5 = new byte[nArray[0]];
            System.arraycopy(byArray6, 0, byArray5, 0, nArray[0]);
        } else {
            byArray5 = null;
        }
        if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
            byArray4 = new byte[nArray3[0]];
            System.arraycopy(byArray9, 0, byArray4, 0, nArray3[0]);
        } else {
            byArray4 = null;
        }
        this.doOAUTH(byArray2, byArray10, byArray5, l2, string4, n2 != -1 && n3 != -1, null, null, byArray3, n2, n3, byArray4);
        this.validateO5ServerResponse();
    }

    private final CompletionStage<Void> doOAUTHWithO5LogonAsync(String string, @Blind String string2, @Blind byte[] byArray, @Blind String string3, byte[] byArray2, long l2, String string4, int n2, int n3, byte[][] byArray3) {
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        int[] nArray;
        byte[] byArray7;
        String string5;
        boolean bl;
        this.lazyLoadO5LogonHelper();
        try {
            this.validateO5VerifierType();
        }
        catch (SQLException sQLException) {
            return CompletionStageUtil.failedStage(sQLException);
        }
        int[] nArray2 = new int[1];
        byte[] byArray8 = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            byArray8[i2] = 0;
        }
        boolean bl2 = bl = string3 != null;
        if (bl) {
            string5 = this.sanitizeInputCredential(string3);
            try {
                byArray7 = this.meg.conv.StringToCharBytes(string5);
            }
            catch (SQLException sQLException) {
                return CompletionStageUtil.failedStage(sQLException);
            }
            nArray = new int[1];
            byArray6 = new byte[256];
            for (int i3 = 0; i3 < 256; ++i3) {
                byArray6[i3] = 0;
            }
        } else {
            string5 = null;
            byArray7 = null;
            nArray = null;
            byArray6 = null;
        }
        int[] nArray3 = new int[1];
        byte[] byArray9 = new byte[256];
        this.encryptedKB = new byte[this.encryptedSK.length];
        for (int i4 = 0; i4 < this.encryptedKB.length; ++i4) {
            this.encryptedKB[i4] = 1;
        }
        try {
            this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, string, string2, string5, byArray, byArray7, this.encryptedSK, this.encryptedKB, byArray8, byArray6, nArray2, nArray, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, byArray9, nArray3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray10 = new byte[nArray2[0]];
        System.arraycopy(byArray8, 0, byArray10, 0, nArray2[0]);
        if (bl) {
            byArray5 = new byte[nArray[0]];
            System.arraycopy(byArray6, 0, byArray5, 0, nArray[0]);
        } else {
            byArray5 = null;
        }
        if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
            byArray4 = new byte[nArray3[0]];
            System.arraycopy(byArray9, 0, byArray4, 0, nArray3[0]);
        } else {
            byArray4 = null;
        }
        return this.doOAUTHAsync(byArray2, byArray10, byArray5, l2, string4, n2 != -1 && n3 != -1, null, null, byArray3, n2, n3, byArray4).thenRun(() -> {
            try {
                this.validateO5ServerResponse();
            }
            catch (SQLException sQLException) {
                throw new CompletionException(sQLException);
            }
        });
    }

    private final void lazyLoadO5LogonHelper() {
        if (this.o5logonHelper == null) {
            this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
        }
    }

    private final void validateO5VerifierType() throws SQLException {
        if (this.verifierType != 2361 && this.verifierType != 40674 && this.verifierType != 59694 && this.verifierType != 45394 && this.verifierType != 6949 && this.verifierType != 18453) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 451).fillInStackTrace();
        }
    }

    private final void validateO5ServerResponse() throws SQLException {
        String string = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
        try {
            this.lazyLoadO5LogonHelper();
            if (!this.o5logonHelper.validateServerIdentity(string)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
            }
            this.connection.net().setAuthSessionKey(this.o5logonHelper.getO5LogonKey());
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
        }
    }

    private final void doOAUTHWithO3Logon(String string, @Blind String string2, @Blind byte[] byArray, byte[] byArray2, long l2, String string3, int n2, int n3, byte[][] byArray3) throws SQLException, IOException {
        O3LoginClientHelper o3LoginClientHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte, this.connection.thinUseJCEAPI);
        byte[] byArray4 = o3LoginClientHelper.getSessionKey(string, string2, this.encryptedSK);
        byte[] byArray5 = null;
        byte by = byArray.length % 8 > 0 ? (byte)((byte)(8 - byArray.length % 8)) : (byte)0;
        byArray5 = new byte[byArray.length + by];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        byte[] byArray6 = o3LoginClientHelper.getEPasswd(byArray4, byArray5);
        byte[] byArray7 = new byte[2 * byArray5.length + 1];
        if (byArray7.length < 2 * byArray6.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
        }
        RepConversion.bArray2Nibbles(byArray6, byArray7);
        byArray7[byArray7.length - 1] = RepConversion.nibbleToHex(by);
        this.doOAUTH(byArray2, byArray7, null, l2, string3, n2 != -1 && n3 != -1, null, null, byArray3, n2, n3, null);
        this.connection.net().setAuthSessionKey(byArray4);
    }

    private final void doOAUTHWithRadiusAuthentication(@Blind byte[] byArray, byte[] byArray2, long l2, String string, int n2, int n3, byte[][] byArray3) throws IOException, SQLException {
        byte[] byArray4;
        boolean bl = this.connection.net().getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter;
        if (bl) {
            byArray4 = byArray;
        } else {
            byte[] byArray5 = null;
            int n4 = (byArray.length + 1) % 8 > 0 ? (int)((byte)(8 - (byArray.length + 1) % 8)) : 0;
            byArray5 = new byte[byArray.length + 1 + n4];
            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
            byte[] byArray6 = AuthenticationService.obfuscatePasswordForRadius(byArray5);
            byArray4 = new byte[byArray6.length * 2];
            for (int i2 = 0; i2 < byArray6.length; ++i2) {
                byte by = (byte)((byArray6[i2] & 0xF0) >> 4);
                byte by2 = (byte)(byArray6[i2] & 0xF);
                byArray4[i2 * 2] = (byte)(by < 10 ? by + 48 : by - 10 + 97);
                byArray4[i2 * 2 + 1] = (byte)(by2 < 10 ? by2 + 48 : by2 - 10 + 97);
            }
        }
        this.doOAUTH(byArray2, byArray4, null, l2, string, n2 != -1 && n3 != -1, null, null, byArray3, n2, n3, null);
        this.doKeyFoldinForRadius(byArray);
    }

    private void doKeyFoldinForRadius(byte[] byArray) {
        try {
            if (!this.connection.net().getSessionAttributes().profile.useWeakCrypto() && (this.connection.net().getSessionAttributes().isEncryptionActive || this.connection.net().getSessionAttributes().isChecksumActive)) {
                this.connection.net().setAuthSessionKey(MessageDigest.getInstance("MD5").digest(byArray));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get foldin key for RADIUS");
        }
    }

    private final CompletionStage<Void> doOAUTHWithRadiusAuthenticationAsync(@Blind byte[] byArray, byte[] byArray2, long l2, String string, int n2, int n3, byte[][] byArray3) {
        byte[] byArray4;
        boolean bl = this.connection.net().getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter;
        if (bl) {
            byArray4 = byArray;
        } else {
            byte[] byArray5 = null;
            int n4 = (byArray.length + 1) % 8 > 0 ? (int)((byte)(8 - (byArray.length + 1) % 8)) : 0;
            byArray5 = new byte[byArray.length + 1 + n4];
            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
            byte[] byArray6 = AuthenticationService.obfuscatePasswordForRadius(byArray5);
            byArray4 = new byte[byArray6.length * 2];
            for (int i2 = 0; i2 < byArray6.length; ++i2) {
                byte by = (byte)((byArray6[i2] & 0xF0) >> 4);
                byte by2 = (byte)(byArray6[i2] & 0xF);
                byArray4[i2 * 2] = (byte)(by < 10 ? by + 48 : by - 10 + 97);
                byArray4[i2 * 2 + 1] = (byte)(by2 < 10 ? by2 + 48 : by2 - 10 + 97);
            }
        }
        return this.doOAUTHAsync(byArray2, byArray4, null, l2, string, n2 != -1 && n3 != -1, null, null, byArray3, n2, n3, null).thenRun(() -> this.doKeyFoldinForRadius(byArray));
    }

    private final void doOAUTHWithoutUser(long l2, String string, int n2, int n3, byte[][] byArray) throws IOException, SQLException {
        this.doOAUTHWithoutPassword(null, l2, string, n2, n3, byArray);
    }

    private final CompletionStage<Void> doOAUTHWithoutUserAsync(long l2, String string, int n2, int n3, byte[][] byArray) {
        return this.doOAUTHWithoutPasswordAsync(null, l2, string, n2, n3, byArray);
    }

    private final void doOAUTHWithoutPassword(byte[] byArray, long l2, String string, int n2, int n3, byte[][] byArray2) throws IOException, SQLException {
        this.doOAUTH(byArray, null, null, l2, string, n2 != -1 && n3 != -1, null, null, byArray2, n2, n3, null);
    }

    private final CompletionStage<Void> doOAUTHWithoutPasswordAsync(byte[] byArray, long l2, String string, int n2, int n3, byte[][] byArray2) {
        return this.doOAUTHAsync(byArray, null, null, l2, string, n2 != -1 && n3 != -1, null, null, byArray2, n2, n3, null);
    }

    void doOAUTH(int n2, @Blind(value=PropertiesBlinder.class) Properties properties, int n3, int n4) throws IOException, SQLException {
        Object object;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Object object2 = null;
        byte[] byArray3 = null;
        if (properties.containsKey("PROXY_ROLES")) {
            object = (String[])properties.get("PROXY_ROLES");
            object2 = new byte[((String[])object).length][];
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                object2[i2] = this.meg.conv.StringToCharBytes(object[i2]);
            }
        }
        if (n2 == 1) {
            object = properties.getProperty("PROXY_USER_NAME");
            String string = properties.getProperty("PROXY_USER_PASSWORD");
            if (string != null && string.length() != 0) {
                this.doOAUTH((String)object, string, null, 0L, n3, n4, (byte[][])object2);
                return;
            }
            byArray3 = this.meg.conv.StringToCharBytes((String)object);
        } else if (n2 == 2) {
            object = properties.getProperty("PROXY_DISTINGUISHED_NAME");
            byArray = this.meg.conv.StringToCharBytes((String)object);
        } else {
            try {
                byArray2 = (byte[])properties.get("PROXY_CERTIFICATE");
                object = new StringBuffer();
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    String string = Integer.toHexString(0xFF & byArray2[i3]);
                    int n5 = string.length();
                    if (n5 == 0) {
                        ((StringBuffer)object).append("00");
                        continue;
                    }
                    if (n5 == 1) {
                        ((StringBuffer)object).append('0');
                        ((StringBuffer)object).append(string);
                        continue;
                    }
                    ((StringBuffer)object).append(string);
                }
                byArray2 = this.meg.conv.StringToCharBytes(((StringBuffer)object).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doOAUTH(byArray3, null, null, 0L, null, true, byArray, byArray2, (byte[][])object2, n3, n4, null);
    }

    private void setSessionFields(T4CConnection t4CConnection) throws SQLException {
        String string = this.connection.thinVsessionTerminal;
        String string2 = this.connection.thinVsessionMachine;
        String string3 = this.connection.thinVsessionOsuser;
        String string4 = this.connection.thinVsessionProgram;
        String string5 = this.connection.thinVsessionProcess;
        String string6 = this.connection.thinVsessionIname;
        String string7 = this.connection.thinVsessionEname;
        String string8 = this.connection.proxyClientName;
        String string9 = this.connection.driverNameAttribute;
        String string10 = this.connection.editionName;
        byte[] byArray = this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? this.meg.conv.StringToCharBytes(Integer.toString(1)) : this.meg.conv.StringToCharBytes(Integer.toString(0));
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string2 = "jdbcclient";
            }
        }
        if (string7 == null) {
            string7 = "jdbc_" + this.ressourceManagerId;
        }
        if (string9 == null) {
            string9 = "jdbcthin : " + BuildInfo.getDriverVersion();
        }
        this.terminal = this.meg.conv.StringToCharBytes(string);
        this.machine = this.meg.conv.StringToCharBytes(string2);
        this.sysUserName = this.meg.conv.StringToCharBytes(string3);
        this.programName = this.meg.conv.StringToCharBytes(string4);
        this.processID = this.meg.conv.StringToCharBytes(string5);
        this.internalName = this.meg.conv.StringToCharBytes(string6);
        this.externalName = this.meg.conv.StringToCharBytes(string7);
        if (string8 != null) {
            this.clientname = this.meg.conv.StringToCharBytes(string8);
        }
        if (string10 != null) {
            this.editionName = this.meg.conv.StringToCharBytes(string10);
        }
        this.driverName = this.meg.conv.StringToCharBytes(string9);
        TimeZone timeZone = TimeZone.getDefault();
        String string11 = timeZone.getID();
        if (!ZONEIDMAP.isValidRegion(string11) || !t4CConnection.timezoneAsRegion) {
            int n2 = timeZone.getOffset(System.currentTimeMillis());
            int n3 = n2 / 3600000;
            int n4 = Math.abs(n2 / 60000 % 60);
            string11 = (n3 < 0 ? "" + n3 : "+" + n3) + (n4 < 10 ? ":0" + n4 : ":" + n4);
        }
        this.sessionTimeZone = string11;
        t4CConnection.sessionTimeZone = string11;
        String string12 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault(Locale.Category.FORMAT));
        String string13 = null;
        if (string12 != null) {
            string13 = " NLS_LANGUAGE='" + string12 + "' ";
        }
        String string14 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault(Locale.Category.FORMAT));
        String string15 = null;
        if (string14 != null) {
            string15 = " NLS_TERRITORY='" + string14 + "' ";
        }
        if (string13 != null || string15 != null || this.isSessionTZ) {
            String string16 = "ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + (string13 != null ? string13 : "") + (string15 != null ? string15 : "");
            this.alterSession = this.meg.conv.StringToCharBytes(string16);
            this.alterSession[this.alterSession.length - 1] = 0;
        }
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
    }

    String removeQuotes(@Blind String string) {
        int n2;
        int n3 = 0;
        int n4 = string.length() - 1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == '\"') continue;
            n3 = n2;
            break;
        }
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            if (string.charAt(n2) == '\"') continue;
            n4 = n2;
            break;
        }
        String string2 = string.substring(n3, n4 + 1);
        return string2;
    }

    private int versionStringToInt(String string) throws SQLException {
        String[] stringArray = string.split("\\.");
        int n2 = Integer.parseInt(stringArray[0].replaceAll("\\D", "")) & 0xFF;
        int n3 = Integer.parseInt(stringArray[1].replaceAll("\\D", "")) & 0xFF;
        int n4 = Integer.parseInt(stringArray[2].replaceAll("\\D", "")) & 0xF;
        int n5 = Integer.parseInt(stringArray[3].replaceAll("\\D", "")) & 0xFF;
        int n6 = Integer.parseInt(stringArray[4].replaceAll("\\D", "")) & 0xF;
        int n7 = 0;
        n7 = this.connection.getTTCVersion() >= 10 ? n2 << 24 | n3 << 16 | n4 << 12 | n5 << 4 | n6 : n2 << 24 | n3 << 20 | n4 << 12 | n5 << 4 | n6;
        return n7;
    }

    private String versionIntToString(int n2) throws SQLException {
        String string;
        if (this.connection.getTTCVersion() >= 10) {
            int n3 = (n2 & 0xFF000000) >> 24 & 0xFF;
            int n4 = (n2 & 0xFF0000) >> 16 & 0xFF;
            int n5 = (n2 & 0xF000) >> 12 & 0xF;
            int n6 = (n2 & 0xFF0) >> 4 & 0xFF;
            int n7 = n2 & 0xF;
            string = "" + n3 + "." + n4 + "." + n5 + "." + n6 + "." + n7;
        } else {
            int n8 = (n2 & 0xFF000000) >> 24 & 0xFF;
            int n9 = (n2 & 0xF00000) >> 20 & 0xF;
            int n10 = (n2 & 0xFF000) >> 12 & 0xFF;
            int n11 = (n2 & 0xF00) >> 8 & 0xF;
            int n12 = n2 & 0xFF;
            string = "" + n8 + "." + n9 + "." + n10 + "." + n11 + "." + n12;
        }
        return string;
    }

    private String getKPPLPurity() throws SQLException {
        for (String[] stringArray : KPPL_PURITY) {
            if (!this.connection.drcpConnectionPurity.equalsIgnoreCase(stringArray[0])) continue;
            return stringArray[1];
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 297).fillInStackTrace();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    public byte[] getDerivedKeyJdbc(byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        n2 = this.verifierType == 2361 ? (n2 |= 1) : (n2 |= 0);
        if (this.o5logonHelper == null) {
            this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
        }
        return this.o5logonHelper.getDerivedKey(byArray, n2);
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

