/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;

class T4CIntervalymAccessor
extends IntervalymAccessor {
    T4CMAREngine mare;

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        this.setOffset(this.lastRowProcessed);
        int len = this.statement.maxFieldSize > 0 ? ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize) : ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
        this.processIndicator(len);
        this.setLength(this.lastRowProcessed, len);
        this.setNull(this.lastRowProcessed, len == 0);
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    T4CIntervalymAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isStoredInBindData, T4CMAREngine _mare) throws SQLException {
        super(stmt, 5, form, external_type, isStoredInBindData);
        this.mare = _mare;
    }

    T4CIntervalymAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 5, nullable, flags, precision, scale, contflag, total_elems, form);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case -103: {
                return this.getINTERVALYM(currentRow);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        final VectorMetaData vectorMetaData = this.getVectorMetaData();
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CIntervalymAccessor acc = new T4CIntervalymAccessor(stmt, T4CIntervalymAccessor.this.describeMaxLength, T4CIntervalymAccessor.this.nullable, -1, T4CIntervalymAccessor.this.precision, T4CIntervalymAccessor.this.scale, T4CIntervalymAccessor.this.contflag, -1, T4CIntervalymAccessor.this.formOfUse, T4CIntervalymAccessor.this.definedColumnType, T4CIntervalymAccessor.this.definedColumnSize, null);
                acc.setVectorMetaData(vectorMetaData);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

