/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.jdbc.downloadmanager.DependencyDownloader;
import oracle.jdbc.downloadmanager.DependencyInfo;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DependencyDownloaderImpl
implements DependencyDownloader {
    private final Map<String, DependencyInfo> resolvedDependencies = new HashMap<String, DependencyInfo>();
    private List<DependencyInfo> availablePackages = new ArrayList<DependencyInfo>();
    private Set<DependencyInfo> dependencySet = new HashSet<DependencyInfo>();
    private final Set<String> SKIPPED_SCOPES = new HashSet<String>();
    private Exception firstException;

    public DependencyDownloaderImpl() {
        this.SKIPPED_SCOPES.add("test");
        this.SKIPPED_SCOPES.add("provided");
        this.SKIPPED_SCOPES.add("system");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DependencyInfo> listAvailableJDBCExtensions() throws IOException, Exception {
        String url = this.getMavenSearchUrl("FETCH_EXTENSIONS", "com.oracle.database.jdbc");
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) throw new Exception("Failed to fetch extensions from Maven Central. HTTP response code: " + responseCode + ". URL: " + url + ". This could be caused by network issues, incorrect proxy configuration, or Maven Central being unavailable.");
        OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
            OracleJsonObject jsonResponse = JSON_FACTORY.createJsonTextValue(reader).asJsonObject();
            if (!jsonResponse.containsKey("response")) {
                throw new Exception("Failed to parse response from Maven Central. The JSON response does not contain the expected 'response' field. URL: " + url + ". Response: " + jsonResponse);
            }
            OracleJsonObject responseObject = ((OracleJsonValue)jsonResponse.get("response")).asJsonObject();
            if (!responseObject.containsKey("docs")) {
                throw new Exception("Failed to parse response from Maven Central. The JSON response's 'response' field does not contain the expected 'docs' field. URL: " + url + ". Response: " + jsonResponse);
            }
            OracleJsonArray docs = ((OracleJsonValue)responseObject.get("docs")).asJsonArray();
            for (int i = 0; i < docs.size(); ++i) {
                OracleJsonObject doc = docs.getObject(i);
                if (doc.getString("a") == null || !doc.getString("a").startsWith("ojdbc-provider-") || doc.getString("a").equals("ojdbc-provider-common")) continue;
                DependencyInfo extensionPackage = new DependencyInfo(doc.getString("g"), doc.getString("a"), doc.getString("latestVersion"), null);
                this.availablePackages.add(extensionPackage);
            }
            List<DependencyInfo> list = this.availablePackages;
            return list;
        }
        catch (IOException e) {
            throw new Exception("Failed to read or parse the JSON response from Maven Central. Ensure the network is accessible and Maven Central is reachable. URL: " + url, e);
        }
    }

    private void ensurePath(String path) throws IOException {
        if (Files.notExists(Paths.get(path, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            System.out.println("Directory created at: " + this.normalizePath(Paths.get(path, new String[0]).toAbsolutePath().toString()));
        } else {
            System.out.println("Using existing directory: " + this.normalizePath(Paths.get(path, new String[0]).toAbsolutePath().toString()));
        }
    }

    @Override
    public Set<DependencyInfo> downloadDependencies(DependencyInfo selectedPackage, String path) throws Exception {
        this.ensurePath(path);
        try {
            this.downloadDependency(selectedPackage, path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path pomPath = this.downloadPomFile(selectedPackage.groupId, selectedPackage.artifactId, selectedPackage.version, path);
        System.out.println("Downloaded POM for: " + selectedPackage);
        this.parsePomForDependencies(pomPath, null);
        for (DependencyInfo dependency : this.dependencySet) {
            if (dependency.artifactId.matches("ojdbc\\d+")) continue;
            this.downloadDependency(dependency, path);
        }
        System.out.println("All dependencies downloaded for: " + selectedPackage + " at: " + this.normalizePath(Paths.get(path, new String[0]).toAbsolutePath().toString()));
        String newClasspath = this.normalizePath(path);
        this.printClasspathInstructions(newClasspath);
        return this.dependencySet;
    }

    private Path downloadPomFile(String groupId, String artifactId, String version, String downloadPath) throws IOException {
        if (version == null) {
            try {
                version = this.fetchLatestVersion(groupId, artifactId);
            }
            catch (Exception e) {
                throw new IOException("Failed to find the latest version for artifact: " + groupId + ":" + artifactId + ". Ensure that the artifact exists in the repository or check your network connection.", e);
            }
        }
        String url = this.getMavenRepoUrl("DOWNLOAD_POM", groupId.replace(".", "/"), artifactId, version, null);
        Path pomPath = Paths.get(downloadPath, artifactId + "-" + version + ".pom");
        try (InputStream in = new URL(url).openStream();){
            Files.copy(in, pomPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IOException("Failed to download POM file for artifact: " + groupId + ":" + artifactId + ":" + version + ". URL: " + url + ". Ensure the repository is reachable and the artifact exists.", e);
        }
        return pomPath;
    }

    private void parsePomForDependencies(Path pomPath, Map<String, String> inheritedProperties) throws Exception {
        if (this.firstException != null) {
            return;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pomPath.toFile());
            doc.getDocumentElement().normalize();
            HashMap<String, String> properties = inheritedProperties != null ? inheritedProperties : new HashMap<String, String>();
            HashMap<String, String> childProperties = new HashMap<String, String>(properties);
            this.handleParentPom(doc, properties);
            this.collectProperties(doc, properties);
            this.resolveDependencyManagement(doc, properties, pomPath);
            NodeList nodeList = this.extractDependencies(doc);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Path depPomPath;
                DependencyInfo dependency;
                String optional;
                String depArtifactId;
                String depGroupId;
                Element depElement = (Element)nodeList.item(i);
                if (depElement == null) continue;
                String rawGroupId = this.extractTextContent(depElement, "groupId");
                String rawArtifactId = this.extractTextContent(depElement, "artifactId");
                if (rawGroupId == null || rawArtifactId == null || this.isExcluded(depElement, depGroupId = this.resolvePlaceholder(rawGroupId, properties), depArtifactId = this.resolvePlaceholder(rawArtifactId, properties)) || depElement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "optional").getLength() > 0 && Boolean.parseBoolean(optional = this.extractTextContent(depElement, "optional"))) continue;
                String depVersion = this.resolveVersion(depElement, depGroupId, depArtifactId, properties);
                if (depVersion.contains("[") || depVersion.contains("(")) {
                    depVersion = this.resolveVersion(depGroupId, depArtifactId, depVersion);
                }
                String depClassifier = null;
                if (depElement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "classifier").getLength() > 0) {
                    depClassifier = this.resolvePlaceholder(this.extractTextContent(depElement, "classifier"), properties);
                }
                String key = depGroupId + ":" + depArtifactId + (depClassifier != null ? ":" + depClassifier : "");
                String scope = "compile";
                if (depElement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "scope").getLength() > 0) {
                    scope = this.extractTextContent(depElement, "scope");
                } else if (this.resolvedDependencies.containsKey(key)) {
                    scope = this.resolvedDependencies.get((Object)key).scope;
                }
                if (this.SKIPPED_SCOPES.contains(scope) || !this.dependencySet.add(dependency = new DependencyInfo(depGroupId, depArtifactId, depVersion, depClassifier)) || (depPomPath = this.downloadPom(depGroupId, depArtifactId, depVersion)) == null) continue;
                this.parsePomForDependencies(depPomPath, childProperties);
            }
        }
        catch (Exception e) {
            if (this.firstException == null) {
                this.firstException = new Exception("Failed to parse POM file: " + pomPath.toAbsolutePath() + ". Ensure the file is valid and accessible. Error: " + e.getMessage(), e);
            }
            throw this.firstException;
        }
    }

    private void handleParentPom(Document doc, Map<String, String> properties) throws Exception {
        String parentVersion;
        String parentArtifactId;
        Element parentElement;
        String parentGroupId;
        Path parentPomPath;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("".equals(prefix)) {
                    return DependencyDownloaderImpl.this.getMavenPomNameSpace();
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
        XPathExpression expr = xpath.compile("/*[local-name()='project']/*[local-name()='parent']");
        NodeList parentNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (parentNodes.getLength() > 0 && (parentPomPath = this.downloadPom(parentGroupId = this.extractTextContent(parentElement = (Element)parentNodes.item(0), "groupId"), parentArtifactId = this.extractTextContent(parentElement, "artifactId"), parentVersion = this.extractTextContent(parentElement, "version"))) != null) {
            this.parsePomForDependencies(parentPomPath, properties);
        }
    }

    private void resolveDependencyManagement(Document doc, Map<String, String> properties, Path pomPath) throws Exception {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if ("".equals(prefix)) {
                        return DependencyDownloaderImpl.this.getMavenPomNameSpace();
                    }
                    return null;
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            XPathExpression expr = xpath.compile("/*[local-name()='project']/*[local-name()='dependencyManagement']");
            NodeList dependencyManagementNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (dependencyManagementNodes.getLength() > 0) {
                Element dependencyManagement = (Element)dependencyManagementNodes.item(0);
                NodeList managedDependencies = dependencyManagement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "dependency");
                for (int j = 0; j < managedDependencies.getLength(); ++j) {
                    Element managedDep = (Element)managedDependencies.item(j);
                    String groupId = this.resolvePlaceholder(this.getTextContentSafely(managedDep, "groupId"), properties);
                    String artifactId = this.resolvePlaceholder(this.getTextContentSafely(managedDep, "artifactId"), properties);
                    String version = null;
                    if (managedDep.getElementsByTagNameNS(this.getMavenPomNameSpace(), "version").getLength() > 0) {
                        version = this.resolvePlaceholder(this.getTextContentSafely(managedDep, "version"), properties);
                    }
                    String scope = "compile";
                    if (managedDep.getElementsByTagNameNS(this.getMavenPomNameSpace(), "scope").getLength() > 0) {
                        scope = this.getTextContentSafely(managedDep, "scope");
                    }
                    boolean isBom = false;
                    if (managedDep.getElementsByTagNameNS(this.getMavenPomNameSpace(), "type").getLength() > 0) {
                        String type = this.getTextContentSafely(managedDep, "type");
                        boolean bl = isBom = "pom".equals(type) && "import".equals(scope);
                    }
                    if (isBom) {
                        Path bomPomPath = this.downloadPom(groupId, artifactId, version);
                        if (bomPomPath == null) continue;
                        this.parsePomForDependencies(bomPomPath, properties);
                        continue;
                    }
                    String classifier = null;
                    if (managedDep.getElementsByTagNameNS(this.getMavenPomNameSpace(), "classifier").getLength() > 0) {
                        classifier = this.resolvePlaceholder(managedDep.getElementsByTagNameNS(this.getMavenPomNameSpace(), "classifier").item(0).getTextContent(), properties);
                    }
                    String key = groupId + ":" + artifactId + (classifier != null ? ":" + classifier : "");
                    DependencyInfo dep = new DependencyInfo(groupId, artifactId, version, classifier);
                    dep.scope = scope;
                    this.resolvedDependencies.put(key, dep);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to resolve dependency management for POM file: " + pomPath.toAbsolutePath() + ". Ensure the POM file is valid and contains correct dependency management information. Error: " + e.getMessage(), e);
        }
    }

    private String getTextContentSafely(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagNameNS(this.getMavenPomNameSpace(), tagName);
        if (nodes.getLength() > 0 && nodes.item(0) != null) {
            return nodes.item(0).getTextContent().trim();
        }
        return null;
    }

    private NodeList extractDependencies(Document doc) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("".equals(prefix)) {
                    return DependencyDownloaderImpl.this.getMavenPomNameSpace();
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
        XPathExpression expr = xpath.compile("//*[local-name()='project']/*[local-name()='dependencies']/*[local-name()='dependency']");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        return nodeList;
    }

    private boolean isExcluded(Element depElement, String depGroupId, String depArtifactId) {
        NodeList exclusions = depElement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "exclusion");
        for (int j = 0; j < exclusions.getLength(); ++j) {
            Element exclusion = (Element)exclusions.item(j);
            String excludedGroupId = this.extractTextContent(exclusion, "groupId");
            String excludedArtifactId = this.extractTextContent(exclusion, "artifactId");
            if (excludedGroupId == null || excludedArtifactId == null || !depGroupId.equals(excludedGroupId) || !depArtifactId.equals(excludedArtifactId)) continue;
            return true;
        }
        return false;
    }

    private String resolveVersion(Element depElement, String depGroupId, String depArtifactId, Map<String, String> properties) throws Exception {
        String key = depGroupId + ":" + depArtifactId;
        if (depElement.getElementsByTagNameNS(this.getMavenPomNameSpace(), "version").getLength() > 0) {
            return this.resolvePlaceholder(this.extractTextContent(depElement, "version"), properties);
        }
        if (this.resolvedDependencies.containsKey(key)) {
            return this.resolvedDependencies.get((Object)key).version;
        }
        System.out.println("  Version not specified, fetching latest...");
        return this.fetchLatestVersion(depGroupId, depArtifactId);
    }

    private String resolveVersion(String groupId, String artifactId, String versionRange) throws Exception {
        System.out.println("resolveVersion");
        if (!versionRange.startsWith("[") && !versionRange.startsWith("(")) {
            return versionRange;
        }
        List<String> availableVersions = this.fetchAvailableVersions(groupId, artifactId);
        return this.resolveVersionFromRange(versionRange, availableVersions);
    }

    private void collectProperties(Document doc, Map<String, String> properties) throws Exception {
        Node versionNode;
        Node artifactIdNode;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("".equals(prefix)) {
                    return DependencyDownloaderImpl.this.getMavenPomNameSpace();
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
        XPathExpression expr = xpath.compile("//*[local-name()='properties']/*");
        NodeList propertyNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Node node = propertyNodes.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            properties.put(node.getNodeName(), this.resolvePlaceholder(node.getTextContent(), properties));
        }
        expr = xpath.compile("/*[local-name()='project']/*[local-name()='groupId']");
        Node groupIdNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
        if (groupIdNode != null && groupIdNode.getTextContent() != null) {
            properties.put("project.groupId", groupIdNode.getTextContent());
        }
        if ((artifactIdNode = (Node)(expr = xpath.compile("/*[local-name()='project']/*[local-name()='artifactId']")).evaluate(doc, XPathConstants.NODE)) != null && artifactIdNode.getTextContent() != null) {
            properties.put("project.artifactId", artifactIdNode.getTextContent());
        }
        if ((versionNode = (Node)(expr = xpath.compile("/*[local-name()='project']/*[local-name()='version']")).evaluate(doc, XPathConstants.NODE)) != null && versionNode.getTextContent() != null) {
            properties.put("project.version", versionNode.getTextContent());
        }
    }

    private String resolvePlaceholder(String value, Map<String, String> properties) {
        if (value.startsWith("${") && value.endsWith("}")) {
            String key = value.substring(2, value.length() - 1);
            return properties.getOrDefault(key, value);
        }
        return value;
    }

    private Path downloadPom(String groupId, String artifactId, String version) throws IOException {
        String pomUrl;
        String baseChecksumUrl = pomUrl = this.getMavenRepoUrl("DOWNLOAD_POM", groupId, artifactId, version, null);
        Path tempFile = Files.createTempFile(artifactId + "-" + version, ".pom", new FileAttribute[0]);
        try (InputStream in = new URL(pomUrl).openStream();){
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            if (!this.verifyChecksum(tempFile, baseChecksumUrl)) {
                throw new IOException("Checksum verification failed for POM: " + artifactId + " - File removed.");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to download POM file for artifact: " + groupId + ":" + artifactId + ":" + version + ". URL: " + pomUrl + ". Ensure the artifact exists and the repository is reachable.\n" + e.getMessage(), e);
        }
        return tempFile;
    }

    private void downloadDependency(DependencyInfo dependency, String downloadPath) throws IOException {
        String depUrl;
        String depGroupId = dependency.groupId;
        String depArtifactId = dependency.artifactId;
        String depVersion = dependency.version;
        String depClassifier = dependency.classifier;
        String baseChecksumUrl = depUrl = this.getMavenRepoUrl("DOWNLOAD_JAR", dependency.groupId.replace(".", "/"), dependency.artifactId, dependency.version, dependency.classifier);
        System.out.println("Downloading dependency: " + depArtifactId);
        Path filePath = depClassifier == null ? Paths.get(downloadPath, depArtifactId + "-" + depVersion + ".jar") : Paths.get(downloadPath, depArtifactId + "-" + depVersion + "-" + depClassifier + ".jar");
        try (InputStream in = new URL(depUrl).openStream();){
            Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Downloaded " + depArtifactId + " successfully to " + filePath);
            if (!this.verifyChecksum(filePath, baseChecksumUrl)) {
                throw new IOException("Checksum verification failed for: " + depArtifactId + " - File removed.");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to download dependency: " + depGroupId + ":" + depArtifactId + ":" + depVersion + (depClassifier != null ? ":" + depClassifier : "") + ". URL: " + depUrl + ". Ensure the artifact exists and the repository is reachable.\n" + e.getMessage(), e);
        }
    }

    private String fetchLatestVersion(String groupId, String artifactId) throws Exception {
        System.out.println("fetchLatest");
        List<String> availableVersions = this.fetchAvailableVersions(groupId, artifactId);
        if (!availableVersions.isEmpty()) {
            return availableVersions.get(availableVersions.size() - 1);
        }
        throw new Exception("No stable versions found for " + groupId + ":" + artifactId);
    }

    private String extractTextContent(Element e, String s) {
        Node node = e.getElementsByTagNameNS(this.getMavenPomNameSpace(), s).item(0);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    private String resolveVersionFromRange(String range, List<String> versions) {
        String lowerBound = null;
        String upperBound = null;
        boolean lowerInclusive = false;
        boolean upperInclusive = false;
        if ((range = range.trim()).startsWith("[") || range.startsWith("(")) {
            lowerInclusive = range.startsWith("[");
            int commaIndex = range.indexOf(44);
            if (commaIndex > 0) {
                lowerBound = range.substring(1, commaIndex).trim();
                if (range.endsWith("]") || range.endsWith(")")) {
                    upperInclusive = range.endsWith("]");
                    upperBound = range.substring(commaIndex + 1, range.length() - 1).trim();
                }
            }
        } else {
            return range;
        }
        ArrayList<String> filteredVersions = new ArrayList<String>();
        for (String version : versions) {
            if (!this.isVersionInRange(version, lowerBound, upperBound, lowerInclusive, upperInclusive)) continue;
            filteredVersions.add(version);
        }
        if (!filteredVersions.isEmpty()) {
            return (String)filteredVersions.get(filteredVersions.size() - 1);
        }
        return upperBound;
    }

    private boolean isVersionInRange(String version, String lowerBound, String upperBound, boolean lowerInclusive, boolean upperInclusive) {
        int comparison;
        if (lowerBound != null && ((comparison = this.compareVersions(version, lowerBound)) < 0 || comparison == 0 && !lowerInclusive)) {
            return false;
        }
        return upperBound == null || (comparison = this.compareVersions(version, upperBound)) <= 0 && (comparison != 0 || upperInclusive);
    }

    private int compareVersions(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = v2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (v1 == v2) continue;
            return Integer.compare(v1, v2);
        }
        return 0;
    }

    private void printClasspathInstructions(String newClasspath) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            System.out.println("To add these JARs to your classpath:");
            System.out.println("set CLASSPATH=%CLASSPATH%" + File.pathSeparator + newClasspath);
        } else {
            System.out.println("To add these JARs to your classpath:");
            System.out.println("export CLASSPATH=\"$CLASSPATH" + File.pathSeparator + newClasspath + "\"");
        }
    }

    private String normalizePath(String rawPath) {
        try {
            Path path = Paths.get(rawPath, new String[0]);
            Path normalizedPath = path.toAbsolutePath().normalize();
            return normalizedPath.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to normalize the path: " + rawPath + ". Ensure the path is valid and accessible.", e);
        }
    }

    private String getEnvValue(String key, String defaultValue) {
        return System.getenv().getOrDefault(key, defaultValue);
    }

    private List<String> fetchAvailableVersions(String groupId, String artifactId) throws Exception {
        String url = this.getMavenRepoUrl("FETCH_METADATA", groupId, artifactId, null, null);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("Accept", "application/xml");
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("Failed to fetch metadata. HTTP response code: " + responseCode);
        }
        ArrayList<String> versions = new ArrayList<String>();
        try (InputStream inputStream = connection.getInputStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList versionNodes = document.getElementsByTagName("version");
            for (int i = 0; i < versionNodes.getLength(); ++i) {
                String version = versionNodes.item(i).getTextContent();
                if (!this.isStableVersion(version)) continue;
                versions.add(version);
            }
        }
        catch (Exception e) {
            throw new Exception("Error parsing the XML response", e);
        }
        finally {
            connection.disconnect();
        }
        if (!versions.isEmpty()) {
            return versions;
        }
        throw new Exception("No stable versions found for the specified artifact.");
    }

    private boolean isStableVersion(String version) {
        return !version.toLowerCase().matches(".*(alpha|beta|snapshot).*");
    }

    private String getMavenSearchUrl(String queryType, String ... params) {
        String queryFormat;
        String baseUrl = this.getEnvValue("ORACLE_JDBC_MAVEN_SEARCH_BASE_URL", "https://search.maven.org/solrsearch/select");
        switch (queryType) {
            case "FETCH_EXTENSIONS": {
                queryFormat = this.getEnvValue("MAVEN_SEARCH_FETCH_EXTENSIONS", "q=g:%s&wt=json");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid query type: " + queryType);
            }
        }
        return String.format(baseUrl + "?" + queryFormat, params);
    }

    private String getMavenRepoUrl(String requestType, String groupId, String artifactId, String version, String classifier) {
        String baseRepoUrl = this.getEnvValue("MAVEN_REPO_URL", "https://repo1.maven.org/maven2/");
        switch (requestType) {
            case "FETCH_METADATA": {
                String path = "%s/%s/maven-metadata.xml";
                return String.format(baseRepoUrl + path, groupId.replace(".", "/"), artifactId);
            }
            case "DOWNLOAD_POM": {
                String path = this.getEnvValue("MAVEN_REPO_DOWNLOAD_POM", "%s/%s/%s/%s-%s.pom");
                return String.format(baseRepoUrl + path, groupId.replace(".", "/"), artifactId, version, artifactId, version);
            }
            case "DOWNLOAD_JAR": {
                String path = this.getEnvValue("MAVEN_REPO_DOWNLOAD_JAR", classifier == null ? "%s/%s/%s/%s-%s.jar" : "%s/%s/%s/%s-%s-%s.jar");
                return classifier == null ? String.format(baseRepoUrl + path, groupId.replace(".", "/"), artifactId, version, artifactId, version) : String.format(baseRepoUrl + path, groupId.replace(".", "/"), artifactId, version, artifactId, version, classifier);
            }
        }
        throw new IllegalArgumentException("Invalid request type: " + requestType);
    }

    private String getMavenPomNameSpace() {
        return this.getEnvValue("MAVEN_POM_NAMESPACE_URL", "http://maven.apache.org/POM/4.0.0");
    }

    private boolean verifyChecksum(Path filePath, String baseChecksumUrl) {
        try {
            String computedChecksum;
            String checksumUrl = baseChecksumUrl + ".sha1";
            String expectedChecksum = this.downloadChecksum(checksumUrl);
            if (expectedChecksum == null) {
                checksumUrl = baseChecksumUrl + ".md5";
                expectedChecksum = this.downloadChecksum(checksumUrl);
            }
            if (expectedChecksum == null) {
                System.err.println("No checksum file found for: " + filePath);
                return true;
            }
            if (!(expectedChecksum = expectedChecksum.split(" ")[0]).equalsIgnoreCase(computedChecksum = this.computeFileChecksum(filePath, checksumUrl.endsWith(".md5") ? "MD5" : "SHA-1"))) {
                System.err.println("Checksum mismatch for: " + filePath);
                Files.delete(filePath);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to verify checksum for: " + filePath + ". Skipping verification.");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String downloadChecksum(String checksumUrl) {
        try {
            URL url = new URL(checksumUrl);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String string = reader.readLine().trim();
                return string;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private String computeFileChecksum(Path filePath, String algorithm) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        try (InputStream fis = Files.newInputStream(filePath, new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(fis, digest);){
            while (dis.read() != -1) {
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

