/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.logging.Level;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleClob;
import oracle.jdbc.driver.OracleNClob;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.sql.ClobDBAccess;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.DatumWithConnection;
import oracle.xdb.XMLType;

public class CLOB
extends DatumWithConnection
implements oracle.jdbc.internal.OracleClob,
OracleConcreteProxy {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_INVALID = -1;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    protected OracleClob target = null;
    private oracle.jdbc.internal.OracleClob ojiOracleClob = null;

    protected CLOB() throws SQLException {
        OracleClob c = new OracleClob();
        this.setTarget(null, c, null, (short)1, false);
    }

    protected CLOB(OracleClob c) throws SQLException {
        this.setTarget(null, c, null, (short)1, false);
    }

    public OracleClob getTarget() {
        return this.target;
    }

    private void setTarget(oracle.jdbc.OracleConnection conn, OracleClob c, byte[] lob_descriptor, short csform, boolean recordConstructor) throws SQLException {
        Class proxyClass = csform == 2 ? TxnReplayableNClob.class : TxnReplayableClob.class;
        this.ojiOracleClob = ConcreteProxyUtil.getProxyObject(conn, c, proxyClass, this);
        this.target = c;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleClob != null) {
            try {
                Object proxyObj = ConcreteProxyUtil.checkAndGetACProxyConnection(conn);
                if (proxyObj != null && recordConstructor) {
                    ((TxnReplayableConnection)proxyObj).CLOBConstructorRecording(lob_descriptor, csform, this);
                }
            }
            catch (SQLException sqe) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/sql/CLOB", "setTarget", sqe.getMessage(), null, null);
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleClob;
        } else {
            this.ojiOracleClob = this.target;
        }
    }

    public void createAndSetShardingLobProxy(Class proxyClass, Object creator) {
        this.ojiOracleClob = ConcreteProxyUtil.getProxyObject(this.ojiOracleClob, proxyClass, creator);
        this.ojiOracleDatumWithConnection = this.ojiOracleClob;
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleClob instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleClob);
        }
        return null;
    }

    public CLOB(oracle.jdbc.OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.target.setFromobject(fromObject);
    }

    public static final short getFormOfUseFromLocator(byte[] lob_descriptor) {
        int formOfUse = -1;
        if (lob_descriptor != null && lob_descriptor.length > 5) {
            formOfUse = (lob_descriptor[5] & 0x40) != 0 && (lob_descriptor[5] & 0xFFFFFF80) == 0 ? 2 : 1;
        }
        return (short)formOfUse;
    }

    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        oracle.jdbc.OracleConnection delegateConn = null;
        short csform = 1;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        if (lob_descriptor != null) {
            csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
        }
        OracleClob c = csform == 2 ? new OracleNClob(conn, lob_descriptor) : new OracleClob(conn, lob_descriptor);
        this.setTarget(conn, c, lob_descriptor, c.getCsform(), delegateConn != null);
    }

    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, short csform) throws SQLException {
        this(conn, lob_descriptor);
        this.target.setCsform(csform);
    }

    @Override
    public boolean isNCLOB() {
        return this.ojiOracleClob.isNCLOB();
    }

    @Override
    public long length() throws SQLException {
        return this.ojiOracleClob.length();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        return this.ojiOracleClob.lengthInternal();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        return this.ojiOracleClob.getSubString(pos, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.ojiOracleClob.getCharacterStream();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.ojiOracleClob.getAsciiStream();
    }

    public InputStream getAsciiStream(boolean isInternal) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getAsciiStream(isInternal);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.ojiOracleClob.position(searchstr, start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.ojiOracleClob.position(searchstr, start);
    }

    @Override
    public int getChars(long pos, int length, char[] buffer) throws SQLException {
        return this.ojiOracleClob.getChars(pos, length, buffer);
    }

    @Override
    public Writer getCharacterOutputStream() throws SQLException {
        return this.ojiOracleClob.getCharacterOutputStream();
    }

    @Override
    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.ojiOracleClob.getAsciiOutputStream();
    }

    @Override
    public byte[] getLocator() {
        return this.ojiOracleClob.getLocator();
    }

    @Override
    public void setLocator(byte[] locator) {
        this.ojiOracleClob.setLocator(locator);
    }

    @Override
    public int putChars(long pos, char[] chars) throws SQLException {
        return this.ojiOracleClob.putChars(pos, chars);
    }

    public int putChars(long pos, char[] chars, int length) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.putChars(pos, chars, length);
    }

    @Override
    public int putChars(long pos, char[] chars, int offset, int length) throws SQLException {
        return this.ojiOracleClob.putChars(pos, chars, offset, length);
    }

    @Override
    public int putString(long pos, String str) throws SQLException {
        return this.ojiOracleClob.putString(pos, str);
    }

    @Override
    public int getChunkSize() throws SQLException {
        return this.ojiOracleClob.getChunkSize();
    }

    @Override
    public int getBufferSize() throws SQLException {
        return this.ojiOracleClob.getBufferSize();
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] locator = new byte[86];
        locator[1] = 84;
        locator[5] = 24;
        CLOB clob = new CLOB();
        clob.setShareBytes(locator);
        OracleClob target = clob.getTarget();
        target.setShareBytes(locator);
        return clob;
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        return this.ojiOracleClob.isEmptyLob();
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        return this.ojiOracleClob.isSecureFile();
    }

    @Override
    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        return this.ojiOracleClob.getAsciiOutputStream(pos);
    }

    @Override
    public Writer getCharacterOutputStream(long pos) throws SQLException {
        return this.ojiOracleClob.getCharacterOutputStream(pos);
    }

    @Override
    public InputStream getAsciiStream(long pos) throws SQLException {
        return this.ojiOracleClob.getAsciiStream(pos);
    }

    @Override
    public Reader getCharacterStream(long pos) throws SQLException {
        return this.ojiOracleClob.getCharacterStream(pos);
    }

    @Override
    public void trim(long newlen) throws SQLException {
        this.ojiOracleClob.trim(newlen);
    }

    public static CLOB createTemporary(Connection conn, boolean cache, int _duration) throws SQLException {
        return CLOB.createTemporary(conn, cache, _duration, (short)1);
    }

    public static CLOB createTemporary(Connection conn, boolean cache, int _duration, short form_of_use) throws SQLException {
        int duration = _duration;
        if (_duration == 1) {
            duration = 10;
        }
        if (_duration == 2) {
            duration = 12;
        }
        if (conn == null || duration != 10 && duration != 12) {
            throw (SQLException)DatabaseError.createSqlException(68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL").fillInStackTrace();
        }
        OracleConnection physConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        CLOB result = CLOB.getDBAccess(physConn).createTemporaryClob(physConn, cache, duration, form_of_use);
        if (result != null) {
            OracleClob target = result.getTarget();
            short csform = CLOB.getFormOfUseFromLocator(result.shareBytes());
            target.setCsform(csform);
        }
        return result;
    }

    public static void freeTemporary(CLOB temp_lob) throws SQLException {
        if (temp_lob == null) {
            return;
        }
        temp_lob.freeTemporary();
    }

    public static boolean isTemporary(CLOB lob) throws SQLException {
        if (lob == null) {
            return false;
        }
        return lob.isTemporary();
    }

    public static short getDuration(CLOB lob) throws SQLException {
        if (lob == null) {
            return -1;
        }
        return lob.getDuration();
    }

    @Override
    public void freeTemporary() throws SQLException {
        this.ojiOracleClob.freeTemporary();
    }

    @Override
    public boolean isTemporary() throws SQLException {
        return this.ojiOracleClob.isTemporary();
    }

    @Override
    public short getDuration() throws SQLException {
        return this.ojiOracleClob.getDuration();
    }

    @Override
    public void openLob(LargeObjectAccessMode mode) throws SQLException {
        this.ojiOracleClob.openLob(mode);
    }

    @Deprecated
    public void open(int mode) throws SQLException {
        this.openLob(mode);
    }

    public void openLob(int mode) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        this.target.openLob(mode);
    }

    @Override
    public void closeLob() throws SQLException {
        this.ojiOracleClob.closeLob();
    }

    @Override
    public boolean isOpenLob() throws SQLException {
        return this.ojiOracleClob.isOpenLob();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.ojiOracleClob.setString(pos, str);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.ojiOracleClob.setString(pos, str, offset, len);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.ojiOracleClob.setAsciiStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return this.ojiOracleClob.setCharacterStream(pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.ojiOracleClob.truncate(len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        this.ojiOracleClob.toJdbc();
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return this.ojiOracleClob.isConvertibleTo(jClass);
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.ojiOracleClob.characterStreamValue();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.ojiOracleClob.asciiStreamValue();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.ojiOracleClob.binaryStreamValue();
    }

    @Override
    public String stringValue() throws SQLException {
        return this.ojiOracleClob.stringValue();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return this.ojiOracleClob.makeJdbcArray(arraySize);
    }

    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        return this.ojiOracleClob.getDBAccess();
    }

    public static ClobDBAccess getDBAccess(Connection conn) throws SQLException {
        try (Monitor.CloseableLock lock = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().acquireCloseableLock();){
            ClobDBAccess clobDBAccess = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().createClobDBAccess();
            return clobDBAccess;
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.ojiOracleClob.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _cachedLengthOfClobInChars) {
        this.ojiOracleClob.setLength(_cachedLengthOfClobInChars);
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.ojiOracleClob.setChunkSize(_dbChunkSize);
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<char[]> prefetchData) {
        this.ojiOracleClob.setPrefetchData(prefetchData);
    }

    public final void setPrefetchedData(char[] _prefetchData) {
        this.setPrefetchedData(_prefetchData, _prefetchData == null ? 0 : _prefetchData.length);
    }

    public final void setPrefetchedData(char[] _prefetchData, int _size) {
        this.setPrefetchData(_prefetchData == null ? null : OracleLargeObject.PrefetchData.wrapArray(_prefetchData, _size));
    }

    @Override
    public final OracleLargeObject.PrefetchData<char[]> getPrefetchData() {
        return this.ojiOracleClob.getPrefetchData();
    }

    public final char[] getPrefetchedData() {
        OracleLargeObject.PrefetchData prefetchData = this.ojiOracleClob.getPrefetchData();
        return prefetchData == null ? null : (char[])prefetchData.share();
    }

    public final int getPrefetchedDataSize() {
        OracleLargeObject.PrefetchData prefetchData = this.ojiOracleClob.getPrefetchData();
        return prefetchData == null ? 0 : prefetchData.length();
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        this.ojiOracleClob.setActivePrefetch(_activePrefetch);
    }

    @Override
    public final void clearCachedData() {
        this.ojiOracleClob.clearCachedData();
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.ojiOracleClob.isActivePrefetch();
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        return this.ojiOracleClob.canReadBasicLobDataInLocator();
    }

    @Override
    public void freeLOB() throws SQLException {
        this.free();
    }

    @Override
    public void free() throws SQLException {
        this.ojiOracleClob.free();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return this.ojiOracleClob.getCharacterStream(pos, length);
    }

    @Override
    public void setBytes(byte[] locator) {
        this.ojiOracleClob.setBytes(locator);
    }

    @Override
    public void setACProxy(Object w) {
        this.ojiOracleClob.setACProxy(w);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleClob.getACProxy();
    }

    public oracle.jdbc.internal.OracleClob getInternal() {
        return this.ojiOracleClob;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return XMLType.createXML((Connection)this.getPhysicalConnection(), (CLOB)this);
    }

    @Override
    public SQLXML toSQLXML(String schemaURL) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return XMLType.createXML((Connection)this.getPhysicalConnection(), (CLOB)this, (String)schemaURL, (boolean)true, (boolean)true);
    }

    @Override
    public final boolean isFree() {
        return this.ojiOracleClob.isFree();
    }
}

