/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.console.DMSConsole;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.State;
import oracle.dms.instrument.StateIntf;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.admin.MetricsUpdateTimerTask;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskManagerImpl;
import oracle.ucp.util.UCPTimerManagerImpl;
import oracle.ucp.util.UniqueIdentifier;
import oracle.ucp.util.logging.UCPLoggerFactory;

public abstract class UniversalConnectionPoolManagerBase
implements UniversalConnectionPoolManager {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolManagerBase.class.getCanonicalName());
    private static final boolean DEFAULT_IS_JMX_ENABLED = true;
    private static final boolean DEFAULT_LOCAL_METRIC_CONSOLE = true;
    private static final int DEFAULT_METRIC_UPDATE_INTERVAL = 60;
    private boolean m_jmxFlag = true;
    private boolean m_localMetricConsole = true;
    private int m_metricInterval = 60;
    private static final String UCP_METRIC_NAME = "/UCP_METRIC";
    private static final String MGR_PREFIX = "UniversalConnectionPoolManager(" + UniversalConnectionPoolManagerBase.class.hashCode() + ")-";
    private DMSConsole m_metricConsole = null;
    private TimerHandle m_updateMetricTimer = null;
    private boolean m_metricsPostingThread = false;
    protected final Map<String, UniversalConnectionPool> m_connPool = Collections.synchronizedMap(new HashMap());
    protected final Map<String, String> m_mappedPoolNames = new HashMap<String, String>();
    private static final Map<UCPMetric, String> m_ucpMetrics = Collections.synchronizedMap(new HashMap());
    private final Hashtable<String, NounIntf> m_parentNouns = new Hashtable();
    private final ArrayList<String> m_metricPools = new ArrayList();
    static final String TOTAL_CONN_NAME = "TotalConnectionsCount";
    static final String TOTAL_CONN_UNITS = "ConnectionsCount";
    static final String TOTAL_CONN_DESC = "Total number of connections in the pool";
    static final String AVAILABLE_CONN_NAME = "AvailableConnectionsCount";
    static final String AVAILABLE_CONN_UNITS = "ConnectionsCount";
    static final String AVAILABLE_CONN_DESC = "Total number of available connections in the pool";
    static final String BORROWED_CONN_NAME = "BorrowedConnectionsCount";
    static final String BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String BORROWED_CONN_DESC = "Total number of borrowed connections in the pool";
    static final String AVERAGE_BORROWED_CONN_NAME = "AverageBorrowedConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_DESC = "Average count for borrowed connections in the pool";
    static final String PEAK_CONN_NAME = "PeakConnectionsCount";
    static final String PEAK_CONN_UNITS = "ConnectionsCount";
    static final String PEAK_CONN_DESC = "Peak connections count in the pool";
    static final String REMAINING_CONN_NAME = "RemainingPoolCapacityCount";
    static final String REMAINING_CONN_UNITS = "ConnectionsCount";
    static final String REMAINING_CONN_DESC = "Remaining pool capacity count for the pool";
    static final String LABELED_CONN_NAME = "LabeledConnectionsCount";
    static final String LABELED_CONN_UNITS = "ConnectionsCount";
    static final String LABELED_CONN_DESC = "Total number of labeled connections in the pool";
    static final String CREATED_CONN_NAME = "ConnectionsCreatedCount";
    static final String CREATED_CONN_UNITS = "ConnectionsCount";
    static final String CREATED_CONN_DESC = "Total number of connections created in the pool";
    static final String CLOSED_CONN_NAME = "ConnectionsClosedCount";
    static final String CLOSED_CONN_UNITS = "ConnectionsCount";
    static final String CLOSED_CONN_DESC = "Total number of closed connections in the pool";
    static final String AVG_CONN_WAIT_NAME = "AverageConnectionWaitTime";
    static final String AVG_CONN_WAIT_UNITS = "Seconds";
    static final String AVG_CONN_WAIT_DESC = "Average connection wait time in the pool";
    static final String PEAK_CONN_WAIT_NAME = "PeakConnectionWaitTime";
    static final String PEAK_CONN_WAIT_UNITS = "Seconds";
    static final String PEAK_CONN_WAIT_DESC = "Peak Connection wait time in the pool";
    static final String ABANDONED_CONN_NAME = "AbandonedConnectionsCount";
    static final String ABANDONED_CONN_UNITS = "ConnectionsCount";
    static final String ABANDONED_CONN_DESC = "Total number of abandoned connections in the pool";
    static final String PENDING_REQUEST_NAME = "PendingRequestsCount";
    static final String PENDING_REQUEST_UNITS = "ConnectionsCount";
    static final String PENDING_REQUEST_DESC = "Total number of pending requests count in the pool";
    static final String CUMULATIVE_CONN_WAIT_NAME = "CumulativeConnectionWaitTime";
    static final String CUMULATIVE_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_WAIT_DESC = "Cumulative connection wait time for the pool";
    static final String CUMULATIVE_CONN_BORROWED_NAME = "CumulativeConnectionBorrowedCount";
    static final String CUMULATIVE_CONN_BORROWED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_BORROWED_DESC = "Cumulative connection borrowed count for the pool";
    static final String CUMULATIVE_CONN_USE_NAME = "CumulativeConnectionUseTime";
    static final String CUMULATIVE_CONN_USE_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_USE_DESC = "Cumulative connection use time for the pool";
    static final String CUMULATIVE_CONN_RETURNED_NAME = "CumulativeConnectionReturnedCount";
    static final String CUMULATIVE_CONN_RETURNED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_RETURNED_DESC = "Cumulative connection returned count in the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_NAME = "CumulativeSuccessfulConnectionWaitTime";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_DESC = "Cumulative successful connection wait time for the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME = "CumulativeSuccessfulConnectionWaitCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC = "Cumulative successful connection wait count for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_NAME = "CumulativeFailedConnectionWaitTime";
    static final String CUMULATIVE_FAILED_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_FAILED_CONN_WAIT_DESC = "Cumulative failed connection wait time for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME = "CumulativeFailedConnectionWaitCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC = "Cumulative failed connection wait count for the pool";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME = "SuccessfulAffinityBasedBorrowCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded with matching affinity contexts.";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_NAME = "FailedAffinityBasedBorrowCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests that returned connections not matching the affinity contexts.";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME = "SuccessfulRCLBBasedBorrowCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded using Runtime Connection Load-Balancing (RCLB) algorithms.";
    static final String FAILED_RCLBBASED_BORROW_COUNT_NAME = "FailedRCLBBasedBorrowCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests failed using Runtime Connection Load-Balancing (RCLB) algorithms.";
    private static TimerManager m_timerManager = new UCPTimerManagerImpl();
    private static TaskManager m_taskManager = new UCPTaskManagerImpl();

    public void startConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.start();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    public void stopConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.stop();
            if (this.m_metricPools.contains(uniquePoolID)) {
                this.stopMetricsCollection(poolName);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    public void refreshConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.refresh();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    public void recycleConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.recycle();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    public void purgeConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.purge();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        try {
            this.stopConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException ucpe) {
            logger.log(Level.FINEST, "called stopConnectionPool: ", ucpe);
        }
        if (this.isJmxEnabled()) {
            try {
                UniversalConnectionPoolManagerMBean umb = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
                umb.unregisterUniversalConnectionPoolMBean(poolName);
            }
            catch (UniversalConnectionPoolException ucpe) {
                logger.log(Level.FINEST, "called unregisterUniversalConnectionPoolMBean", ucpe);
            }
        }
        this.m_connPool.remove(this.getManagerPoolID(poolName));
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            this.m_mappedPoolNames.remove(poolName);
        }
    }

    public void createConnectionPool(UniversalConnectionPoolAdapter ucpAdapter) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "parameter ucpAdapter: {0}", ucpAdapter);
        if (ucpAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(383);
        }
        try {
            UniversalConnectionPool pool = ucpAdapter.createUniversalConnectionPool();
            assert (pool != null);
            this.setConnectionPool(pool);
        }
        catch (Exception exc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(385, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionPool(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "connectionPool: {0}", connectionPool);
        if (connectionPool != null) {
            String uniquePoolID;
            String poolName = connectionPool.getName();
            Map<String, String> map = this.m_mappedPoolNames;
            synchronized (map) {
                if (this.m_mappedPoolNames.containsKey(poolName)) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(350);
                }
                uniquePoolID = new UniqueIdentifier(MGR_PREFIX).toString();
                this.m_mappedPoolNames.put(poolName, uniquePoolID);
            }
            this.m_connPool.put(uniquePoolID, connectionPool);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
    }

    public UniversalConnectionPool getConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        logger.log(Level.FINEST, "getConnectionPool(): {0} returns {1}", new Object[]{poolName, pool});
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionPoolNames() throws UniversalConnectionPoolException {
        Object[] sArray;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            sArray = this.m_mappedPoolNames.keySet().toArray(new String[this.m_mappedPoolNames.size()]);
        }
        logger.log(Level.FINEST, "returns {0}", sArray);
        return sArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManagerPoolID(String poolName, String newPoolName) throws UniversalConnectionPoolException {
        String uniquePoolID;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            String string = uniquePoolID = poolName != null ? this.m_mappedPoolNames.get(poolName) : null;
            if (null == uniquePoolID) {
                UCPErrorHandler.throwUniversalConnectionPoolException(351);
            }
            this.m_mappedPoolNames.remove(poolName);
            this.m_mappedPoolNames.put(newPoolName, uniquePoolID);
        }
        logger.log(Level.FINEST, "{0} returns {1}", new Object[]{newPoolName, uniquePoolID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getManagerPoolID(String poolName) throws UniversalConnectionPoolException {
        String uniquePoolID;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            uniquePoolID = poolName != null ? this.m_mappedPoolNames.get(poolName) : null;
        }
        if (null == uniquePoolID) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        logger.log(Level.FINEST, "{0} returns {1}", new Object[]{poolName, uniquePoolID});
        return uniquePoolID;
    }

    private String[] getMetricPoolNames() throws UniversalConnectionPoolException {
        Object[] sArray = this.m_metricPools.toArray(new String[this.m_metricPools.size()]);
        logger.log(Level.FINEST, "returns {0}", sArray);
        return sArray;
    }

    public synchronized void startMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        if (this.isMetricConsoleAvailable()) {
            try {
                UniversalConnectionPool pool = this.getConnectionPool(poolName);
                this.createMetricSensors(pool);
                if (!this.m_metricsPostingThread) {
                    this.initupdateMetricTimer();
                }
            }
            catch (UniversalConnectionPoolException ce) {
                logger.log(Level.FINEST, "Exception occurred while creating Metric Sensors", ce);
            }
        }
    }

    private void createMetricSensors(UniversalConnectionPool pool) throws UniversalConnectionPoolException {
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        logger.log(Level.FINEST, "about to create metric sensors for pool: {0}", pool);
        NounIntf metricParentNoun = null;
        String poolName = pool.getName();
        String uniquePoolID = this.getManagerPoolID(poolName);
        metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().create("/UCP_METRIC/" + poolName);
        if (!this.m_metricPools.contains(uniquePoolID)) {
            this.m_metricPools.add(uniquePoolID);
        }
        UniversalConnectionPoolStatistics stats = pool.getStatistics();
        StateIntf totalConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, TOTAL_CONN_NAME, (byte)3, "ConnectionsCount", TOTAL_CONN_DESC);
        totalConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getTotalConnectionsCount());
        StateIntf availableConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVAILABLE_CONN_NAME, (byte)3, "ConnectionsCount", AVAILABLE_CONN_DESC);
        availableConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getAvailableConnectionsCount());
        StateIntf borrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", BORROWED_CONN_DESC);
        borrowedConnectionsCount.deriveMetric(8);
        borrowedConnectionsCount.update(stats.getBorrowedConnectionsCount());
        StateIntf averageBorrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVERAGE_BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", AVERAGE_BORROWED_CONN_DESC);
        averageBorrowedConnectionsCount.update(stats.getAverageBorrowedConnectionsCount());
        StateIntf peakConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_NAME, (byte)3, "ConnectionsCount", PEAK_CONN_DESC);
        peakConnectionsCount.update(stats.getPeakConnectionsCount());
        StateIntf remainingPoolCapacityCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, REMAINING_CONN_NAME, (byte)3, "ConnectionsCount", REMAINING_CONN_DESC);
        remainingPoolCapacityCount.deriveMetric(511);
        remainingPoolCapacityCount.update(stats.getRemainingPoolCapacityCount());
        StateIntf labeledConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, LABELED_CONN_NAME, (byte)3, "ConnectionsCount", LABELED_CONN_DESC);
        labeledConnectionsCount.deriveMetric(511);
        labeledConnectionsCount.update(stats.getLabeledConnectionsCount());
        StateIntf connectionsCreatedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CREATED_CONN_NAME, (byte)3, "ConnectionsCount", CREATED_CONN_DESC);
        connectionsCreatedCount.deriveMetric(511);
        connectionsCreatedCount.update(stats.getConnectionsCreatedCount());
        StateIntf connectionsClosedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CLOSED_CONN_NAME, (byte)3, "ConnectionsCount", CLOSED_CONN_DESC);
        connectionsClosedCount.deriveMetric(511);
        connectionsClosedCount.update(stats.getConnectionsClosedCount());
        StateIntf averageConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVG_CONN_WAIT_NAME, (byte)2, "Seconds", AVG_CONN_WAIT_DESC);
        averageConnectionWaitTime.update(stats.getAverageConnectionWaitTime());
        StateIntf peakConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_WAIT_NAME, (byte)2, "Seconds", PEAK_CONN_WAIT_DESC);
        peakConnectionWaitTime.update(stats.getPeakConnectionWaitTime());
        StateIntf abandonedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, ABANDONED_CONN_NAME, (byte)3, "ConnectionsCount", ABANDONED_CONN_DESC);
        abandonedConnectionsCount.deriveMetric(511);
        abandonedConnectionsCount.update(stats.getAbandonedConnectionsCount());
        StateIntf pendingRequestsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PENDING_REQUEST_NAME, (byte)3, "ConnectionsCount", PENDING_REQUEST_DESC);
        pendingRequestsCount.deriveMetric(511);
        pendingRequestsCount.update(stats.getPendingRequestsCount());
        StateIntf cumulativeConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_WAIT_DESC);
        cumulativeConnectionWaitTime.deriveMetric(511);
        cumulativeConnectionWaitTime.update(stats.getCumulativeConnectionWaitTime());
        StateIntf cumulativeConnectionBorrowedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_BORROWED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_BORROWED_DESC);
        cumulativeConnectionBorrowedCount.deriveMetric(511);
        cumulativeConnectionBorrowedCount.update(stats.getCumulativeConnectionBorrowedCount());
        StateIntf cumulativeConnectionUseTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_USE_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_USE_DESC);
        cumulativeConnectionUseTime.deriveMetric(511);
        cumulativeConnectionUseTime.update(stats.getCumulativeConnectionUseTime());
        StateIntf cumulativeConnectionReturnedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_RETURNED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_RETURNED_DESC);
        cumulativeConnectionReturnedCount.deriveMetric(511);
        cumulativeConnectionReturnedCount.update(stats.getCumulativeConnectionReturnedCount());
        StateIntf cumulativeSuccessfulConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_SUCCESS_CONN_WAIT_DESC);
        cumulativeSuccessfulConnectionWaitTime.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitTime.update(stats.getCumulativeSuccessfulConnectionWaitTime());
        StateIntf cumulativeSuccessfulConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC);
        cumulativeSuccessfulConnectionWaitCount.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitCount.update(stats.getCumulativeSuccessfulConnectionWaitCount());
        StateIntf cumulativeFailedConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_FAILED_CONN_WAIT_DESC);
        cumulativeFailedConnectionWaitTime.deriveMetric(511);
        cumulativeFailedConnectionWaitTime.update(stats.getCumulativeFailedConnectionWaitTime());
        StateIntf cumulativeFailedConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC);
        cumulativeFailedConnectionWaitCount.deriveMetric(511);
        cumulativeFailedConnectionWaitCount.update(stats.getCumulativeFailedConnectionWaitCount());
        if (pool instanceof OracleJDBCConnectionPool) {
            OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
            StateIntf successfulAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC);
            successfulAffinityBasedBorrowCount.deriveMetric(511);
            successfulAffinityBasedBorrowCount.update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
            StateIntf failedAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_AFFINITYBASED_BORROW_COUNT_DESC);
            failedAffinityBasedBorrowCount.deriveMetric(511);
            failedAffinityBasedBorrowCount.update(oracleStats.getFailedAffinityBasedBorrowCount());
            StateIntf successfulRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC);
            successfulRCLBBasedBorrowCount.deriveMetric(511);
            successfulRCLBBasedBorrowCount.update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
            StateIntf failedRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_RCLBBASED_BORROW_COUNT_DESC);
            failedRCLBBasedBorrowCount.deriveMetric(511);
            failedRCLBBasedBorrowCount.update(oracleStats.getFailedRCLBBasedBorrowCount());
        }
    }

    void updateMetricSensors() throws UniversalConnectionPoolException {
        logger.finest("about to update metric sensors");
        if (this.isMetricConsoleAvailable()) {
            try {
                String[] uniquePoolIDs = this.getMetricPoolNames();
                for (int i = 0; i < uniquePoolIDs.length; ++i) {
                    UniversalConnectionPool connectionPool = uniquePoolIDs[i] != null ? this.m_connPool.get(uniquePoolIDs[i]) : null;
                    this.updateMetricSensors(connectionPool);
                }
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(377, e);
            }
        }
    }

    private synchronized void updateMetricSensors(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        NounFactoryIntf nfi;
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        logger.log(Level.FINEST, "update metric sensors for connectionPool: {0}", connectionPool);
        String poolName = connectionPool.getName();
        NounIntf metricParentNoun = null;
        if (!this.m_localMetricConsole) {
            metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
        } else if (null != this.m_metricConsole && null != (nfi = this.m_metricConsole.getNounFactory())) {
            metricParentNoun = nfi.get("/UCP_METRIC/" + poolName);
        }
        if (null != metricParentNoun) {
            UniversalConnectionPoolStatistics stats = connectionPool.getStatistics();
            assert (stats != null);
            ((State)metricParentNoun.getSensor(TOTAL_CONN_NAME)).update(stats.getTotalConnectionsCount());
            ((State)metricParentNoun.getSensor(AVAILABLE_CONN_NAME)).update(stats.getAvailableConnectionsCount());
            ((State)metricParentNoun.getSensor(BORROWED_CONN_NAME)).update(stats.getBorrowedConnectionsCount());
            ((State)metricParentNoun.getSensor(AVERAGE_BORROWED_CONN_NAME)).update(stats.getAverageBorrowedConnectionsCount());
            ((State)metricParentNoun.getSensor(PEAK_CONN_NAME)).update(stats.getPeakConnectionsCount());
            ((State)metricParentNoun.getSensor(REMAINING_CONN_NAME)).update(stats.getRemainingPoolCapacityCount());
            ((State)metricParentNoun.getSensor(LABELED_CONN_NAME)).update(stats.getLabeledConnectionsCount());
            ((State)metricParentNoun.getSensor(CREATED_CONN_NAME)).update(stats.getConnectionsCreatedCount());
            ((State)metricParentNoun.getSensor(CLOSED_CONN_NAME)).update(stats.getConnectionsClosedCount());
            ((State)metricParentNoun.getSensor(AVG_CONN_WAIT_NAME)).update(stats.getAverageConnectionWaitTime());
            ((State)metricParentNoun.getSensor(PEAK_CONN_WAIT_NAME)).update(stats.getPeakConnectionWaitTime());
            ((State)metricParentNoun.getSensor(ABANDONED_CONN_NAME)).update(stats.getAbandonedConnectionsCount());
            ((State)metricParentNoun.getSensor(PENDING_REQUEST_NAME)).update(stats.getPendingRequestsCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_WAIT_NAME)).update(stats.getCumulativeConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_BORROWED_NAME)).update(stats.getCumulativeConnectionBorrowedCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_USE_NAME)).update(stats.getCumulativeConnectionUseTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_RETURNED_NAME)).update(stats.getCumulativeConnectionReturnedCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_NAME)).update(stats.getCumulativeFailedConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeFailedConnectionWaitCount());
            if (connectionPool instanceof OracleJDBCConnectionPool) {
                OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
                ((State)metricParentNoun.getSensor(SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
                ((State)metricParentNoun.getSensor(FAILED_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedAffinityBasedBorrowCount());
                ((State)metricParentNoun.getSensor(SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
                ((State)metricParentNoun.getSensor(FAILED_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedRCLBBasedBorrowCount());
            }
        }
    }

    private boolean isMetricConsoleAvailable() {
        boolean metricConsoleExists = false;
        if (this.m_metricConsole != null) {
            metricConsoleExists = true;
        } else {
            try {
                ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
                Class.forName("oracle.dms.instrument.DMSConsole", true, clsLoader);
                this.m_metricConsole = DMSConsole.getConsole();
                this.m_metricConsole.init(UCP_METRIC_NAME);
                metricConsoleExists = true;
            }
            catch (ClassNotFoundException cnf) {
                logger.log(Level.FINEST, "DMSConsole class cannot be found.", cnf);
            }
            catch (SecurityException e) {
                logger.log(Level.FINEST, "security", e);
            }
            catch (RuntimeException re) {
                logger.log(Level.FINEST, "Runtime Exception occurred while initializing the metric console", re);
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Exception occurred while initializing the metric console", e);
            }
        }
        return metricConsoleExists;
    }

    public synchronized void stopMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        if (this.isMetricConsoleAvailable()) {
            try {
                if (this.isMetricConsoleAvailable()) {
                    String uniquePoolID;
                    NounIntf metricParentNoun = null;
                    metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().get("/UCP_METRIC/" + poolName);
                    if (metricParentNoun != null) {
                        metricParentNoun.destroy();
                    }
                    if (this.m_metricPools.contains(uniquePoolID = this.getManagerPoolID(poolName))) {
                        this.m_metricPools.remove(uniquePoolID);
                    }
                    if (this.m_parentNouns.contains(poolName)) {
                        this.m_parentNouns.remove(poolName);
                    }
                    if (this.m_metricPools.size() == 0) {
                        this.disableupdateMetricTimer();
                        if (this.m_localMetricConsole) {
                            this.m_metricConsole.exit();
                        }
                        this.m_metricConsole = null;
                        this.m_localMetricConsole = true;
                    }
                }
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(375, e);
            }
        }
    }

    public synchronized void setMetricUpdateInterval(int metricInterval) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "setMetricUpdateInterval: {0}", metricInterval);
        if (metricInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_metricInterval != metricInterval) {
            this.disableupdateMetricTimer();
            this.m_metricInterval = metricInterval;
            if (this.m_metricConsole != null && this.m_metricInterval > 0) {
                this.initupdateMetricTimer();
            }
        }
    }

    public int getMetricUpdateInterval() {
        return this.m_metricInterval;
    }

    public synchronized void setJmxEnabled(boolean jmxFlag) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "JmxEnabled: {0}", jmxFlag);
        this.m_jmxFlag = jmxFlag;
    }

    public boolean isJmxEnabled() {
        return this.m_jmxFlag;
    }

    private void initupdateMetricTimer() throws UniversalConnectionPoolException {
        logger.finest("entering");
        if (this.m_metricInterval > 0) {
            try {
                this.m_updateMetricTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new MetricsUpdateTimerTask(), 0L, this.m_metricInterval * 1000);
                this.m_metricsPostingThread = true;
            }
            catch (Exception exc) {
                UCPErrorHandler.throwUniversalConnectionPoolException(376, exc);
            }
        } else {
            this.m_updateMetricTimer = null;
        }
    }

    private void disableupdateMetricTimer() throws UniversalConnectionPoolException {
        logger.finest("entering");
        if (this.m_updateMetricTimer != null) {
            this.m_updateMetricTimer.cancel();
            this.m_metricsPostingThread = false;
            this.m_updateMetricTimer = null;
        }
    }

    public void setLogLevel(Level newLogLevel) {
        logger.log(Level.FINEST, "setLogLevel: {0}", newLogLevel);
        UCPLoggerFactory.setLogLevel(newLogLevel);
    }

    public Level getLogLevel() {
        return UCPLoggerFactory.getLogLevel();
    }

    protected void setMetricConsole(DMSConsole metricConsole) {
        this.m_metricConsole = metricConsole;
        this.m_localMetricConsole = false;
    }

    protected void setMetricParentNoun(String poolName, NounIntf metricParentNoun) {
        this.m_parentNouns.put(poolName, metricParentNoun);
    }

    protected StateIntf getStateMetric(String poolName, UCPMetric ucpMetric) {
        NounIntf metricParentNoun;
        StateIntf stateMetric = null;
        NounIntf nounIntf = metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
        if (metricParentNoun != null) {
            stateMetric = (StateIntf)metricParentNoun.getSensor(m_ucpMetrics.get((Object)ucpMetric));
        }
        return stateMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerManager getTimerManager() {
        TimerManager timerManager = m_timerManager;
        synchronized (timerManager) {
            return m_timerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTimerManager(TimerManager timerManager) {
        TimerManager oldTm;
        TimerManager timerManager2 = oldTm = m_timerManager;
        synchronized (timerManager2) {
            TimerManager timerManager3 = timerManager;
            synchronized (timerManager3) {
                if (oldTm.isRunning()) {
                    return false;
                }
                m_timerManager = timerManager;
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager() {
        TaskManager taskManager = m_taskManager;
        synchronized (taskManager) {
            return m_taskManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTaskManager(TaskManager taskManager) {
        TaskManager oldTm;
        TaskManager taskManager2 = oldTm = m_taskManager;
        synchronized (taskManager2) {
            TaskManager taskManager3 = taskManager;
            synchronized (taskManager3) {
                if (oldTm.isRunning()) {
                    return false;
                }
                m_taskManager = taskManager;
                return true;
            }
        }
    }

    static {
        m_ucpMetrics.put(UCPMetric.TOTALCONNECTIONSCOUNT, TOTAL_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVAILABLECONNECTIONSCOUNT, AVAILABLE_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.BORROWEDCONNECTIONSCOUNT, BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGEBORROWEDCONNECTIONSCOUNT, AVERAGE_BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONSCOUNT, PEAK_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.REMAININGPOOLCAPACITYCOUNT, REMAINING_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.LABELEDCONNECTIONSCOUNT, LABELED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCREATEDCOUNT, CREATED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCLOSEDCOUNT, CLOSED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGECONNECTIONWAITTIME, AVG_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONWAITTIME, PEAK_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.ABANDONEDCONNECTIONSCOUNT, ABANDONED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PENDINGREQUESTSCOUNT, PENDING_REQUEST_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONWAITTIME, CUMULATIVE_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVE_CONN_BORROWED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONUSETIME, CUMULATIVE_CONN_USE_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVE_CONN_RETURNED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVE_SUCCESS_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVE_FAILED_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITCOUNT, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULAFFINITYBASEDBORROWCOUNT, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDAFFINITYBASEDBORROWCOUNT, FAILED_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULRCLBBASEDBORROWCOUNT, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDRCLBBASEDBORROWCOUNT, FAILED_RCLBBASED_BORROW_COUNT_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UCPMetric {
        TOTALCONNECTIONSCOUNT,
        AVAILABLECONNECTIONSCOUNT,
        BORROWEDCONNECTIONSCOUNT,
        AVERAGEBORROWEDCONNECTIONSCOUNT,
        PEAKCONNECTIONSCOUNT,
        REMAININGPOOLCAPACITYCOUNT,
        LABELEDCONNECTIONSCOUNT,
        CONNECTIONSCREATEDCOUNT,
        CONNECTIONSCLOSEDCOUNT,
        AVERAGECONNECTIONWAITTIME,
        PEAKCONNECTIONWAITTIME,
        ABANDONEDCONNECTIONSCOUNT,
        PENDINGREQUESTSCOUNT,
        CUMULATIVECONNECTIONWAITTIME,
        CUMULATIVECONNECTIONBORROWEDCOUNT,
        CUMULATIVECONNECTIONUSETIME,
        CUMULATIVECONNECTIONRETURNEDCOUNT,
        CUMULATIVESUCCESSFULCONNECTIONWAITTIME,
        CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT,
        CUMULATIVEFAILEDCONNECTIONWAITTIME,
        CUMULATIVEFAILEDCONNECTIONWAITCOUNT,
        SUCCESSFULAFFINITYBASEDBORROWCOUNT,
        FAILEDAFFINITYBASEDBORROWCOUNT,
        SUCCESSFULRCLBBASEDBORROWCOUNT,
        FAILEDRCLBBASEDBORROWCOUNT,
        FCFDOWNEVENTPROCESSINGINFO;

    }
}

