/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.ucp.ConnectionRetrievalInfo;

class BorrowRequestQueue {
    private final Map<ConnectionRetrievalInfo, ConcurrentLinkedQueue<WaitTicket>> mapRequests = Collections.synchronizedMap(new HashMap(10));

    BorrowRequestQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitAvailable(ConnectionRetrievalInfo cri, long timeout) throws InterruptedException {
        WaitTicket uniqueTicket;
        ConcurrentLinkedQueue<WaitTicket> queue = null;
        queue = this.mapRequests.get(cri);
        if (queue == null) {
            BorrowRequestQueue borrowRequestQueue = this;
            synchronized (borrowRequestQueue) {
                queue = this.mapRequests.get(cri);
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue();
                    this.mapRequests.put(cri, queue);
                }
            }
        }
        WaitTicket waitTicket = uniqueTicket = new WaitTicket();
        synchronized (waitTicket) {
            queue.add(uniqueTicket);
            uniqueTicket.wait(timeout);
        }
        queue.remove(uniqueTicket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void notifyAvailable(ConnectionRetrievalInfo cri) {
        ConcurrentLinkedQueue<WaitTicket> queue = this.mapRequests.get(cri);
        if (queue == null) {
            return;
        }
        WaitTicket uniqueTicket = queue.poll();
        if (uniqueTicket != null) {
            WaitTicket waitTicket = uniqueTicket;
            synchronized (waitTicket) {
                uniqueTicket.notify();
            }
        }
    }

    private class WaitTicket {
        private WaitTicket() {
        }
    }
}

