/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleDatabaseInstanceInfoList {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleDatabaseInstanceInfoList.class.getCanonicalName());
    final Instances instances = new Instances();
    private int m_dbInstancePercentTotal = 0;
    private final RACManagerImpl m_racMngr;
    private final Random m_rand = new Random(0L);
    private boolean m_useGoodGroup = false;
    private static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";

    OracleDatabaseInstanceInfoList() {
        this(null);
    }

    OracleDatabaseInstanceInfoList(RACManagerImpl racMngr) {
        this.m_racMngr = racMngr;
    }

    protected void updateDatabaseInstanceInfo(OracleDatabaseInstanceInfo dbInfo, boolean isForFailover, boolean isAddingConnection) {
        int instId;
        Integer instNum = this.instances.getId(dbInfo);
        int n = instId = instNum != null ? instNum : -1;
        if (isForFailover) {
            if (instId != -1) {
                if (isAddingConnection && instId != dbInfo.id) {
                    logger.log(Level.FINEST, "name->id mapping out-of-sync, instance={0}, id={1}, id-in-table={2}", new Object[]{dbInfo.getInstanceName(), dbInfo.id, instId});
                    return;
                }
                OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
                if (isAddingConnection) {
                    ++dbInstance.numberOfConnectionsCount;
                    if (dbInstance.status == 2) {
                        dbInstance.status = 1;
                    }
                } else if (dbInstance.numberOfConnectionsCount > 0) {
                    --dbInstance.numberOfConnectionsCount;
                }
            } else {
                ++dbInfo.numberOfConnectionsCount;
                this.setNamedInstanceUrl(dbInfo, dbInfo.getInstanceName());
                dbInfo.status = 1;
                if (dbInfo.id >= 0) {
                    this.instances.add(dbInfo, dbInfo.id);
                }
            }
        } else if (instId >= 0) {
            OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
            dbInstance.percent = dbInfo.percent;
            dbInstance.flag = dbInfo.flag;
        }
    }

    private void setNamedInstanceUrl(OracleDatabaseInstanceInfo dbInfo, String instanceName) {
        StringBuffer urlBuf = new StringBuffer(this.m_racMngr.getRACCallback().getUrl());
        int keywordIndex = urlBuf.indexOf(CONNECT_DATA_KEYWORD);
        if (keywordIndex == -1) {
            dbInfo.namedInstanceUrl = null;
            logger.finest("connect data keyword not found");
        } else {
            int equalSignIndex = urlBuf.indexOf("=", keywordIndex + CONNECT_DATA_KEYWORD.length());
            if (equalSignIndex == -1) {
                dbInfo.namedInstanceUrl = null;
                logger.finest("equal sign was not found");
            } else {
                urlBuf.insert(equalSignIndex + 1, "(INSTANCE_NAME=" + instanceName + ")");
                dbInfo.namedInstanceUrl = urlBuf.toString();
            }
        }
        logger.log(Level.FINEST, "instance={0}, namedInstanceUrl={1}", new Object[]{dbInfo.getInstanceName(), urlBuf.toString()});
    }

    String getNamedInstanceUrl(String instanceName, String dbUniqName) {
        OracleDatabaseInstanceInfo dbInstance = this.getOracleDatabaseInstanceInfo(instanceName, dbUniqName);
        if (dbInstance != null) {
            return dbInstance.namedInstanceUrl;
        }
        return null;
    }

    boolean isNamedInstanceConnectingAllowed(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        int instId;
        RACCallbackGuard cbk = this.m_racMngr.getRACCallback();
        int upCount = this.getUpInstancesCount();
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqName, instanceName);
        Integer instNum = this.instances.getId(tmpInstance);
        int n = instId = instNum != null ? instNum : -1;
        if (instId < 0) {
            return false;
        }
        OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
        if (dbInstance == null) {
            return false;
        }
        if (dbInstance.status == 1 && dbInstance.flag <= 3) {
            int dbVersion = this.m_racMngr.getDatabaseVersion();
            int connNumThreshold = -1;
            if (dbVersion >= 11100 || !isInstanceAffinityEnabled) {
                float advisoryPercent = this.m_racMngr.firstRLBEventArrived ? (float)dbInstance.percent : 100.0f / (float)this.getUpInstancesCount();
                logger.finest("advisoryPercent=" + advisoryPercent);
                connNumThreshold = Math.round(advisoryPercent * (float)cbk.getMaxPoolSize() / 100.0f);
            } else {
                connNumThreshold = cbk.getRoomToGrowPool() + dbInstance.numNamedInstanceConns;
            }
            logger.log(Level.FINEST, "dbVersion={0}, threshold={1}, connNum={2}", new Object[]{dbVersion, connNumThreshold, dbInstance.numNamedInstanceConns});
            return connNumThreshold > dbInstance.numNamedInstanceConns;
        }
        return false;
    }

    protected int size() {
        return this.instances.size();
    }

    protected FailoverablePooledConnection selectConnectionPerRLBMetrics(ConnectionRetrievalInfo cri, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        int violatingFactor;
        assert (racMngr != null);
        FailoverablePooledConnection pc = null;
        int numInstances = this.instances.size();
        boolean[] tried = new boolean[numInstances];
        int violatingInstCount = this.getViolatingInstancesCount();
        int n = violatingFactor = violatingInstCount != 0 ? this.getUpInstancesCount() / violatingInstCount : Integer.MAX_VALUE;
        if (this.m_useGoodGroup && numInstances > 0) {
            int total = this.m_dbInstancePercentTotal;
            block0: for (int j = 0; j < numInstances; ++j) {
                int percentSum = 0;
                int i = 0;
                int randomPercent = total <= 1 ? 0 : this.m_rand.nextInt(total - 1);
                for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
                    if (!tried[i] && dbInstance.flag <= 3) {
                        if (dbInstance.flag == 3 && violatingFactor > 2) {
                            tried[i] = true;
                            ++i;
                            continue;
                        }
                        logger.log(Level.FINE, "randomPercent={0}, percentSum={1}", new Object[]{randomPercent, percentSum += dbInstance.percent});
                        if (randomPercent <= percentSum) {
                            if (j == 0) {
                                ++dbInstance.attemptedConnRequestCount;
                            }
                            RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                            pc = racMngr.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                            if (pc != null) break block0;
                            total -= dbInstance.percent;
                            tried[i] = true;
                            continue block0;
                        }
                    }
                    ++i;
                }
            }
            if (pc != null) {
                racMngr.incrementSuccessfulRCLBBasedBorrowCount();
            } else {
                racMngr.incrementFailedRCLBBasedBorrowCount();
            }
        }
        return pc;
    }

    protected void processDatabaseInstanceList(BlockingQueue<OracleDatabaseInstanceInfo> instancesToRetireQueue, AtomicInteger countTotal) {
        int numInstances;
        assert (instancesToRetireQueue != null);
        assert (countTotal != null);
        int goodGroupSum = 0;
        this.m_useGoodGroup = false;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (dbInstance.flag <= 3) {
                goodGroupSum += dbInstance.percent;
            }
            logger.log(Level.FINE, "instanceName: {0}, numberOfConnectionsCount: {1}, attemptedConnRequestCount: {2}", new Object[]{dbInstance.getInstanceName(), dbInstance.numberOfConnectionsCount, dbInstance.attemptedConnRequestCount});
        }
        if (goodGroupSum > 0) {
            this.m_dbInstancePercentTotal = goodGroupSum;
            this.m_useGoodGroup = true;
        }
        if ((numInstances = this.instances.size()) > 1) {
            for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
                countTotal.addAndGet(dbInstance.attemptedConnRequestCount);
            }
            int ct = countTotal.get();
            if (ct > numInstances * 1000) {
                boolean resetDBInstanceValues = false;
                for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
                    float ACRRatio = (float)dbInstance.attemptedConnRequestCount / (float)ct;
                    float connRatio = (float)dbInstance.numberOfConnectionsCount / (float)this.m_racMngr.getRACCallback().getTotalConnectionsCount();
                    logger.log(Level.FINE, "m_countTotal: {0}, numInstances: {1}, instanceName: {2}, ACRRatio: {3}, connRatio: {4} ", new Object[]{ct, numInstances, dbInstance.getInstanceName(), Float.valueOf(ACRRatio), Float.valueOf(connRatio)});
                    if (!(connRatio > ACRRatio * 2.0f)) continue;
                    logger.log(Level.FINE, "serviceName: {0},instanceName: {1},ACRRatio: {2},connRatio: {3}", new Object[]{dbInstance.serviceName, dbInstance.getInstanceName(), Float.valueOf(ACRRatio), Float.valueOf(connRatio)});
                    if ((int)((double)dbInstance.numberOfConnectionsCount * 0.25) >= 1) {
                        instancesToRetireQueue.add(dbInstance);
                    }
                    resetDBInstanceValues = true;
                }
                if (resetDBInstanceValues) {
                    for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
                        dbInstance.attemptedConnRequestCount = 0;
                    }
                    resetDBInstanceValues = false;
                }
            }
        }
    }

    protected void removeAll() {
        this.instances.clear();
    }

    protected boolean useGoodGroup() {
        return this.m_useGoodGroup;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(OracleDatabaseInstanceInfo dbInstance, boolean forQueryInstanceId) {
        FailoverablePooledConnection fpc = null;
        String namedInstanceUrl = dbInstance.namedInstanceUrl;
        if (dbInstance.namedInstanceUrl != null) {
            try {
                RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                fpc = this.m_racMngr.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
            }
            catch (Exception exc) {
                fpc = null;
                logger.throwing(this.getClass().getName(), "call to openNewConnection failed: ", exc);
            }
            if (fpc != null) {
                fpc.setAsNamedInstanceConnection();
                if (!forQueryInstanceId) {
                    ++dbInstance.numNamedInstanceConns;
                }
            }
        } else {
            logger.log(Level.FINEST, "URL invalid for connecting to named instance");
        }
        return fpc;
    }

    protected void markUpInstanceForUpEvent(String upServiceName, String upInstanceName, String upHostName, String upDbName) {
        int upInstId;
        OracleDatabaseInstanceInfo upInstance = new OracleDatabaseInstanceInfo(upDbName, upInstanceName, upHostName);
        upInstance.serviceName = upServiceName;
        Integer instNum = this.instances.getId(upInstance);
        int n = upInstId = instNum != null ? instNum : -1;
        if (upInstId != -1) {
            upInstance = this.instances.getInstance(upInstId);
            upInstance.status = 1;
        } else {
            this.setNamedInstanceUrl(upInstance, upInstance.getInstanceName());
            upInstance.status = 1;
            FailoverablePooledConnection namedInstanceConn = this.getConnectionToNamedInstance(upInstance, true);
            if (null != namedInstanceConn) {
                int newInstanceId = namedInstanceConn.getInstanceNumber();
                if (newInstanceId >= 0) {
                    this.instances.add(upInstance, newInstanceId);
                }
                try {
                    namedInstanceConn.close(false);
                }
                catch (UniversalConnectionPoolException exc) {
                    logger.log(Level.FINEST, "closing connection failed", exc);
                }
            } else {
                logger.finest("namedInstanceConn is null");
            }
        }
    }

    protected void markDownInstanceForServiceDownEvent(String downInstanceName, String downDbName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (downInstanceName == null) {
                dbInstance.status = 2;
                continue;
            }
            if (!Util.sameOrEqual(downDbName, dbInstance.getDatabaseName()) || !Util.sameOrEqual(downInstanceName, dbInstance.getInstanceName())) continue;
            dbInstance.status = 2;
        }
    }

    protected void markDownInstanceForHostDownEvent(String downHostName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (!Util.sameOrEqual(downHostName, dbInstance.getHostName())) continue;
            dbInstance.status = 2;
        }
    }

    protected int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    int getViolatingInstancesCount() {
        int violatingCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (dbInstance.status != 1 || dbInstance.flag != 3) continue;
            ++violatingCount;
        }
        return violatingCount;
    }

    OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(String instanceName, String databaseName) {
        return this.instances.getInstance(databaseName, instanceName);
    }

    OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(int instanceId) {
        return this.instances.getInstance(instanceId);
    }

    INSTANCE_CATEGORY_FOR_DATA_AFFINITY getInstanceCategory(OracleDatabaseInstanceInfo dbInstance) {
        String instanceKey = this.m_racMngr.generateDatabaseInstanceKey(dbInstance.getInstanceName(), dbInstance.getDatabaseName(), dbInstance.serviceName);
        boolean affinityHint = this.m_racMngr.getConnectionAffinityValue(instanceKey);
        if (dbInstance.status == 1 && (dbInstance.flag == 1 || dbInstance.flag == 2) && affinityHint) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.GOOD_INSTANCE;
        }
        if (!(dbInstance.status != 1 || dbInstance.flag != 3 && affinityHint)) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.VIOLATING_INSTANCE;
        }
        return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.BAD_INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum INSTANCE_CATEGORY_FOR_DATA_AFFINITY {
        GOOD_INSTANCE,
        VIOLATING_INSTANCE,
        BAD_INSTANCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Instances {
        private static final String BROKEN = "instance info base integrity is broken";
        private Map<OracleDatabaseInstanceInfo, Integer> instanceToId = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        private Map<Integer, OracleDatabaseInstanceInfo> idToInstance = new HashMap<Integer, OracleDatabaseInstanceInfo>();

        Instances() {
        }

        synchronized OracleDatabaseInstanceInfo getInstance(int id) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (id >= 0) : "negative id";
            return this.idToInstance.get(id);
        }

        synchronized OracleDatabaseInstanceInfo getInstance(String databaseName, String instanceName) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.idToInstance.get(this.instanceToId.get(new OracleDatabaseInstanceInfo(databaseName, instanceName)));
        }

        synchronized Collection<OracleDatabaseInstanceInfo> getAllInstances() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return new ArrayList<OracleDatabaseInstanceInfo>(this.idToInstance.values());
        }

        synchronized Integer getId(OracleDatabaseInstanceInfo instance) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.get(instance);
        }

        synchronized Collection<Integer> getAllIds() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return new ArrayList<Integer>(this.instanceToId.values());
        }

        synchronized void add(OracleDatabaseInstanceInfo instance, int id) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (id >= 0) : "negative id";
            assert (null != instance) : "instance is null";
            Integer oldId = this.instanceToId.get(instance);
            OracleDatabaseInstanceInfo oldInstance = this.idToInstance.get(id);
            if (null != oldId && oldId.equals(id) && null != oldInstance && oldInstance.equals(instance)) {
                return;
            }
            assert (null == oldId && null == oldInstance) : "some other pair with either given instance or id has been previously written";
            this.instanceToId.put(instance, id);
            this.idToInstance.put(id, instance);
        }

        synchronized boolean remove(int id) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (id >= 0) : "negative id";
            OracleDatabaseInstanceInfo instance = this.idToInstance.get(id);
            if (null == instance) {
                return false;
            }
            this.instanceToId.remove(instance);
            this.idToInstance.remove(id);
            return true;
        }

        synchronized boolean remove(OracleDatabaseInstanceInfo instance) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            Integer id = this.instanceToId.get(instance);
            if (null == id) {
                return false;
            }
            this.instanceToId.remove(instance);
            this.idToInstance.remove(id);
            return true;
        }

        synchronized int size() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.size();
        }

        synchronized void clear() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            this.instanceToId.clear();
            this.idToInstance.clear();
        }
    }
}

