/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;

class RACInstanceImpl
implements RACInstance {
    private final String service;
    private final String instance;
    private final String host;
    private final String database;
    private int percent = 0;
    private OracleLoadBalancingEvent.InstanceStatus status = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
    private boolean affinityHint = false;

    RACInstanceImpl(String service, String instance, String host, String database) {
        this.service = service;
        this.instance = instance;
        this.host = host;
        this.database = database;
    }

    RACInstanceImpl(OracleDatabaseInstanceInfo dbinfo) {
        this.service = dbinfo.serviceName;
        this.instance = dbinfo.getInstanceName();
        this.host = dbinfo.getHostName();
        this.database = dbinfo.getDatabaseName();
    }

    public String getService() {
        return this.service;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getPercent() {
        return this.percent;
    }

    public OracleLoadBalancingEvent.InstanceStatus getInstanceStatus() {
        return this.status;
    }

    void setPercent(int rlbPercent) {
        this.percent = rlbPercent;
    }

    void setStatus(OracleLoadBalancingEvent.InstanceStatus rlbStatus) {
        this.status = rlbStatus;
    }

    boolean getAffinityHint() {
        return this.affinityHint;
    }

    void setAffinityHint(boolean affHint) {
        this.affinityHint = affHint;
    }

    public String toString() {
        return "Service name: " + this.service + ", Instance name: " + this.instance + ", Host name: " + this.host + ", Database unique name: " + this.database;
    }
}

