/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.internal.OracleResultSet;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={ResultSet.class, OracleResultSet.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ResultSetProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Chain.Atom<ResultSetProxy> resultSetChainAtom = null;
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;

    void setResultSetChainAtom(Chain.Atom<ResultSetProxy> atom) {
        this.resultSetChainAtom = atom;
    }

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    private UniversalPooledConnection getUPC() {
        StatementProxy c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = (StatementProxy)this.getCreator())) {
            upc = this.proxiedPooledConnection = c.getUPC();
        }
        return upc;
    }

    private UniversalConnectionPool getUCP() {
        StatementProxy c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = (StatementProxy)this.getCreator())) {
            ucp = this.proxiedPool = c.getUCP();
        }
        return ucp;
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(43);
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ResultSet getCursor(int columnIndex) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getCursor(columnIndex);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ResultSet getCursor(String columnName) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getCursor(columnName);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Class<?> type) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex, map);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Class<?> type) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName, map);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.resultSetChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
    }

    public boolean isClosed() throws SQLException {
        return this.closed.get() || ((Statement)this.getCreator()).isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Pre
    @Methods(signatures={@Signature(name="getACProxy", args={}), @Signature(name="setACProxy", args={Object.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(43);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        if (stmtProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        ConnectionProxyBase connProxy = (ConnectionProxyBase)stmtProxy.getCreator();
        if (connProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorvoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        ConnectionProxyBase connProxy = (ConnectionProxyBase)stmtProxy.getCreator();
        connProxy.handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorvoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        ConnectionProxyBase connProxy = (ConnectionProxyBase)stmtProxy.getCreator();
        connProxy.handleRuntimeException(e);
        throw e;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ResultSetProxy ? ((ResultSetProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    static {
        try {
            $$$methodRef$$$25 = ResultSetProxy.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = ResultSetProxy.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = ResultSetProxy.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ResultSetProxy.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ResultSetProxy.class.getDeclaredMethod("onRuntimeExceptionError", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ResultSetProxy.class.getDeclaredMethod("onRuntimeExceptionErrorvoid", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ResultSetProxy.class.getDeclaredMethod("onSQLExceptionError", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ResultSetProxy.class.getDeclaredMethod("onSQLExceptionErrorvoid", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ResultSetProxy.class.getDeclaredMethod("pre", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ResultSetProxy.class.getDeclaredMethod("preNoThrow", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ResultSetProxy.class.getDeclaredMethod("isLogicallyClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ResultSetProxy.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ResultSetProxy.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ResultSetProxy.class.getDeclaredMethod("getObject", String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ResultSetProxy.class.getDeclaredMethod("getObject", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ResultSetProxy.class.getDeclaredMethod("getObject", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ResultSetProxy.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ResultSetProxy.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ResultSetProxy.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ResultSetProxy.class.getDeclaredMethod("getCursor", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ResultSetProxy.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ResultSetProxy.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ResultSetProxy.class.getDeclaredMethod("throwIfClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ResultSetProxy.class.getDeclaredMethod("getUCP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ResultSetProxy.class.getDeclaredMethod("getUPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ResultSetProxy.class.getDeclaredMethod("setResultSetChainAtom", Chain.Atom.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

