/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.ucp.common.Clock;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Util;

public class ConnectionCreationBroker {
    private static final Long MIN_INTERVAL;
    public static final Long MAX_INTERVAL;
    private volatile long recentAttemptTimestamp = 0L;
    private volatile long retryInterval = 0L;
    private final Lock lock = new ReentrantLock();
    private final BlockingSemaphore blockingSemaphore = new BlockingSemaphore();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    void markOperable() {
        this.lock.lock();
        try {
            this.recentAttemptTimestamp = 0L;
            this.retryInterval = 0L;
            ClioSupport.ilogFinest(null, null, null, null, "made operable: broker=" + this.toString());
            this.blockingSemaphore.unblock();
        }
        finally {
            this.lock.unlock();
        }
    }

    void markInoperable() {
        this.lock.lock();
        try {
            this.blockingSemaphore.block();
            if (0L == this.recentAttemptTimestamp) {
                this.recentAttemptTimestamp = Clock.clock();
                this.retryInterval = MIN_INTERVAL;
                ClioSupport.ilogFinest(null, null, null, null, "made inoperable: broker=" + this.toString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long appointNextAttempt() {
        this.lock.lock();
        try {
            if (0L == this.recentAttemptTimestamp) {
                long l = 0L;
                return l;
            }
            long now = Clock.clock();
            long timeToWait = Math.max(0L, this.recentAttemptTimestamp + this.retryInterval - now);
            if (0L == timeToWait) {
                this.recentAttemptTimestamp = now;
                long retryDelay = Util.getConnectionCreationRetryDelay();
                ClioSupport.ilogFinest(null, null, null, null, "retryDelay=" + retryDelay);
                this.retryInterval = Math.min(retryDelay, 2L * this.retryInterval);
            }
            ClioSupport.ilogFinest(null, null, null, null, "timeToWait=" + timeToWait + ", broker=" + this.toString());
            long l = timeToWait;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    void waitOnBroker(long msecsToWait) {
        this.blockingSemaphore.waitOnSemaphore(msecsToWait);
    }

    public String toString() {
        return "recentAttemptTimestamp=" + this.recentAttemptTimestamp + ", retryInterval=" + this.retryInterval;
    }

    static {
        try {
            $$$methodRef$$$5 = ConnectionCreationBroker.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ConnectionCreationBroker.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ConnectionCreationBroker.class.getDeclaredMethod("waitOnBroker", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ConnectionCreationBroker.class.getDeclaredMethod("appointNextAttempt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ConnectionCreationBroker.class.getDeclaredMethod("markInoperable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ConnectionCreationBroker.class.getDeclaredMethod("markOperable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        MIN_INTERVAL = 1000L;
        MAX_INTERVAL = 3000L;
    }

    static class BlockingSemaphore
    extends Semaphore {
        private boolean blocked = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        BlockingSemaphore() {
            super(Integer.MAX_VALUE);
        }

        private void block() {
            if (!this.blocked) {
                super.reducePermits(Integer.MAX_VALUE);
                this.blocked = true;
            }
        }

        private void unblock() {
            if (this.blocked) {
                super.release(Integer.MAX_VALUE);
                this.blocked = false;
            }
        }

        private void waitOnSemaphore(long msecsToWait) {
            try {
                if (super.tryAcquire(msecsToWait, TimeUnit.MILLISECONDS)) {
                    super.release();
                }
            }
            catch (InterruptedException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }

        static {
            try {
                $$$methodRef$$$6 = BlockingSemaphore.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = BlockingSemaphore.class.getDeclaredMethod("access$200", BlockingSemaphore.class, Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = BlockingSemaphore.class.getDeclaredMethod("access$100", BlockingSemaphore.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = BlockingSemaphore.class.getDeclaredMethod("access$000", BlockingSemaphore.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = BlockingSemaphore.class.getDeclaredMethod("waitOnSemaphore", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = BlockingSemaphore.class.getDeclaredMethod("unblock", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = BlockingSemaphore.class.getDeclaredMethod("block", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

