/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolElement;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.Queue;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T data) {
        Queue<Element> putRevisitQueue = new Queue<Element>();
        Element element = this.listHead;
        assert (null != element);
        Element farthestElement = element;
        while (null != element) {
            block17: {
                farthestElement = element;
                if (element.tryReserve()) {
                    try {
                        if (element.data == null) {
                            element.data = data;
                            return;
                        }
                        break block17;
                    }
                    finally {
                        element.release();
                    }
                }
                putRevisitQueue.enqueue(element);
            }
            element = (Element)element.next.get();
        }
        Element first = null;
        while (null != (element = (Element)putRevisitQueue.dequeue())) {
            if (first == element) {
                first = null;
                Thread.yield();
            }
            if (null == first) {
                first = element;
            }
            if (element.tryReserve()) {
                try {
                    if (null != element.data) continue;
                    element.data = data;
                    return;
                }
                finally {
                    element.release();
                    continue;
                }
            }
            putRevisitQueue.enqueue(element);
        }
        element = farthestElement;
        assert (null != element);
        Element newElement = new Element(data);
        while (true) {
            if (element.next.compareAndSet(null, newElement)) {
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
            assert (null != element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T findFirst(Predicate<T> selector, Consumer<T> applicator, ThreadLocal<Deque<PoolElement<T>>> tlCache, int cacheMaxSize) {
        Object d;
        Deque<PoolElement<T>> cache = tlCache.get();
        PoolElement elm = null;
        T data = null;
        if (null != cache) {
            PoolIterator<PoolElement<T>> cacheIt = this.poolElementsIterator(false, cache.iterator());
            try {
                while (cacheIt.hasNext()) {
                    elm = (PoolElement)cacheIt.next();
                    d = elm.getData();
                    if (!selector.test(d)) continue;
                    applicator.accept(d);
                    data = d;
                    break;
                }
            }
            finally {
                cacheIt.release();
            }
            if (null != data) {
                cache.remove(elm);
                cache.addFirst(elm);
                return data;
            }
        }
        elm = null;
        data = null;
        PoolIterator<PoolElement<T>> it = this.poolElementsIterator(false, null);
        try {
            while (it.hasNext()) {
                elm = (PoolElement)it.next();
                d = elm.getData();
                if (!selector.test(d)) continue;
                applicator.accept(d);
                data = d;
                break;
            }
        }
        finally {
            it.release();
        }
        if (null != data) {
            cache.addFirst(elm);
            while (cache.size() > cacheMaxSize) {
                cache.removeLast();
            }
            return data;
        }
        return null;
    }

    @Override
    public PoolIterator<T> poolIterator(boolean revisit) {
        return this.poolIterator(revisit, null);
    }

    private PoolIterator<T> poolIterator(final boolean revisit, final Iterator<PoolElement<T>> iterator) {
        return new PoolIterator<T>(){
            private final PoolIterator<PoolElement<T>> it;
            {
                this.it = LinkedListPool.this.poolElementsIterator(revisit, iterator);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return ((PoolElement)this.it.next()).getData();
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public void release() {
                this.it.release();
            }

            @Override
            public boolean isSleeping() {
                return this.it.isSleeping();
            }

            @Override
            public boolean isAlive() {
                return this.it.isAlive();
            }
        };
    }

    private PoolIterator<PoolElement<T>> poolElementsIterator(final boolean revisit, final Iterator<PoolElement<T>> iterator) {
        final Thread iteratorThread = Thread.currentThread();
        return new PoolIterator<PoolElement<T>>(){
            volatile Iterator<PoolElement<T>> it;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final Queue<Element> revisitQueue;
            {
                this.it = null != iterator ? iterator : LinkedListPool.this.elementsIterator();
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new Queue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && iteratorThread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (iteratorThread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            private Element reserveNext() {
                Element element;
                while (this.it.hasNext()) {
                    PoolElement poolElement = this.it.next();
                    element = (Element)poolElement;
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            return element;
                        }
                        element.release();
                        continue;
                    }
                    if (this.preReserved(element)) {
                        if (element.data == null) continue;
                        this.outerReservation = true;
                        return element;
                    }
                    if (!revisit) continue;
                    this.revisitQueue.enqueue(element);
                }
                Element first = null;
                while (revisit) {
                    element = this.revisitQueue.dequeue();
                    if (element == null) {
                        return null;
                    }
                    if (element == first) {
                        first = null;
                        Thread.yield();
                    }
                    if (null == first) {
                        first = element;
                    }
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            return element;
                        }
                        element.release();
                        continue;
                    }
                    this.revisitQueue.enqueue(element);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public Element next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    this.nextReserved = false;
                    return this.currentElement;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement == null) {
                    throw new IllegalStateException();
                }
                this.currentElement.data = null;
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }
        };
    }

    private Iterator<PoolElement<T>> elementsIterator() {
        return new Iterator<PoolElement<T>>(){
            private Element current;
            {
                this.current = LinkedListPool.this.listHead;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public PoolElement<T> next() {
                if (null != this.current) {
                    Element element = this.current;
                    this.current = (Element)this.current.next.get();
                    return element;
                }
                return null;
            }
        };
    }

    private final class Element
    implements PoolElement<T> {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;

        private Element() {
            this((Object)null);
        }

        private Element(T data) {
            this.data = data;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread currentThread = Thread.currentThread();
            if (!this.reserved.compareAndSet(currentThread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + currentThread);
            }
        }

        @Override
        public T getData() {
            return this.data;
        }
    }
}

