/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.logging.annotations.DisableTrace;

@DisableTrace
public class UCPErrorHandler {
    private static final String messageFile = "oracle.ucp.util.UCPMessages";
    private static ResourceBundle m_bundle;
    public static final int UCP_ERROR_CODE_BASE = 45000;
    public static final int UCP_MAX_ERRORS = 500;
    public static final int UCP_SUCCESS = 0;
    public static final int UCP_GENERIC_ERROR = 1;
    public static final int UCP_NO_AVAILABLE_CONNECTIONS = 2;
    public static final int UCP_POOL_ALREADY_EXISTS = 3;
    public static final int UCP_INVALID_RETRIEVAL_CREDENTIALS = 4;
    public static final int UCP_CALLBACK_ALREADY_REGISTERED = 5;
    public static final int UCP_INVALID_POOL_CONFIGURATION = 6;
    public static final int UCP_RANGED_MAPPING_BASE = 50;
    public static final int UCP_COMMON_POOL_INACTIVE_TIMER_SCHEDULE = 51;
    public static final int UCP_COMMON_POOL_ABANDONED_TIMER_SCHEDULE = 52;
    public static final int UCP_COMMON_POOL_TTL_TIMER_SCHEDULE = 53;
    public static final int UCP_COMMON_POOL_NULL = 54;
    public static final int UCP_COMMON_POOL_RM_AVAIL_CONN = 55;
    public static final int UCP_COMMON_POOL_NO_VALID_CONNECTION = 56;
    public static final int UCP_COMMON_POOL_AVAILABLECONNECTIONS_NULL = 57;
    public static final int UCP_COMMON_POOL_FAILOVERABLE_NULL = 58;
    public static final int UCP_COMMON_POOL_NOCONNECTIONS = 59;
    public static final int UCP_COMMON_POOL_INVALID_LIFECYCLE_STATE = 60;
    public static final int UCP_COMMON_POOL_NOTSTARTED = 61;
    public static final int UCP_COMMON_POOL_SETAVAILABLECONNECTIONS = 62;
    public static final int UCP_COMMON_POOL_SHUTDOWN = 63;
    public static final int UCP_COMMON_POOL_ALLCONNECTIONS_INUSE = 64;
    public static final int UCP_COMMON_POOL_ABOUT_TO_SHUTDOWN = 65;
    public static final int UCP_COMMON_POOL_INSUFFICIENT_INITIAL_CONNECTIONS = 66;
    public static final int UCP_COMMON_POOL_UNABLE_TO_CREATE_CONNECTION = 67;
    public static final int SQL_AC_INIT_CALLBACK_ERROR = 68;
    public static final int UCP_COMMON_POOL_LABELING_CBK_REGISTERED = 91;
    public static final int UCP_COMMON_POOL_NO_LABELING_CBK = 92;
    public static final int UCP_COMMON_POOL_LABEL_BORROW_MISMATCH = 93;
    public static final int UCP_COMMON_POOL_HARVEST_TIMER_SCHEDULE = 97;
    public static final int UCP_COMMON_CFA_RETURNED_NULL = 100;
    public static final int UCP_COMMON_CFA_INSTANCE_ERROR1 = 103;
    public static final int UCP_COMMON_CFA_NULL = 104;
    public static final int UCP_COMMON_CFA_INSTANCE_ERROR2 = 105;
    public static final int UCP_COMMON_CFA_INSTANCE_ERROR3 = 106;
    public static final int UCP_COMMON_UPC_NULL = 150;
    public static final int UCP_COMMON_UPC_WRONG_SQL = 151;
    public static final int UCP_COMMON_UPC_STATUS_NULL = 152;
    public static final int UCP_COMMON_UPC_LABEL_KEY_EMPTY = 153;
    public static final int UCP_COMMON_UPC_CLOSED = 154;
    public static final int UCP_COMMON_UPC_HARVESTING_CBK_REGISTERED = 155;
    public static final int UCP_COMMON_UPC_ABANDONED_CBK_REGISTERED = 156;
    public static final int UCP_COMMON_UPC_TTL_CBK_REGISTERED = 157;
    public static final int UCP_COMMON_CRI_LABEL_KEY_EMPTY = 201;
    public static final int UCP_COMMON_CRI_NOLABEL_CLONE_FAILURE = 202;
    public static final int UCP_COMMON_CRI_NULL = 203;
    public static final int UCP_COMMON_SERVICE_MISMATCH = 204;
    public static final int UCP_JDBC_CONNECTIONPOOLDATASOURCE_NULL = 251;
    public static final int UCP_JDBC_INVALID_CONNECTIONRETRIEVALINFO_OBJECT = 252;
    public static final int UCP_JDBC_CONNECTIONPOOLDATASOURCE_SQLEXCEPTION = 253;
    public static final int UCP_JDBC_INVALID_CONNECTIONTYPE = 254;
    public static final int UCP_JDBC_CONNECTIONCLOSE_EXCEPTION = 255;
    public static final int UCP_JDBC_DATASOURCE_NULL = 256;
    public static final int UCP_JDBC_GETCONNECTION_EXCEPTION = 257;
    public static final int UCP_JDBC_INVALID_PROXY_CONNECTIONTYPE = 258;
    public static final int UCP_JDBC_PROXY_CONNECTION_EXCEPTION = 259;
    public static final int UCP_JDBC_NOT_XADATASOURCE_NULL = 260;
    public static final int UCP_JDBC_XADATASOURCE_SQLEXCEPTION = 261;
    public static final int UCP_JDBC_INVALID_XACONNECTIONTYPE = 262;
    public static final int UCP_JDBC_XACONNECTIONCLOSE_EXCEPTION = 263;
    public static final int UCP_JDBC_CONNECTION_NULL = 264;
    public static final int UCP_JDBC_PROXY_STATEMENT_EXCEPTION = 265;
    public static final int UCP_JDBC_PROXY_RESULTSET_EXCEPTION = 266;
    public static final int UCP_JDBC_PROXY_XACONNECTION_EXCEPTION = 267;
    public static final int UCP_JDBC_DRIVER_NULL = 268;
    public static final int UCP_JDBC_URL_NULL = 269;
    public static final int UCP_JDBC_POOL_INIT_CBK_REGISTERED = 270;
    public static final int UCP_JDBC_POOL_INIT_CBK_FAILURE = 271;
    public static final int UCP_JDBC_INVALID_USE_OF_SHARED_POOL = 272;
    public static final int UCP_JDBC_NON_SHARED_POOL_INVALID_CONFIG_EXCEPTION = 273;
    public static final int UCP_JDBC_UNABLE_TO_SET_QUERY_TIMEOUT = 274;
    public static final int UCP_JDBC_DUPLICATE_POOL_NAME = 275;
    public static final int UCP_JDBC_DUPLICATE_DATASOURCE_NAME = 276;
    public static final int UCP_JDBC_MISSING_SHARD_KEY_CONNECTION_REQUEST = 277;
    public static final int UCP_JDBC_INVALID_CONNECTION_REQUEST_PARAMETER = 278;
    public static final int UCP_JDBC_CANNOT_RECONFIGURE_MAX_PER_SERVICE = 279;
    public static final int UCP_JDBC_INVALID_GLOBAL_SERVICE_NAME = 280;
    public static final int UCP_JDBC_ORACLE_FOVR_CONN_NULL = 301;
    public static final int UCP_JDBC_ORACLE_FOVR_CONN_QUERY = 302;
    public static final int UCP_JDBC_ORACLE_FOVR_CONN_SQLEXC = 303;
    public static final int UCP_JDBC_ORACLE_EVENTTYPE_NULL = 304;
    public static final int UCP_JDBC_ORACLE_INVALID_EVENTTYPE = 305;
    public static final int UCP_JDBC_ORACLE_INVALID_FAILOVER_EVENTTYPE = 306;
    public static final int UCP_JDBC_ORACLE_INVALID_AFFINITY_CXT = 307;
    public static final int UCP_JDBC_ORACLE_REMOTE_ONS_PRIVILEGE = 308;
    public static final int UCP_JDBC_ORACLE_BEGINREQUEST_FAILURE = 309;
    public static final int UCP_JDBC_ORACLE_ENDREQUEST_FAILURE = 310;
    public static final int UCP_JDBC_ORACLE_NO_AVAIL_CONN_FOR_STRICT_AFFINITY = 311;
    public static final int UCP_JDBC_ORACLE_REMOTE_ONS_INIT = 312;
    public static final int UCP_JDBC_ORACLE_AUTO_ONS_CONFIG = 313;
    public static final int UCP_JDBC_ORACLE_INVALID_RAC_DATA_AFFINITY_CONFIG = 314;
    public static final int UCP_ADMIN_MGR_POOL_ALREADY_EXISTS = 350;
    public static final int UCP_ADMIN_MGR_POOL_DOESNOT_EXIST = 351;
    public static final int UCP_ADMIN_MGR_CANNOT_GETINSTANCE = 352;
    public static final int UCP_ADMIN_MGRMBEAN_CANNOT_GETINSTANCE = 353;
    public static final int UCP_ADMIN_MBEAN_MALFORM_OBJECTNAME = 354;
    public static final int UCP_ADMIN_MBEAN_REG_UNREG_EXCEPTION = 355;
    public static final int UCP_ADMIN_MBEAN_INSTANCE_EXISTS = 356;
    public static final int UCP_ADMIN_MBEAN_NOT_COMPLIANT = 357;
    public static final int UCP_ADMIN_MBEAN_INSTANCE_NOTFOUND = 358;
    public static final int UCP_ADMIN_MBEAN_INVALID_TARGET = 359;
    public static final int UCP_ADMIN_MGRMBEAN_DESCRIPTOR_EXCEPTION = 360;
    public static final int UCP_ADMIN_MGRMBEAN_MBEANINFO_EXCEPTION = 361;
    public static final int UCP_ADMIN_MGRMBEAN_CONINFO_EXCEPTION = 362;
    public static final int UCP_ADMIN_MGRMBEAN_ATTRINFO_EXCEPTION = 363;
    public static final int UCP_ADMIN_MGRMBEAN_OPERINFO_EXCEPTION = 364;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_INSTANCE = 365;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_DESCRIPTOR_EXCEPTION = 366;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_MBEANINFO_EXCEPTION = 367;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_CONINFO_EXCEPTION = 368;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_ATTRINFO_EXCEPTION = 369;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_OPERINFO_EXCEPTION = 370;
    public static final int UCP_ADMIN_COMMONPOOLMBEAN_ATTRINFO_EXCEPTION = 371;
    public static final int UCP_ADMIN_COMMONPOOLMBEAN_OPERINFO_EXCEPTION = 372;
    public static final int UCP_ADMIN_COMMONPOOLMBEAN_DESCRIPTOR_EXCEPTION = 373;
    public static final int UCP_ADMIN_COMMONPOOLMBEAN_MBEANINFO_EXCEPTION = 374;
    public static final int UCP_ADMIN_STOP_METRIC_COLLECTION = 375;
    public static final int UCP_ADMIN_METRIC_UPDATE_TIMER = 376;
    public static final int UCP_ADMIN_METRIC_UPDATE_SENSORS = 377;
    public static final int UCP_ADMIN_JDBCPOOLMBEAN_ORACLEPOOL_NULL = 378;
    public static final int UCP_ADMIN_COMMONPOOLMBEAN_CANNOT_SET_POOLNAME = 379;
    public static final int UCP_ADMIN_MBEAN_NULL = 380;
    public static final int UCP_ADMIN_MBEAN_OBJNAME_NULL = 381;
    public static final int UCP_ADMIN_MBEAN_DISPLAYNAME_NULL = 382;
    public static final int UCP_ADMIN_MGR_INVALID_ADAPTER = 383;
    public static final int UCP_ADMIN_MGRMBEAN_INVALID_ADAPTER = 384;
    public static final int UCP_ADMIN_MGR_POOL_CREATION = 385;
    public static final int UCP_ADMIN_MGRMBEAN_POOL_CREATION = 386;
    public static final int UCP_POOL_CONFIGURATION_INVALID_XML = 387;
    public static final int UCP_POOL_RECONFIGURATION_INVALID_XML = 388;
    public static final int UCP_POOL_MAX_PER_SHARD_LIMIT_EXCEEDED = 389;
    public static final int UCP_WTP_MIN_WAITING_THREADS_NEGATIVE = 401;
    public static final int UCP_WTP_MAX_WAITING_THREADS_NEGATIVE = 402;
    public static final int UCP_WTP_MAX_TOTAL_THREADS_NEGATIVE = 403;
    public static final int UCP_WTP_QUEUE_POLL_TIMEOUT_NEGATIVE = 404;
    public static final int UCP_WTP_WAITING_THREADS_MIN_GT_MAX = 405;
    public static final int UCP_WTP_TOTAL_THREADS_LT_WAITING = 406;
    public static final int UCP_UTIL_ERROR_OUT_OF_RANGE = 407;
    public static final int UCP_UTIL_NULL_LOGGER = 408;
    public static final int SQL_CANNOT_START_POOL = 0;
    public static final int SQL_CANNOT_BUILD_POOL = 1;
    public static final int SQL_INVALID_MIN_POOL_SIZE = 2;
    public static final int SQL_INVALID_MAX_POOL_SIZE = 3;
    public static final int SQL_INVALID_INACTIVE_TIMEOUT = 4;
    public static final int SQL_INVALID_CONN_WAIT_TIMEOUT = 5;
    public static final int SQL_INVALID_TIMETO_LIVE_CONN_TIMEOUT = 6;
    public static final int SQL_INVALID_ABAN_CONN_TIMEOUT = 7;
    public static final int SQL_INVALID_TIME_CHK_INTERVAL = 8;
    public static final int SQL_FAILED_ENABLE_FAILOVER = 9;
    public static final int SQL_FAILED_MAX_STATEMENTS = 10;
    public static final int SQL_FAILED_SQL_STRING = 11;
    public static final int SQL_INVALID_CONN_HARVEST_TRIGGER_COUNT = 12;
    public static final int SQL_INVALID_CONN_HARVEST_MAX_COUNT = 13;
    public static final int SQL_POOL_ALREADY_CREATED = 14;
    public static final int SQL_POOL_DESTROY_ERROR = 15;
    public static final int SQL_POOL_ORACLE_ONS_CONFIG_ERROR = 16;
    public static final int SQL_POOL_ONS_CONFIG_ERROR = 17;
    public static final int SQL_POOL_REG_LABEL_CB_ERROR = 18;
    public static final int SQL_POOL_REMOVE_LABEL_CB_ERROR = 19;
    public static final int SQL_POOL_REG_AFFI_CB_ERROR = 20;
    public static final int SQL_POOL_REMOVE_AFFI_CB_ERROR = 21;
    public static final int SQL_INVALID_POOL_CONFIGURATION = 22;
    public static final int SQL_CANNOT_CREATE_FACTORY_CLASS = 23;
    public static final int SQL_CANNOT_SET_USER = 24;
    public static final int SQL_CANNOT_SET_PWD = 25;
    public static final int SQL_CANNOT_SET_URL = 26;
    public static final int SQL_FACTORY_INSTANCE = 27;
    public static final int SQL_NO_AVAIL_CONN_ERROR = 28;
    public static final int SQL_CANNOT_GET_CONNECTION = 29;
    public static final int SQL_COMMON_POOL_NOTSTARTED = 30;
    public static final int SQL_CONNECTION_CLOSED = 31;
    public static final int SQL_APPLY_CONNECTION_LABEL = 32;
    public static final int SQL_REMOVE_CONNECTION_LABEL = 33;
    public static final int SQL_LABELS_ERROR = 34;
    public static final int SQL_UNMATCHED_LABELS_ERROR = 35;
    public static final int SQL_CONN_HARVEST_ERROR = 36;
    public static final int SQL_REG_HARVEST_CB_ERROR = 37;
    public static final int SQL_REMOVE_HARVEST_CB_ERROR = 38;
    public static final int SQL_REG_ABAN_CB_ERROR = 39;
    public static final int SQL_REMOVE_ABAN_CB_ERROR = 40;
    public static final int SQL_REG_TIME_CB_ERROR = 41;
    public static final int SQL_REMOVE_TIME_CB_ERROR = 42;
    public static final int SQL_RS_CLOSED = 43;
    public static final int SQL_STATEMENT_CLOSED = 44;
    public static final int SQL_CANNOT_SET_NAME = 45;
    public static final int SQL_STRING_NULL = 46;
    public static final int SQL_SETINVALID_ERROR = 47;
    public static final int SQL_CANNOT_SET_CONNECTION_PROPERTIES = 48;
    public static final int SQL_CANNOT_SET_DATABASE_SERVER_NAME = 49;
    public static final int SQL_CANNOT_SET_DATABASE_PORTNUMBER = 50;
    public static final int SQL_CANNOT_SET_DATABASE_NAME = 51;
    public static final int SQL_CANNOT_SET_DATASOURCE_NAME = 52;
    public static final int SQL_CANNOT_SET_DATASOURCE_DESCRIPTION = 53;
    public static final int SQL_CANNOT_SET_DATASOURCE_NETWORKPROTOCOL = 54;
    public static final int SQL_CANNOT_SET_DATASOURCE_ROLENAME = 55;
    public static final int SQL_INVALID_MAX_CONN_REUSE_TIME = 56;
    public static final int SQL_INVALID_MAX_CONN_REUSE_COUNT = 57;
    public static final int SQL_DISABLED_METHOD = 58;
    public static final int SQL_CANNOT_SET_CONN_FACTORY_PROPERTIES = 59;
    public static final int SQL_POOL_REG_INIT_CB_ERROR = 60;
    public static final int SQL_POOL_REMOVE_INIT_CB_ERROR = 61;
    public static final int SQL_ARG_NOT_AN_INTERFACE = 62;
    public static final int SQL_INVALID_LABELING_HIGH_COST = 63;
    public static final int SQL_INVALID_HIGH_COST_CONN_REUSE_THRESHOLD = 64;
    public static final int SQL_NULL_CONN_IN_INIT_CBK = 65;
    public static final int SQL_INVALID_CONN_TYPE_IN_INIT_CBK = 66;
    public static final int SQL_INVALID_ISVALID_TIMEOUT = 67;
    public static final int SQL_INVALID_SECONDS_TO_TRUST_IDLE_CONNECTION = 68;
    public static final int SQL_CANNOT_SET_LOGIN_TIMEOUT = 69;
    public static final int SQL_INVALID_LABEL_KEY = 70;
    public static final int SQL_INVALID_LABEL_VALUE = 71;
    public static final int SQL_INVALID_DATASOURCE_RECONFIGURATION = 72;
    public static final int SQL_DATASOURCE_NOT_PRESENT_IN_CONFIG = 73;
    public static final int SQL_POOL_CONFIGURATION_NOT_PRESENT_IN_XML = 74;
    public static final int SQL_XML_SYSTEM_PROPERTY_NOT_SET = 75;
    public static final int SQL_DATASOURCE_NOT_ASSOCIATED_TO_POOL = 76;
    public static final int SQL_INVALID_MAX_CONN_PER_SERVICE = 77;
    public static final int SQL_DATASOURCE_ALREADY_DEFINED_IN_CONFIGURATION = 78;
    public static final int SQL_CANNOT_ASSOCIATE_NON_XA_DATASOURCE_WITH_XA_POOL = 79;
    public static final int SQL_CANNOT_ASSOCIATE_XA_DATASOURCE_WITH_NON_XA_POOL = 80;
    public static final int UNIVERSAL_CONNECTION_POOL_EXCEPTION = 1;
    public static final int NO_AVAILABLE_CONNECTIONS_EXCEPTION = 2;
    public static final int POOL_ALREADY_EXISTS_EXCEPTION = 3;
    public static final int INVALID_RETRIEVAL_CREDENTIALS_EXCEPTION = 4;
    public static final int CALLBACK_ALREADY_REGISTERED_EXCEPTION = 5;
    public static final int INVALID_POOL_CONFIGURATION_EXCEPTION = 6;
    private static final int DEFAULT_EXCEPTION_ID = 1;
    private static final int[][] mappings;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;

    public static void throwUniversalConnectionPoolException(int errorNumber, Throwable cause, String additionalMessage) throws UniversalConnectionPoolException {
        if (errorNumber == 0) {
            return;
        }
        String reason = UCPErrorHandler.findMessage(errorNumber, cause) + (String)(null != additionalMessage ? " - " + additionalMessage : "");
        int vendorCode = UCPErrorHandler.getVendorCode(errorNumber);
        UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(UCPErrorHandler.findExceptionId(vendorCode), reason, vendorCode);
        e.initCause(cause);
        throw e;
    }

    public static void throwUniversalConnectionPoolException(int errorNumber, Throwable cause) throws UniversalConnectionPoolException {
        UCPErrorHandler.throwUniversalConnectionPoolException(errorNumber, cause, null);
    }

    public static void throwUniversalConnectionPoolException(int errorNumber, String additionalMessage) throws UniversalConnectionPoolException {
        UCPErrorHandler.throwUniversalConnectionPoolException(errorNumber, null, additionalMessage);
    }

    public static void throwUniversalConnectionPoolException(UniversalConnectionPoolException cause) throws UniversalConnectionPoolException {
        int errorCode = cause.getErrorCode();
        if (errorCode == 0) {
            return;
        }
        String msg = cause.getMessage();
        int vendorCode = UCPErrorHandler.getVendorCode(errorCode);
        int exceptionId = UCPErrorHandler.findExceptionId(vendorCode);
        UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(exceptionId, msg, vendorCode);
        e.initCause(cause);
        throw e;
    }

    public static void throwUniversalConnectionPoolException(int errorNumber) throws UniversalConnectionPoolException {
        UCPErrorHandler.throwUniversalConnectionPoolException(errorNumber, (Throwable)null);
    }

    public static void throwUniversalConnectionPoolException(Throwable e) throws UniversalConnectionPoolException {
        UCPErrorHandler.throwUniversalConnectionPoolException(1, e);
    }

    public static void throwSQLException(int code, Throwable t) throws SQLException {
        throw UCPErrorHandler.newSQLException(code, t);
    }

    static ResourceBundle getBundle() {
        if (null == m_bundle) {
            try {
                m_bundle = ResourceBundle.getBundle(messageFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_bundle;
    }

    public static void clearBundle() {
        m_bundle = null;
    }

    public static String findMessage(String key, String details) {
        StringBuffer sb = new StringBuffer();
        ResourceBundle bundle = UCPErrorHandler.getBundle();
        if (null != bundle) {
            try {
                sb.append(bundle.getString(key));
                if (null != details) {
                    sb.append(": ").append(details);
                }
            }
            catch (Exception e) {
                sb.append("Message [").append(key).append("] not found in '").append(messageFile).append("'.");
            }
        } else {
            sb.append("Message file '").append(messageFile).append("' is missing.");
        }
        return sb.toString();
    }

    public static String findMessage(int errorNumber, Object obj) {
        return UCPErrorHandler.findMessage(UCPErrorHandler.getMsgKey(errorNumber), null != obj ? obj.toString() : null);
    }

    public static String findMessage(int errorNumber, Throwable cause) {
        return UCPErrorHandler.findMessage(UCPErrorHandler.getMsgKey(errorNumber), null != cause ? cause.toString() : null);
    }

    public static String findMessage(String key) {
        return UCPErrorHandler.findMessage(key, null);
    }

    public static String findSQLMessage(int errorNumber, Object obj) {
        return UCPErrorHandler.findMessage(UCPErrorHandler.getSQLMsgKey(errorNumber), null != obj ? obj.toString() : null);
    }

    public static int findExceptionId(int vendorCode) {
        if (vendorCode >= 50) {
            return 1;
        }
        for (int i = 0; i < mappings.length; ++i) {
            if (mappings[i][0] != vendorCode) continue;
            return mappings[i][1];
        }
        return 1;
    }

    public static UniversalConnectionPoolException newUniversalConnectionPoolException(int errorNumber, Object obj) {
        if (errorNumber == 0) {
            throw new IllegalArgumentException("wrong errorNumber");
        }
        String msg = UCPErrorHandler.findMessage(errorNumber, obj);
        int vendorCode = UCPErrorHandler.getVendorCode(errorNumber);
        int exceptionId = UCPErrorHandler.findExceptionId(vendorCode);
        return UCPErrorHandler.newUniversalConnectionPoolException(exceptionId, msg, vendorCode);
    }

    public static UniversalConnectionPoolException newUniversalConnectionPoolException(int errorNumber, Throwable cause) {
        if (errorNumber == 0) {
            throw new IllegalArgumentException("wrong errorNumber");
        }
        String msg = UCPErrorHandler.findMessage(errorNumber, null);
        int vendorCode = UCPErrorHandler.getVendorCode(errorNumber);
        int exceptionId = UCPErrorHandler.findExceptionId(vendorCode);
        UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(exceptionId, msg, vendorCode);
        ucpe.initCause(cause);
        return ucpe;
    }

    public static UniversalConnectionPoolException newUniversalConnectionPoolException(int errorNumber) {
        return UCPErrorHandler.newUniversalConnectionPoolException(errorNumber, null);
    }

    public static UniversalConnectionPoolException newUniversalConnectionPoolException(int exceptionId, String reason, int vendorCode) {
        switch (exceptionId) {
            case 1: {
                return new UniversalConnectionPoolException(reason, vendorCode);
            }
            case 2: {
                return new NoAvailableConnectionsException(reason, vendorCode);
            }
            case 3: {
                return new UniversalConnectionPoolException(reason, vendorCode);
            }
            case 4: {
                return new UniversalConnectionPoolException(reason, vendorCode);
            }
            case 5: {
                return new UniversalConnectionPoolException(reason, vendorCode);
            }
            case 6: {
                return new UniversalConnectionPoolException(reason, vendorCode);
            }
        }
        return new UniversalConnectionPoolException(reason, vendorCode);
    }

    public static int getVendorCode(int errorNumber) {
        if (errorNumber >= 500) {
            return 45407;
        }
        return 45000 + errorNumber;
    }

    private static String getMsgKey(int errorNumber) {
        int vendor_code = UCPErrorHandler.getVendorCode(errorNumber);
        String ret_key = "UCP-" + Integer.toString(vendor_code);
        return ret_key;
    }

    private static String getSQLMsgKey(int errorNumber) {
        String ret_key = "SQL-" + Integer.toString(errorNumber);
        return ret_key;
    }

    public static SQLException newSQLException(int errorNumber) {
        String msg = UCPErrorHandler.findSQLMessage(errorNumber, null);
        return UCPErrorHandler.newSQLException(errorNumber, msg);
    }

    public static SQLException newSQLException(int errorNumber, Object obj) {
        String msg = UCPErrorHandler.findSQLMessage(errorNumber, obj);
        return new SQLException(msg, null, errorNumber);
    }

    public static SQLException newSQLException(int errorNumber, Throwable e) {
        String msg = UCPErrorHandler.findSQLMessage(errorNumber, e);
        SQLException sqle = new SQLException(msg, null, errorNumber);
        sqle.initCause(e);
        return sqle;
    }

    static {
        try {
            $$$methodRef$$$25 = UCPErrorHandler.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = UCPErrorHandler.class.getDeclaredMethod("newSQLException", Integer.TYPE, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = UCPErrorHandler.class.getDeclaredMethod("newSQLException", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = UCPErrorHandler.class.getDeclaredMethod("newSQLException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = UCPErrorHandler.class.getDeclaredMethod("getSQLMsgKey", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = UCPErrorHandler.class.getDeclaredMethod("getMsgKey", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = UCPErrorHandler.class.getDeclaredMethod("getVendorCode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = UCPErrorHandler.class.getDeclaredMethod("newUniversalConnectionPoolException", Integer.TYPE, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = UCPErrorHandler.class.getDeclaredMethod("newUniversalConnectionPoolException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = UCPErrorHandler.class.getDeclaredMethod("newUniversalConnectionPoolException", Integer.TYPE, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = UCPErrorHandler.class.getDeclaredMethod("newUniversalConnectionPoolException", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = UCPErrorHandler.class.getDeclaredMethod("findExceptionId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = UCPErrorHandler.class.getDeclaredMethod("findSQLMessage", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = UCPErrorHandler.class.getDeclaredMethod("findMessage", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = UCPErrorHandler.class.getDeclaredMethod("findMessage", Integer.TYPE, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = UCPErrorHandler.class.getDeclaredMethod("findMessage", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = UCPErrorHandler.class.getDeclaredMethod("findMessage", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = UCPErrorHandler.class.getDeclaredMethod("clearBundle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = UCPErrorHandler.class.getDeclaredMethod("getBundle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UCPErrorHandler.class.getDeclaredMethod("throwSQLException", Integer.TYPE, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", UniversalConnectionPoolException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", Integer.TYPE, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UCPErrorHandler.class.getDeclaredMethod("throwUniversalConnectionPoolException", Integer.TYPE, Throwable.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        mappings = new int[][]{{45001, 1}, {45002, 2}, {45003, 3}, {45004, 4}, {45005, 5}, {45006, 6}};
    }
}

