/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.incident.DiagnosticRules;
import oracle.dfw.impl.incident.DumpAction;
import oracle.dfw.impl.incident.RuleActions;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.InvalidRulesException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Rule {
    private ArrayList<Condition> m_conditions;
    private RuleActions m_actions;
    private String m_ruleName;

    Rule(Element ruleElement) throws InvalidRulesException {
        NodeList actionsList;
        this.m_ruleName = ruleElement.getAttribute("name");
        NodeList ruleConditions = ruleElement.getElementsByTagName("ruleCondition");
        if (ruleConditions != null && ruleConditions.getLength() > 0) {
            NodeList conditionList = ((Element)ruleConditions.item(0)).getElementsByTagName("condition");
            int len = 0;
            if (conditionList != null && (len = conditionList.getLength()) > 0) {
                this.m_conditions = new ArrayList();
                for (int i = 0; i < len; ++i) {
                    this.m_conditions.add(new Condition((Element)conditionList.item(i), this.m_ruleName));
                }
            }
        }
        if ((actionsList = ruleElement.getElementsByTagName("ruleActions")) != null && actionsList.getLength() > 0) {
            Element defaultAction = (Element)actionsList.item(0);
            this.m_actions = new RuleActions();
            DiagnosticRules.updateRuleActions(defaultAction, this.m_actions);
        }
    }

    void evaluate(IncidentFacts facts, RuleActions actions) {
        boolean addActions = false;
        if (this.m_conditions != null) {
            Condition condition;
            Iterator<Condition> i$ = this.m_conditions.iterator();
            while (i$.hasNext() && (addActions = (condition = i$.next()).evaluate(facts))) {
            }
        }
        if (addActions) {
            actions.joinRuleActions(this.m_actions);
        }
    }

    public void describe(StringBuilder sb, String indent) {
        sb.append("Rule ");
        sb.append(this.m_ruleName);
        sb.append(":\n");
        if (this.m_conditions != null) {
            for (Condition condition : this.m_conditions) {
                sb.append(indent);
                sb.append("  -");
                condition.describe(sb);
                sb.append("\n");
            }
        }
        if (this.m_actions != null) {
            for (DumpAction action : this.m_actions.getDumpActions()) {
                sb.append(indent);
                sb.append("  - Dump Action: ");
                sb.append(action.toString());
                sb.append("\n");
            }
        }
    }

    private static enum Operator {
        LT,
        GT,
        LE,
        GE,
        EQ,
        EQNoCase,
        NE,
        Contains,
        StartsWith,
        EndsWith;

        private static final long serialVersionUID = 0L;
    }

    private static class Condition {
        private Comparable m_value;
        private String m_datatype;
        private Operator m_operator;
        private IncidentFacts.IncidentFactKeyword m_factKeyword;
        private String m_contextKey;
        private static final String IntegerType = "Integer";

        Condition(Element conditionElement, String ruleName) throws InvalidRulesException {
            String conditionValueType = conditionElement.getAttribute("valueType");
            if (conditionValueType.equalsIgnoreCase("Fact")) {
                this.m_factKeyword = IncidentFacts.IncidentFactKeyword.getIncidentFactKeyword(conditionElement.getAttribute("name"));
                if (this.m_factKeyword == null) {
                    InvalidRulesException e = new InvalidRulesException("DFW-40117");
                    e.addToken(conditionElement.getAttribute("name"));
                    e.addToken(ruleName);
                    throw e;
                }
            } else {
                this.m_contextKey = conditionElement.getAttribute("name");
            }
            this.m_value = conditionElement.getAttribute("value");
            this.m_datatype = conditionElement.getAttribute("datatype");
            this.m_operator = Operator.valueOf(conditionElement.getAttribute("operator"));
            if (this.m_datatype.equals(IntegerType)) {
                this.m_value = new Integer(conditionElement.getAttribute("value"));
            }
        }

        boolean evaluate(IncidentFacts facts) {
            String value;
            boolean isValid = false;
            ArrayList<String> factValues = new ArrayList<String>();
            if (this.m_factKeyword != null) {
                switch (this.m_factKeyword) {
                    case MESSAGE_ID: {
                        ErrorMessage msg = facts.getErrorMessage();
                        if (msg == null) break;
                        factValues.add(msg.getErrorFacilityAndNumber());
                        factValues.add(msg.getOriginalErrorMessageId());
                        break;
                    }
                    case ECID: {
                        if (facts.getExecutionContextId() == null) break;
                        factValues.add(facts.getExecutionContextId());
                        break;
                    }
                    case COMPONENT_ID: {
                        if (facts.getComponentId() == null) break;
                        factValues.add(facts.getComponentId());
                        break;
                    }
                    case MODULE_ID: {
                        if (facts.getModuleId() == null) break;
                        factValues.add(facts.getModuleId());
                        break;
                    }
                    case PROBLEM_IMPACT: {
                        if (!facts.getIncidentFactPropertyNames().contains((Object)IncidentFacts.IncidentFactProperty.PROBLEM_IMPACT_PROP)) break;
                        factValues.addAll(facts.getIncidentFactPropertyValues(IncidentFacts.IncidentFactProperty.PROBLEM_IMPACT_PROP));
                        break;
                    }
                }
            } else if (this.m_contextKey != null && (value = facts.getContextValue(this.m_contextKey)) != null) {
                factValues.add(value);
            }
            if (factValues.size() > 0) {
                for (String factValue : factValues) {
                    Object factComparable = factValue;
                    if (this.m_datatype.equals(IntegerType)) {
                        try {
                            factComparable = new Integer(factValue);
                        }
                        catch (Throwable t) {
                            LoggerFactory.getFrameworkLogger().log(Level.FINE, "Failed to convert String to int value during diagnostic condition evaluation. Rule value: " + this.m_value + " Fact value: " + factValue, t);
                        }
                    }
                    if (!(isValid = this.evaluateValue(this.m_value, (Comparable)factComparable))) continue;
                    break;
                }
            }
            return isValid;
        }

        private boolean evaluateValue(Comparable ruleValue, Comparable factValue) {
            boolean isValid = false;
            switch (this.m_operator) {
                case LT: {
                    isValid = ruleValue.compareTo(factValue) < 0;
                    break;
                }
                case GT: {
                    isValid = ruleValue.compareTo(factValue) > 0;
                    break;
                }
                case LE: {
                    isValid = ruleValue.compareTo(factValue) <= 0;
                    break;
                }
                case GE: {
                    isValid = ruleValue.compareTo(factValue) >= 0;
                    break;
                }
                case EQ: {
                    isValid = ruleValue.equals(factValue);
                    break;
                }
                case EQNoCase: {
                    isValid = ruleValue.toString().compareToIgnoreCase(factValue.toString()) == 0;
                    break;
                }
                case NE: {
                    isValid = !ruleValue.equals(factValue);
                    break;
                }
                case Contains: {
                    isValid = factValue.toString().indexOf(ruleValue.toString()) != -1;
                    break;
                }
                case StartsWith: {
                    isValid = factValue.toString().startsWith(ruleValue.toString());
                    break;
                }
                case EndsWith: {
                    isValid = factValue.toString().endsWith(ruleValue.toString());
                    break;
                }
            }
            return isValid;
        }

        public void describe(StringBuilder sb) {
            sb.append("Condition:");
            if (this.m_factKeyword != null) {
                sb.append(" ");
                sb.append("valueType: FACT");
                sb.append(" factKeyword: ");
                sb.append(this.m_factKeyword.toString());
            } else {
                sb.append(" ");
                sb.append("valueType: CONTEXT");
                sb.append(" contextKey: ");
                sb.append(this.m_contextKey);
            }
            sb.append(" operator: ");
            sb.append(this.m_operator.toString());
            sb.append(" value: ");
            sb.append(this.m_value);
            sb.append(" datatype: ");
            sb.append(this.m_datatype);
        }
    }
}

