/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.datasource.impl;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.datasource.OraclePooledConnection;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.datasource.impl.OraclePooledConnectionBuilderImpl;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public class OracleConnectionPoolDataSource
extends OracleDataSource
implements oracle.jdbc.datasource.OracleConnectionPoolDataSource,
oracle.jdbc.replay.internal.OracleConnectionPoolDataSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public OracleConnectionPoolDataSource() throws SQLException {
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String string = null;
        OpaqueString opaqueString = OpaqueString.NULL;
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            string = this.user;
            opaqueString = this.password != null ? this.password : OpaqueString.NULL;
        }
        return this.getPooledConnection(string, opaqueString);
    }

    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        return this.getPooledConnection(string, OpaqueString.newOpaqueString(string2));
    }

    private PooledConnection getPooledConnection(String string, OpaqueString opaqueString) throws SQLException {
        Connection connection = this.getPhysicalConnection(string, opaqueString);
        oracle.jdbc.pool.OraclePooledConnection oraclePooledConnection = new oracle.jdbc.pool.OraclePooledConnection(connection);
        return oraclePooledConnection;
    }

    PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        Connection connection = this.getPhysicalConnection(properties, null);
        oracle.jdbc.pool.OraclePooledConnection oraclePooledConnection = new oracle.jdbc.pool.OraclePooledConnection(connection);
        return oraclePooledConnection;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password);
    }

    protected Connection getPhysicalConnection(String string, String string2, @Blind String string3) throws SQLException {
        this.url = string;
        return super.getConnection(string2, OpaqueString.newOpaqueString(string3));
    }

    protected Connection getPhysicalConnection(String string, @Blind String string2) throws SQLException {
        return super.getConnection(string, OpaqueString.newOpaqueString(string2));
    }

    protected Connection getPhysicalConnection(String string, String string2, OpaqueString opaqueString) throws SQLException {
        this.url = string;
        return super.getConnection(string2, opaqueString);
    }

    protected Connection getPhysicalConnection(String string, OpaqueString opaqueString) throws SQLException {
        return super.getConnection(string, opaqueString);
    }

    protected oracle.jdbc.pool.OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Connection connection = super.getConnection(oracleConnectionBuilderImpl);
        oracle.jdbc.pool.OraclePooledConnection oraclePooledConnection = new oracle.jdbc.pool.OraclePooledConnection(connection);
        return oraclePooledConnection;
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        return new OraclePooledConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public OraclePooledConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = (OracleConnectionBuilderImpl)OracleConnectionPoolDataSource.this.createConnectionBuilder().copy(this);
                if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null && oracleConnectionBuilderImpl.getPassword() != OpaqueString.NULL)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return OracleConnectionPoolDataSource.this.getPooledConnection(oracleConnectionBuilderImpl);
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(OracleConnectionPoolDataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    public Connection getConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    static {
        try {
            $$$methodRef$$$15 = OracleConnectionPoolDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = OracleConnectionPoolDataSource.class.getDeclaredMethod("createPooledConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = OracleConnectionPoolDataSource.class.getDeclaredMethod("createPooledConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

