/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.NameCheck;
import oracle.xml.parser.v2.NonValidatingParser;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ValidatingParser
extends NonValidatingParser
implements XMLConstants {
    transient NameCheck nameCheck;
    transient Hashtable ids;

    public ValidatingParser() {
        if (this.reader != null) {
            this.reader.valMode = 1;
        }
    }

    public ValidatingParser(NonValidatingParser nonValidatingParser) {
        super(nonValidatingParser);
    }

    @Override
    void init() throws SAXException, IOException {
        super.init();
        this.nameCheck = null;
        this.ids = null;
    }

    @Override
    void reset() {
        super.reset();
        this.nameCheck = null;
        this.ids = null;
    }

    @Override
    void parseRootElement() throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(60)) {
            String string = this.parseElement();
            if (this.dtd.getRootTag() != null && !string.equals(this.dtd.getRootTag())) {
                this.err.error0(130, 1);
            }
        } else {
            this.err.error0(108, 0);
            this.err.flushErrors1();
        }
    }

    @Override
    XMLEntity parseEntityDecl() throws XMLParseException, SAXException, IOException {
        XMLNotation xMLNotation;
        XMLEntity xMLEntity = super.parseEntityDecl();
        if (xMLEntity.getNotationName() != null && (xMLNotation = (XMLNotation)this.dtd.findNotation(xMLEntity.getNotationName())) == null) {
            this.addNameCheck(xMLEntity.getNotationName(), this.reader, 12);
        }
        return xMLEntity;
    }

    @Override
    ElementDecl parseAttlistDecl() throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = super.parseAttlistDecl();
        if (elementDecl.isNodeFlag(65536)) {
            this.addNameCheck(elementDecl.getNodeName(), this.reader, 1);
        }
        return elementDecl;
    }

    @Override
    AttrDecl parseAttrDecl(ElementDecl elementDecl) throws XMLParseException, SAXException, IOException {
        AttrDecl attrDecl = super.parseAttrDecl(elementDecl);
        if (attrDecl.atttype == 1) {
            if (elementDecl.isNodeFlag(131072)) {
                this.err.error0(132, 1);
            } else {
                elementDecl.setNodeFlag(131072);
            }
        }
        if (attrDecl.atttype == 8) {
            Vector vector = attrDecl.getEnumerationValues();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.elementAt(i);
                XMLNotation xMLNotation = (XMLNotation)this.dtd.findNotation(string);
                if (xMLNotation != null) continue;
                this.addNameCheck(string, this.reader, 12);
            }
        }
        if ((attrDecl.attpres == 3 || attrDecl.attpres == 0) && attrDecl.atttype == 1) {
            this.err.error0(134, 1);
        }
        return attrDecl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void parseText() throws XMLParseException, SAXException, IOException {
        if (this.currentState.ed != null) {
            char[] cArray = this.reader.scanWhiteSpace(this.charLimits);
            if (this.charLimits[1] != 0) {
                if (this.currentState.ed.getContentType() == 4 && this.reader.isStandalone() && this.currentState.ed.isNodeFlag(128)) {
                    this.err.error1(145, 1, this.currentState.qname);
                }
                if (this.isMarkup() && this.preserveWS != 0 && this.currentState.ed.getContentType() == 4) {
                    this.cntHandler.ignorableWhitespace(cArray, this.charLimits[0], this.charLimits[1]);
                } else {
                    this.cntHandler.characters(cArray, this.charLimits[0], this.charLimits[1]);
                }
            }
            boolean[] blArray = new boolean[]{false};
            do {
                cArray = this.reader.scanChars(this.charLimits, this.charChunks, blArray);
                if (this.charLimits[1] == 0) return;
                this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
            } while (this.charChunks && !blArray[0]);
            return;
        } else {
            super.parseText();
        }
    }

    @Override
    AttrDecl parseAttr() throws XMLParseException, SAXException, IOException {
        AttrDecl attrDecl = super.parseAttr();
        if (attrDecl == null) {
            int n = this.doctypePresent ? 1 : 2;
            this.err.error1(137, n, this.attrTag.getTag());
        }
        return attrDecl;
    }

    @Override
    void checkDefaultAttributes() throws XMLParseException, SAXException {
        if (this.currentState.ed != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(20);
            NamedNodeMap namedNodeMap = this.currentState.ed.getAttrDecls();
            if (namedNodeMap != null) {
                AttrDecl attrDecl;
                int n;
                for (n = 0; n < this.attrList.count; ++n) {
                    hashtable.put(this.attrList.qname[n], this.attrList.qname[n]);
                    attrDecl = (AttrDecl)namedNodeMap.getNamedItem(this.attrList.qname[n]);
                    if (attrDecl == null) continue;
                    this.attrList.attrType[n] = attrDecl.atttype;
                }
                n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    String string;
                    attrDecl = (AttrDecl)namedNodeMap.item(i);
                    String string2 = attrDecl.getNodeName();
                    if (hashtable.get(string2) != null) continue;
                    if (attrDecl.attpres == 1) {
                        this.err.error1(138, 1, string2);
                    }
                    if ((string = attrDecl.getDefaultValue()) == null) continue;
                    if (this.reader.isStandalone() && attrDecl.isNodeFlag(128)) {
                        this.err.error1(137, 1, string2);
                    }
                    if (attrDecl.atttype == 2 && this.findID(string) == null) {
                        this.addNameCheck(string, this.reader, 2);
                    }
                    if (attrDecl.atttype == 3) {
                        int n2 = 0;
                        int n3 = 0;
                        do {
                            String string3;
                            if ((n3 = string.indexOf(32, n2)) == -1) {
                                string3 = string.substring(n2, string.length());
                            } else {
                                string3 = string.substring(n2, n3);
                                n2 = n3 + 1;
                            }
                            if (this.findID(string3) != null) continue;
                            this.addNameCheck(string3, this.reader, 2);
                        } while (n3 != -1);
                    }
                    String string4 = XMLUtil.getLocalName(string2);
                    String string5 = XMLUtil.getPrefix(string2);
                    if (string4 == "xmlns" || string5 == "xmlns") {
                        this.addNamespaceDef(string5, string4, string);
                    }
                    this.attrList.addAttr(string5, string4, string2, string, false, attrDecl.atttype);
                }
            }
        }
    }

    @Override
    String normalizeAttrValue(String string, AttrDecl attrDecl, boolean bl) throws XMLParseException, SAXException, IOException {
        String string2 = string;
        if (attrDecl != null && attrDecl.atttype != 0) {
            XMLCharReader xMLCharReader = new XMLCharReader(string, this.reader.getSystemId(), this.reader.getPublicId());
            this.reader.syncCurrentPos();
            xMLCharReader.setPrevReader(this.reader.input);
            XMLReader xMLReader = new XMLReader(this.dtd, this.err, this.entResolver, true);
            xMLReader.attrReader = true;
            xMLReader.pushXMLReader(xMLCharReader);
            xMLReader.skipWhiteSpace();
            string2 = new String();
            block0 : switch (attrDecl.atttype) {
                case 1: {
                    string2 = xMLReader.scanQName();
                    if (string2 == null || string2.length() == 0) {
                        this.err.error2(24523, 0, string2, "ID");
                    }
                    if (this.findID(string2) != null) {
                        this.err.error1(139, 1, string2);
                    }
                    this.addID(string2);
                    break;
                }
                case 2: {
                    string2 = xMLReader.scanQName();
                    if (bl || this.findID(string2) != null) break;
                    this.addNameCheck(string2, this.reader, 2);
                    break;
                }
                case 3: {
                    while (true) {
                        String string3 = xMLReader.scanQName();
                        string2 = string2.concat(string3);
                        if (!bl && this.findID(string3) == null) {
                            this.addNameCheck(string3, this.reader, 2);
                        }
                        if (!xMLReader.skipWhiteSpace() || xMLReader.isEOF()) break block0;
                        string2 = string2.concat(" ");
                    }
                }
                case 4: {
                    string2 = xMLReader.scanQName();
                    XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string2, false);
                    if (xMLEntity == null) {
                        if (bl) {
                            this.addNameCheck(string2, this.reader, 6);
                            break;
                        }
                        this.err.error1(105, 1, string2);
                        break;
                    }
                    if (xMLEntity.getNotationName() != null) break;
                    this.err.error1(105, 1, string2);
                    break;
                }
                case 5: {
                    while (true) {
                        String string4 = xMLReader.scanQName();
                        string2 = string2.concat(string4);
                        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string4, false);
                        if (xMLEntity == null) {
                            if (bl) {
                                this.addNameCheck(string4, this.reader, 6);
                            } else {
                                this.err.error1(105, 1, string4);
                            }
                        } else if (xMLEntity.getNotationName() == null) {
                            this.err.error1(105, 1, string4);
                        }
                        if (!xMLReader.skipWhiteSpace() || xMLReader.isEOF()) break block0;
                        string2 = string2.concat(" ");
                    }
                }
                case 6: {
                    string2 = xMLReader.scanNmToken();
                    break;
                }
                case 7: {
                    while (true) {
                        String string5 = xMLReader.scanNmToken();
                        string2 = string2.concat(string5);
                        if (!xMLReader.skipWhiteSpace() || xMLReader.isEOF()) break block0;
                        string2 = string2.concat(" ");
                    }
                }
                case 8: 
                case 9: {
                    string2 = attrDecl.atttype == 8 ? xMLReader.scanQName() : xMLReader.scanNmToken();
                    Vector vector = attrDecl.getEnumerationValues();
                    boolean bl2 = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        if (!vector.elementAt(i).equals(string2)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) break;
                    this.err.error1(141, 1, string2);
                    break;
                }
                default: {
                    this.err.error0(142, 0);
                    this.err.flushErrors1();
                }
            }
            xMLReader.skipWhiteSpace();
            if (!xMLReader.isEOF()) {
                this.err.error0(143, 1);
            }
            if (this.reader.isStandalone() && attrDecl.isNodeFlag(128) && !string.equals(string2)) {
                this.err.error1(137, 1, attrDecl.getNodeName());
            }
        }
        if (!bl && attrDecl != null && attrDecl.attpres == 3 && !string2.equals(attrDecl.getDefaultValue())) {
            this.err.error1(144, 1, string2);
        }
        this.err.setLocator(this.reader);
        return string2;
    }

    @Override
    void reportCharacters(char[] cArray, int n, int n2) throws XMLParseException, SAXException, IOException {
        if (this.currentState.ed != null && !this.currentState.ed.checkContent(this.currentState, "PCDATA")) {
            int n3 = this.doctypePresent ? 1 : 2;
            Vector vector = this.currentState.ed.expectedElements(this.currentState.state);
            if (vector.isEmpty()) {
                this.err.error1(145, n3, this.currentState.qname);
            } else {
                this.err.error2(146, n3, this.currentState.qname, vector.toString());
            }
        }
        super.reportCharacters(cArray, n, n2);
    }

    @Override
    void pushState(String string, String string2, String string3) throws XMLParseException, SAXException, IOException {
        if (this.stateIndex != -1 && this.currentState.ed != null && !this.currentState.ed.checkContent(this.currentState, string3)) {
            int n = this.doctypePresent ? 1 : 2;
            Vector vector = this.currentState.ed.expectedElements(this.currentState.state);
            if (vector.isEmpty()) {
                this.err.error2(147, n, string3, this.currentState.ed.getNodeName());
            } else {
                this.err.error3(148, n, string3, this.currentState.ed.getNodeName(), vector.toString());
            }
        }
        super.pushState(string, string2, string3);
        ElementDecl elementDecl = this.currentState.ed;
        if (elementDecl == null || !elementDecl.isNodeFlag(65536)) {
            int n = this.doctypePresent ? 1 : (this.reader.valMode != 1 ? 1 : 2);
            this.err.error1(149, n, string3);
        }
    }

    @Override
    ParserState popState() throws XMLParseException, SAXException, IOException {
        if (this.currentState.ed != null && !this.currentState.ed.checkAcceptState(this.currentState)) {
            int n = this.doctypePresent ? 1 : 2;
            Vector vector = this.currentState.ed.expectedElements(this.currentState.state);
            this.err.error2(150, n, this.currentState.qname, vector.toString());
        }
        return super.popState();
    }

    final void addNameCheck(String string, XMLReader xMLReader, int n) {
        this.nameCheck = new NameCheck(this.nameCheck, string, xMLReader, n);
    }

    @Override
    void checkNames(XMLError xMLError) throws XMLParseException {
        Locator locator = xMLError.getLocator();
        NameCheck nameCheck = this.nameCheck;
        while (nameCheck != null) {
            xMLError.setLocator(nameCheck);
            switch (nameCheck.type) {
                case 2: {
                    if (this.findID(nameCheck.name) != null) break;
                    xMLError.error1(140, 1, nameCheck.name);
                    break;
                }
                case 6: {
                    XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(nameCheck.name, false);
                    if (xMLEntity != null && xMLEntity.getNotationName() != null) break;
                    xMLError.error1(105, 1, nameCheck.name);
                    break;
                }
                case 12: {
                    if (this.dtd.findNotation(nameCheck.name) != null) break;
                    xMLError.error1(106, 1, nameCheck.name);
                    break;
                }
                case 1: {
                    if (this.dtd.findElementDecl(nameCheck.name) != null) break;
                    xMLError.error1(107, 1, nameCheck.name);
                    break;
                }
            }
            nameCheck = nameCheck.next;
        }
        xMLError.setLocator(locator);
    }

    private void addID(String string) {
        if (this.ids == null) {
            this.ids = new Hashtable(20);
        }
        this.ids.put(string, string);
    }

    private Object findID(String string) {
        return this.ids == null ? null : this.ids.get(string);
    }
}

