/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.elf.ELFCavaRelocation;
import com.oracle.objectfile.elf.ELFDummyRelocation;
import com.oracle.objectfile.elf.ELFRelocationSection;
import com.oracle.objectfile.elf.ELFX86_64Relocation;

public enum ELFMachine {
    NONE{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFDummyRelocation.class;
        }
    }
    ,
    X86_64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFX86_64Relocation.class;
        }
    }
    ,
    CAVA{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFCavaRelocation.class;
        }
    };


    abstract Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes();

    public static ELFRelocationSection.ELFRelocationMethod getRelocation(ELFMachine m, ObjectFile.RelocationKind k, int sizeInBytes) {
        switch (m) {
            case X86_64: {
                switch (k) {
                    case DIRECT: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_32;
                            }
                            case 2: {
                                return ELFX86_64Relocation.R_16;
                            }
                            case 1: {
                                return ELFX86_64Relocation.R_8;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                    case PC_RELATIVE: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_PC64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_PC32;
                            }
                            case 2: {
                                return ELFX86_64Relocation.R_PC16;
                            }
                            case 1: {
                                return ELFX86_64Relocation.R_PC8;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                    case PROGRAM_BASE: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_RELATIVE64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_RELATIVE;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                }
                throw new IllegalArgumentException("cannot map unknown relocation kind to an ELF x86-64 relocation type");
            }
            case CAVA: {
                switch (k) {
                    case DIRECT_LO: {
                        switch (sizeInBytes) {
                            case 2: {
                                return ELFCavaRelocation.R_CAVA_OFFSET;
                            }
                        }
                        throw new RuntimeException(Integer.toString(sizeInBytes));
                    }
                    case DIRECT_HI: {
                        switch (sizeInBytes) {
                            case 2: {
                                return ELFCavaRelocation.R_CAVA_HIGH;
                            }
                        }
                        throw new RuntimeException(Integer.toString(sizeInBytes));
                    }
                }
                throw new RuntimeException(k.toString());
            }
        }
        return ELFDummyRelocation.R_NONE;
    }

    public static ELFMachine from(int m) {
        switch (m) {
            case 0: {
                return NONE;
            }
            case 62: {
                return X86_64;
            }
        }
        throw new IllegalStateException("unknown ELF machine type");
    }

    public short toShort() {
        if (this == NONE) {
            return 0;
        }
        if (this == X86_64) {
            return 62;
        }
        if (this == CAVA) {
            return -13570;
        }
        throw new IllegalStateException("should not reach here");
    }

    public static ELFMachine getSystemNativeValue() {
        return X86_64;
    }
}

