/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffObjectFile;
import com.oracle.objectfile.pecoff.PECoffSymtabStruct;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class PECoffSymtab
extends ObjectFile.Element
implements SymbolTable {
    private SortedSet<Entry> entries;
    private Map<String, Entry> entriesByName;
    private PECoffSymtabStruct symtabStruct;

    @Override
    public ElementImpl getImpl() {
        return this;
    }

    private static int compareEntries(Entry a, Entry b) {
        int cmp = -Boolean.compare(a.isNull(), b.isNull());
        if (cmp == 0) {
            cmp = Integer.compare(a.symClass, b.symClass);
        }
        if (cmp == 0) {
            cmp = Integer.compare(a.symType, b.symType);
        }
        if (cmp == 0) {
            cmp = Boolean.compare(a.isDefined(), b.isDefined());
        }
        if (cmp == 0 && a.isDefined()) {
            cmp = Math.toIntExact(a.getDefinedOffset() - b.getDefinedOffset());
        }
        if (cmp == 0) {
            return a.getName().compareTo(b.getName());
        }
        return cmp;
    }

    public PECoffSymtab(PECoffObjectFile owner, String name) {
        PECoffObjectFile pECoffObjectFile = owner;
        pECoffObjectFile.getClass();
        super(name);
        this.entries = new TreeSet<Entry>(PECoffSymtab::compareEntries);
        this.entriesByName = new HashMap<String, Entry>();
        this.symtabStruct = null;
    }

    private PECoffSymtabStruct getNativeSymtab() {
        if (this.symtabStruct != null) {
            return this.symtabStruct;
        }
        this.symtabStruct = new PECoffSymtabStruct();
        for (Entry e : this.entries) {
            PECoffObjectFile.PECoffSection sect = e.getReferencedSection();
            int sectID = sect == null ? -1 : sect.getSectionID();
            long offset = e.isDefined() ? e.getDefinedOffset() : 0L;
            this.symtabStruct.addSymbolEntry(e.getName(), (byte)e.getSymType(), (byte)e.getSymClass(), (byte)sectID, offset);
        }
        return this.symtabStruct;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        PECoffSymtabStruct sts = this.getNativeSymtab();
        ByteBuffer outBuffer = ByteBuffer.allocate(this.getWrittenSize()).order(this.getOwner().getByteOrder());
        OutputAssembler out = AssemblyBuffer.createOutputAssembler(outBuffer);
        out.writeBlob(sts.getSymtabArray());
        out.writeBlob(sts.getStrtabArray());
        return out.getBlob();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.getWrittenSize();
    }

    private int getWrittenSize() {
        PECoffSymtabStruct sts = this.getNativeSymtab();
        return sts.getSymtabCount() * PECoff.IMAGE_SYMBOL.totalsize + sts.getStrtabSize();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        ArrayList<BuildDependency> ourDeps = new ArrayList<BuildDependency>(ObjectFile.defaultDependencies(decisions, this));
        return ourDeps;
    }

    @Override
    public boolean isLoadable() {
        return true;
    }

    @Override
    public ObjectFile.Symbol newDefinedEntry(String name, ObjectFile.Section referencedSection, long referencedOffset, long size, boolean isGlobal, boolean isCode) {
        int symClass = isGlobal ? 2 : 3;
        int symType = isCode ? 32 : 0;
        return this.addEntry(new Entry(name, referencedOffset, size, symClass, symType, (PECoffObjectFile.PECoffSection)referencedSection));
    }

    @Override
    public ObjectFile.Symbol newUndefinedEntry(String name, boolean isCode) {
        int symClass = 2;
        int symType = isCode ? 32 : 0;
        return this.addEntry(new Entry(name, 0L, 0L, symClass, symType, PseudoSection.UNDEF));
    }

    private Entry addEntry(Entry entry) {
        this.entries.add(entry);
        this.entriesByName.put(entry.getName(), entry);
        return entry;
    }

    public Entry getNullEntry() {
        return (Entry)this.entries.iterator().next();
    }

    public int indexOf(ObjectFile.Symbol sym) {
        int i = 0;
        for (Entry entry : this.entries) {
            if (entry.equals(sym)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator<ObjectFile.Symbol> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Entry getSymbol(String name) {
        return this.entriesByName.get(name);
    }

    public int getSymbolCount() {
        PECoffSymtabStruct sts = this.getNativeSymtab();
        int count = sts.getSymtabCount();
        int entcount = this.entries.size();
        if (entcount != count) {
            System.out.println("Counts don't match, entcount: " + entcount + " count: " + count);
        }
        return this.entries.size();
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this, copyingIn);
    }

    public static enum PseudoSection {
        UNDEF;

    }

    static final class Entry
    implements ObjectFile.Symbol {
        private final String name;
        private final long value;
        private final long size;
        private final int symClass;
        private final int symType;
        private final PECoffObjectFile.PECoffSection referencedSection;
        private final PseudoSection pseudoSection;

        @Override
        public boolean isDefined() {
            return this.pseudoSection == null || this.pseudoSection != PseudoSection.UNDEF;
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public boolean isCommon() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return this.symType == 32;
        }

        public boolean isNull() {
            return this.name.isEmpty() && this.value == 0L && this.size == 0L && this.symClass == 0 && this.symType == 0 && this.referencedSection == null && this.pseudoSection == null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getSymClass() {
            return this.symClass;
        }

        public int getSymType() {
            return this.symType;
        }

        @Override
        public long getDefinedOffset() {
            if (!this.isDefined()) {
                throw new IllegalStateException("queried offset of an undefined symbol");
            }
            return this.value;
        }

        @Override
        public ObjectFile.Section getDefinedSection() {
            return this.getReferencedSection();
        }

        @Override
        public long getDefinedAbsoluteValue() {
            return 0L;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        private Entry(String name, long value, long size, int symclass, int symtype, PECoffObjectFile.PECoffSection referencedSection, PseudoSection pseudoSection) {
            this.name = name;
            this.value = value;
            this.size = size;
            this.symClass = symclass;
            this.symType = symtype;
            this.referencedSection = referencedSection;
            this.pseudoSection = pseudoSection;
            assert (referencedSection == null != (pseudoSection == null) || this.isNull());
        }

        Entry(String name, long value, long size, int symclass, int symtype, PECoffObjectFile.PECoffSection referencedSection) {
            this(name, value, size, symclass, symtype, referencedSection, null);
        }

        Entry(String name, long value, long size, int symclass, int symtype, PseudoSection pseudoSection) {
            this(name, value, size, symclass, symtype, null, pseudoSection);
        }

        PECoffObjectFile.PECoffSection getReferencedSection() {
            return this.referencedSection;
        }
    }
}

