/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffByteBuffer;
import com.oracle.objectfile.pecoff.PECoffSymbolStruct;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

final class PECoffSymtabStruct {
    ArrayList<PECoffSymbolStruct> symbols = new ArrayList();
    private int symbolCount = 0;
    private final StringBuilder strTabContent = new StringBuilder();
    private int strTabNrOfBytes = 4;
    private final StringBuilder directives = new StringBuilder();

    PECoffSymtabStruct() {
        this.strTabContent.append('\u0000').append('\u0000').append('\u0000').append('\u0000');
        this.directives.append("   ");
    }

    PECoffSymbolStruct addSymbolEntry(String name, byte type, byte storageclass, byte secHdrIndex, long offset) {
        PECoffSymbolStruct sym;
        if (name.isEmpty()) {
            int index = this.strTabNrOfBytes++;
            this.strTabContent.append('\u0000');
            sym = new PECoffSymbolStruct(index, type, storageclass, secHdrIndex, offset);
            this.symbols.add(sym);
        } else {
            int nameSize = name.getBytes().length;
            int index = this.strTabNrOfBytes;
            this.strTabContent.append(name).append('\u0000');
            this.strTabNrOfBytes += nameSize + 1;
            sym = new PECoffSymbolStruct(index, type, storageclass, secHdrIndex, offset);
            this.symbols.add(sym);
            if (storageclass == 2) {
                this.addDirective(name, type);
            }
        }
        ++this.symbolCount;
        return sym;
    }

    private void addDirective(String name, byte type) {
        this.directives.append("/EXPORT:" + name);
        if (type != 32) {
            this.directives.append(",DATA");
        }
        this.directives.append(" ");
    }

    int getSymtabCount() {
        return this.symbolCount;
    }

    int getStrtabSize() {
        return this.strTabNrOfBytes;
    }

    byte[] getSymtabArray() {
        ByteBuffer symtabData = PECoffByteBuffer.allocate(this.symbolCount * PECoff.IMAGE_SYMBOL.totalsize);
        symtabData.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.symbolCount; ++i) {
            PECoffSymbolStruct sym = this.symbols.get(i);
            byte[] arr = sym.getArray();
            symtabData.put(arr);
        }
        return symtabData.array();
    }

    byte[] getStrtabArray() {
        byte[] strs = this.strTabContent.toString().getBytes();
        ByteBuffer buff = ByteBuffer.wrap(strs);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.putInt(0, this.strTabNrOfBytes);
        return strs;
    }

    byte[] getDirectiveArray() {
        return this.directives.toString().getBytes();
    }
}

