// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HeapPolicyOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class HeapPolicyOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlignedHeapChunkSize": {
            return OptionDescriptor.create(
                /*name*/ "AlignedHeapChunkSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of an aligned chunk.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "AlignedHeapChunkSize",
                /*option*/ HeapPolicyOptions.AlignedHeapChunkSize);
        }
        case "LargeArrayThreshold": {
            return OptionDescriptor.create(
                /*name*/ "LargeArrayThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "How many bytes is enough to allocate an unaligned chunk for an array?  0 implies (AlignedHeapChunkSize / 8).",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "LargeArrayThreshold",
                /*option*/ HeapPolicyOptions.LargeArrayThreshold);
        }
        case "MaximumHeapSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumHeapSizePercent",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum heap size as percent of physical memory",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "MaximumHeapSizePercent",
                /*option*/ HeapPolicyOptions.MaximumHeapSizePercent);
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "TraceHeapChunks",
                /*option*/ HeapPolicyOptions.TraceHeapChunks);
        }
        case "UserRequestedGCPolicy": {
            return OptionDescriptor.create(
                /*name*/ "UserRequestedGCPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Policy used when users request garbage collection.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "UserRequestedGCPolicy",
                /*option*/ HeapPolicyOptions.UserRequestedGCPolicy);
        }
        case "UserRequestedGCThreshold": {
            return OptionDescriptor.create(
                /*name*/ "UserRequestedGCThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Defines the upper bound for the number of remaining bytes in the young generation that cause a collection when `System.gc` is called.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "UserRequestedGCThreshold",
                /*option*/ HeapPolicyOptions.UserRequestedGCThreshold);
        }
        case "ZapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Zap memory chunks",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapChunks",
                /*option*/ HeapPolicyOptions.ZapChunks);
        }
        case "ZapConsumedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapConsumedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Zap consumed memory chunks",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapConsumedHeapChunks",
                /*option*/ HeapPolicyOptions.ZapConsumedHeapChunks);
        }
        case "ZapProducedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapProducedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Zap produced memory chunks",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapProducedHeapChunks",
                /*option*/ HeapPolicyOptions.ZapProducedHeapChunks);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 9;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlignedHeapChunkSize");
                    case 1: return get("LargeArrayThreshold");
                    case 2: return get("MaximumHeapSizePercent");
                    case 3: return get("TraceHeapChunks");
                    case 4: return get("UserRequestedGCPolicy");
                    case 5: return get("UserRequestedGCThreshold");
                    case 6: return get("ZapChunks");
                    case 7: return get("ZapConsumedHeapChunks");
                    case 8: return get("ZapProducedHeapChunks");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
