/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.FeebleReference;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@ReserveDeoptScratchSpace
public final class DeoptimizedFrame {
    private final long sourceTotalFrameSize;
    private final FeebleReference<SubstrateInstalledCode> sourceInstalledCode;
    private final VirtualFrame topFrame;
    private final Deoptimizer.TargetContent targetContent;
    private final PinnedObject pin;
    private final CodePointer sourcePC;
    private final char[] completedMessage;

    public static int getScratchSpaceOffset() {
        return NumUtil.roundUp((int)ConfigurationValues.getObjectLayout().getFirstFieldOffset(), (int)FrameAccess.wordSize());
    }

    protected static DeoptimizedFrame factory(int targetContentSize, long sourceTotalFrameSize, SubstrateInstalledCode sourceInstalledCode, VirtualFrame topFrame, CodePointer sourcePC) {
        Deoptimizer.TargetContent targetContentBuffer = new Deoptimizer.TargetContent(targetContentSize, ConfigurationValues.getTarget().arch.getByteOrder());
        return new DeoptimizedFrame(sourceTotalFrameSize, sourceInstalledCode, topFrame, targetContentBuffer, sourcePC);
    }

    private DeoptimizedFrame(long sourceTotalFrameSize, SubstrateInstalledCode sourceInstalledCode, VirtualFrame topFrame, Deoptimizer.TargetContent targetContent, CodePointer sourcePC) {
        this.sourceTotalFrameSize = sourceTotalFrameSize;
        this.topFrame = topFrame;
        this.targetContent = targetContent;
        this.sourceInstalledCode = sourceInstalledCode == null ? null : FeebleReference.factory(sourceInstalledCode, null);
        this.sourcePC = sourcePC;
        this.pin = PinnedObject.create((Object)this);
        StringBuilderLog sbl = new StringBuilderLog();
        sbl.string("deoptStub: completed for DeoptimizedFrame at ").hex((WordBase)this.pin.addressOfObject()).newline();
        this.completedMessage = sbl.getResult().toCharArray();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public long getSourceTotalFrameSize() {
        return this.sourceTotalFrameSize;
    }

    public SubstrateInstalledCode getSourceInstalledCode() {
        return this.sourceInstalledCode == null ? null : this.sourceInstalledCode.get();
    }

    public VirtualFrame getTopFrame() {
        return this.topFrame;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected Deoptimizer.TargetContent getTargetContent() {
        return this.targetContent;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public PinnedObject getPin() {
        return this.pin;
    }

    public CodePointer getSourcePC() {
        return this.sourcePC;
    }

    @Uninterruptible(reason="Called from Deoptimizer.deoptStub.")
    char[] getCompletedMessage() {
        return this.completedMessage;
    }

    @Uninterruptible(reason="Reads pointer values from the stack frame to unmanaged storage.")
    protected void buildContent() {
        VirtualFrame cur = this.topFrame;
        do {
            cur.returnAddress.write(this.targetContent);
            for (int i = 0; i < cur.values.length; ++i) {
                if (cur.values[i] == null) continue;
                cur.values[i].write(this.targetContent);
            }
        } while ((cur = cur.caller) != null);
    }

    public void takeException() {
        ReturnAddress firstAddressEntry = this.topFrame.returnAddress;
        long handler = CodeInfoTable.lookupExceptionOffset((CodePointer)WordFactory.unsigned((long)firstAddressEntry.returnAddress));
        assert (handler != 0L) : "no exception handler registered for deopt target";
        firstAddressEntry.returnAddress += handler;
    }

    static class ReturnAddress
    extends Entry {
        protected long returnAddress;

        protected ReturnAddress(int offset, long returnAddress) {
            super(offset);
            this.returnAddress = returnAddress;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeLong(this.offset, this.returnAddress);
        }
    }

    static class ObjectConstantEntry
    extends ConstantEntry {
        protected final Object value;
        protected final boolean compressed;

        protected ObjectConstantEntry(int offset, JavaConstant constant, Object value, boolean compressed) {
            super(offset, constant);
            this.value = value;
            this.compressed = compressed;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeObject(this.offset, this.value, this.compressed);
        }
    }

    static class EightByteConstantEntry
    extends ConstantEntry {
        protected final long value;

        protected EightByteConstantEntry(int offset, JavaConstant constant, long value) {
            super(offset, constant);
            this.value = value;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeLong(this.offset, this.value);
        }
    }

    static class FourByteConstantEntry
    extends ConstantEntry {
        protected final int value;

        protected FourByteConstantEntry(int offset, JavaConstant constant, int value) {
            super(offset, constant);
            this.value = value;
        }

        @Override
        @Uninterruptible(reason="Writes pointers to unmanaged storage.")
        protected void write(Deoptimizer.TargetContent targetContent) {
            targetContent.writeInt(this.offset, this.value);
        }
    }

    static abstract class ConstantEntry
    extends Entry {
        protected final JavaConstant constant;

        protected static ConstantEntry factory(int offset, JavaConstant constant) {
            switch (constant.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: {
                    return new FourByteConstantEntry(offset, constant, constant.asInt());
                }
                case Float: {
                    return new FourByteConstantEntry(offset, constant, Float.floatToIntBits(constant.asFloat()));
                }
                case Long: {
                    return new EightByteConstantEntry(offset, constant, constant.asLong());
                }
                case Double: {
                    return new EightByteConstantEntry(offset, constant, Double.doubleToLongBits(constant.asDouble()));
                }
                case Object: {
                    return new ObjectConstantEntry(offset, constant, SubstrateObjectConstant.asObject((Constant)constant), SubstrateObjectConstant.isCompressed(constant));
                }
            }
            throw VMError.shouldNotReachHere(constant.getJavaKind().toString());
        }

        protected ConstantEntry(int offset, JavaConstant constant) {
            super(offset);
            this.constant = constant;
        }
    }

    static abstract class Entry {
        protected final int offset;

        protected Entry(int offset) {
            this.offset = offset;
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected abstract void write(Deoptimizer.TargetContent var1);
    }

    public static class VirtualFrame {
        protected final FrameInfoQueryResult frameInfo;
        protected VirtualFrame caller;
        protected ReturnAddress returnAddress;
        protected final ConstantEntry[] values;

        protected VirtualFrame(FrameInfoQueryResult frameInfo) {
            this.frameInfo = frameInfo;
            this.values = new ConstantEntry[frameInfo.getValueInfos().length];
        }

        public VirtualFrame getCaller() {
            return this.caller;
        }

        public FrameInfoQueryResult getFrameInfo() {
            return this.frameInfo;
        }

        public JavaConstant getConstant(int index) {
            if (index >= this.values.length || this.values[index] == null) {
                return JavaConstant.forIllegal();
            }
            return this.values[index].constant;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ReserveDeoptScratchSpace {
    }
}

