/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
final class ReadReturnRegisterNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadReturnRegisterNode> TYPE = NodeClass.create(ReadReturnRegisterNode.class);
    private final long uniqueId = nextUniqueId.getAndIncrement();
    private static final AtomicLong nextUniqueId = new AtomicLong();

    protected ReadReturnRegisterNode(Stamp stamp) {
        super(TYPE, stamp);
    }

    protected ReadReturnRegisterNode(JavaKind kind) {
        this(StampFactory.forKind((JavaKind)kind));
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lirGenTool = gen.getLIRGeneratorTool();
        RegisterValue returnRegister = lirGenTool.getRegisterConfig().getReturnRegister(this.getStackKind()).asValue((ValueKind)LIRKind.fromJavaKind((Architecture)lirGenTool.target().arch, (JavaKind)this.getStackKind()));
        lirGenTool.emitIncomingValues(new Value[]{returnRegister});
        gen.setResult((ValueNode)this, (Value)lirGenTool.emitMove((Value)returnRegister));
    }
}

