/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class LayoutEncoding {
    private static final int NEUTRAL_VALUE = 0;
    private static final int PRIMITIVE_VALUE = 1;
    private static final int INTERFACE_VALUE = 2;
    private static final int ABSTRACT_VALUE = 3;
    private static final int LAST_SPECIAL_VALUE = 3;
    private static final int ARRAY_INDEX_SHIFT_SHIFT = 0;
    private static final int ARRAY_INDEX_SHIFT_MASK = 255;
    private static final int ALIGNMENT_MASK_SHIFT = 8;
    private static final int ALIGNMENT_MASK_MASK = 255;
    private static final int ARRAY_BASE_SHIFT = 16;
    private static final int ARRAY_BASE_MASK = 255;
    private static final int ARRAY_TAG_BITS = 2;
    private static final int ARRAY_TAG_SHIFT = 30;
    private static final int ARRAY_TAG_PRIMITIVE_VALUE = -1;
    private static final int ARRAY_TAG_OBJECT_VALUE = -2;

    public static int forPrimitive() {
        return 1;
    }

    public static int forInterface() {
        return 2;
    }

    public static int forAbstract() {
        return 3;
    }

    public static int forInstance(int size) {
        assert (size > 0 && size <= Integer.MAX_VALUE);
        int encoding = size;
        assert (LayoutEncoding.isInstance(encoding) && !LayoutEncoding.isArray(encoding) && !LayoutEncoding.isObjectArray(encoding) && !LayoutEncoding.isPrimitiveArray(encoding));
        assert (LayoutEncoding.getInstanceSize(encoding).equal(WordFactory.unsigned((int)size)));
        return encoding;
    }

    public static int forArray(boolean isObject, int arrayBaseOffset, int arrayIndexShift, int alignment) {
        int alignmentMask = alignment - 1;
        assert (alignment > 0 && (alignment & alignmentMask) == 0);
        int tag = isObject ? -2 : -1;
        int encoding = tag << 30 | arrayBaseOffset << 16 | alignmentMask << 8 | arrayIndexShift << 0;
        assert (!LayoutEncoding.isInstance(encoding) && LayoutEncoding.isArray(encoding));
        assert (LayoutEncoding.isObjectArray(encoding) == isObject);
        assert (LayoutEncoding.isPrimitiveArray(encoding) != isObject);
        assert (LayoutEncoding.getAlignmentMask(encoding) == alignmentMask);
        assert (LayoutEncoding.getArrayBaseOffset(encoding).equal(WordFactory.unsigned((int)arrayBaseOffset)));
        assert (LayoutEncoding.getArrayIndexShift(encoding) == arrayIndexShift);
        return encoding;
    }

    public static boolean isPrimitive(int encoding) {
        return encoding == 1;
    }

    public static boolean isInterface(int encoding) {
        return encoding == 2;
    }

    public static boolean isAbstract(int encoding) {
        return encoding == 3;
    }

    public static boolean isInstance(int encoding) {
        return encoding > 3;
    }

    public static UnsignedWord getInstanceSize(int encoding) {
        assert (LayoutEncoding.isInstance(encoding));
        return WordFactory.unsigned((int)encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArray(int encoding) {
        return encoding < 0;
    }

    public static boolean isPrimitiveArray(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-1073741824);
    }

    public static boolean isObjectArray(int encoding) {
        return encoding < -1073741824;
    }

    private static int getAlignmentMask(int encoding) {
        assert (LayoutEncoding.isArray(encoding));
        return encoding >> 8 & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayBaseOffset(int encoding) {
        assert (LayoutEncoding.isArray(encoding));
        return WordFactory.unsigned((int)(encoding >> 16 & 0xFF));
    }

    public static int getArrayIndexShift(int encoding) {
        assert (LayoutEncoding.isArray(encoding));
        return encoding >> 0 & 0xFF;
    }

    public static int getArrayIndexScale(int encoding) {
        return 1 << LayoutEncoding.getArrayIndexShift(encoding);
    }

    public static UnsignedWord getArrayElementOffset(int encoding, int index) {
        return LayoutEncoding.getArrayBaseOffset(encoding).add(WordFactory.unsigned((int)index).shiftLeft(LayoutEncoding.getArrayIndexShift(encoding)));
    }

    public static UnsignedWord getArraySize(int encoding, int length) {
        int alignmentMask = LayoutEncoding.getAlignmentMask(encoding);
        return LayoutEncoding.getArrayElementOffset(encoding, length).add(alignmentMask).and(~alignmentMask);
    }

    public static UnsignedWord getSizeFromObject(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        if (LayoutEncoding.isArray(encoding)) {
            return LayoutEncoding.getArraySize(encoding, KnownIntrinsics.readArrayLength(obj));
        }
        return LayoutEncoding.getInstanceSize(encoding);
    }

    public static Pointer getObjectEnd(Object obj) {
        Word objStart = Word.objectToUntrackedPointer((Object)obj);
        UnsignedWord objSize = LayoutEncoding.getSizeFromObject(obj);
        return objStart.add(objSize);
    }

    public static boolean isArray(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArray(encoding);
    }

    public static boolean isInstance(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isInstance(encoding);
    }
}

