/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.SubstrateRuntimeMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
class RuntimeMXBeanFeature
implements Feature {
    RuntimeMXBeanFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(new Runnable(){

            @Override
            public void run() {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                if (runtimeMXBean instanceof SubstrateRuntimeMXBean) {
                    SubstrateRuntimeMXBean substrateRuntimeMXBean = (SubstrateRuntimeMXBean)runtimeMXBean;
                    substrateRuntimeMXBean.setStartMillis();
                }
            }
        });
    }
}

