/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UnsupportedFeatureError;
import com.oracle.svm.core.jdk.VMErrorSubstitutions;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;

@TargetClass(value=VMError.class)
final class Target_com_oracle_svm_core_util_VMError {
    Target_com_oracle_svm_core_util_VMError() {
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere() {
        ThreadStackPrinter.printBacktrace();
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        VMErrorSubstitutions.shutdown(null, null);
        return null;
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        ThreadStackPrinter.printBacktrace();
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        VMErrorSubstitutions.shutdown(msg, null);
        return null;
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        ThreadStackPrinter.printBacktrace();
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        VMErrorSubstitutions.shutdown(null, ex);
        return null;
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        ThreadStackPrinter.printBacktrace();
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        VMErrorSubstitutions.shutdown(msg, ex);
        return null;
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static void guarantee(boolean condition) {
        if (!condition) {
            throw Target_com_oracle_svm_core_util_VMError.shouldNotReachHere("guarantee failed");
        }
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static void guarantee(boolean condition, String msg) {
        if (!condition) {
            throw Target_com_oracle_svm_core_util_VMError.shouldNotReachHere(msg);
        }
    }

    @Substitute
    private static RuntimeException unimplemented() {
        return Target_com_oracle_svm_core_util_VMError.unsupportedFeature("unimplemented");
    }

    @Substitute
    @NeverInline(value="avoid corner cases in error reporting: when we have a call to this method, we have a proper stack trace that includes the caller")
    private static RuntimeException unsupportedFeature(String msg) {
        throw new UnsupportedFeatureError(msg);
    }
}

