/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.CompilerCommandPlugin;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixProcessPropertiesSupport;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.word.PointerBase;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class PosixObjectFile
implements CompilerCommandPlugin {
    @Override
    public String name() {
        return "com.oracle.svm.core.posix.GetObjectFile";
    }

    @Override
    public Object apply(Object[] args) {
        if (args.length == 1) {
            if (args[0] instanceof String) {
                return PosixProcessPropertiesSupport.getObjectPathDefiningSymbol((String)args[0]);
            }
            if (args[0] instanceof CEntryPointLiteral) {
                return PosixProcessPropertiesSupport.getObjectPathDefiningAddress((PointerBase)((CEntryPointLiteral)args[0]).getFunctionPointer());
            }
        }
        throw new IllegalArgumentException("Expecting single String or CEntryPointLiteral agrument.");
    }

    @AutomaticFeature
    public static class ExposeObjectFileNameFeature
    implements Feature {
        public List<Class<? extends Feature>> getRequiredFeatures() {
            return Collections.singletonList(RuntimeFeature.class);
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            RuntimeSupport rs = RuntimeSupport.getRuntimeSupport();
            rs.addCommandPlugin(new PosixObjectFile());
        }
    }
}

