/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Ifaddrs;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetIf;
import com.oracle.svm.core.posix.headers.Netdb;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.net.InetAddress;
import java.net.SocketException;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class Util_java_net_Inet6AddressImpl {
    Util_java_net_Inet6AddressImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InetAddress[] lookupIfLocalhost(CCharPointer hostname, boolean includeV6) throws SocketException, InterruptedException {
        if (IsDefined.MACOSX()) {
            InetAddress[] result = null;
            CCharPointer myhostname = (CCharPointer)StackValue.get((int)(Netdb.NI_MAXHOST() + 1), CCharPointer.class);
            Ifaddrs.ifaddrs ifa = (Ifaddrs.ifaddrs)WordFactory.nullPointer();
            Ifaddrs.ifaddrsPointer ifaPointer = (Ifaddrs.ifaddrsPointer)StackValue.get(Ifaddrs.ifaddrsPointer.class);
            int addrs4 = 0;
            int addrs6 = 0;
            int numV4Loopbacks = 0;
            int numV6Loopbacks = 0;
            boolean includeLoopback = false;
            myhostname.write(0, (byte)0);
            if (Unistd.gethostname(myhostname, WordFactory.unsigned((int)Netdb.NI_MAXHOST())) == 0) {
                return null;
            }
            myhostname.write(Netdb.NI_MAXHOST(), (byte)0);
            if (LibC.strcmp((PointerBase)myhostname, (PointerBase)hostname) != 0) {
                return null;
            }
            try {
                int j;
                int i;
                boolean isLoopback;
                if (Ifaddrs.getifaddrs(ifaPointer) != 0) {
                    JavaNetNetUtilMD.NET_ThrowNew(Errno.errno(), "Can't get local interface addresses");
                    InetAddress[] inetAddressArray = null;
                    return inetAddressArray;
                }
                ifa = ifaPointer.read();
                String name = CTypeConversion.toJavaString((CCharPointer)hostname);
                Ifaddrs.ifaddrs iter = ifa;
                while (iter.isNonNull()) {
                    int family = iter.ifa_addr().sa_family();
                    if (iter.ifa_name().read(0) != 0 && iter.ifa_addr().isNonNull()) {
                        boolean bl = isLoopback = (iter.ifa_flags() & NetIf.IFF_LOOPBACK()) != 0;
                        if (family == Socket.AF_INET()) {
                            ++addrs4;
                            if (isLoopback) {
                                ++numV4Loopbacks;
                            }
                        } else if (family == Socket.AF_INET6() && includeV6) {
                            ++addrs6;
                            if (isLoopback) {
                                ++numV6Loopbacks;
                            }
                        }
                    }
                    iter = iter.ifa_next();
                }
                if (addrs4 == numV4Loopbacks && addrs6 == numV6Loopbacks) {
                    includeLoopback = true;
                }
                int arraySize = addrs4 + addrs6 - (includeLoopback ? 0 : numV4Loopbacks + numV6Loopbacks);
                result = new InetAddress[arraySize];
                if (GraalServices.Java8OrEarlier) {
                    if (Target_java_net_InetAddress.preferIPv6AddressJDK8OrEarlier) {
                        i = includeLoopback ? addrs6 : addrs6 - numV6Loopbacks;
                        j = 0;
                    } else {
                        i = 0;
                        j = includeLoopback ? addrs4 : addrs4 - numV4Loopbacks;
                    }
                } else {
                    boolean i2 = false;
                    boolean j2 = false;
                    throw VMError.unsupportedFeature("JDK9OrLater: PosixJavaNetSubstitutions.Util_java_net_Inet6AddressImpl.lookupIfLocalhost: https://bugs.openjdk.java.net/browse/JDK-8205076");
                }
                iter = ifa;
                while (iter.isNonNull()) {
                    isLoopback = (iter.ifa_flags() & NetIf.IFF_LOOPBACK()) != 0;
                    int family = iter.ifa_addr().sa_family();
                    if (iter.ifa_name().read(0) != 0 && iter.ifa_addr().isNonNull() && (family == Socket.AF_INET() || family == Socket.AF_INET6() && includeV6) && (!isLoopback || includeLoopback)) {
                        int index = family == Socket.AF_INET() ? i++ : j++;
                        CIntPointer portPointer = (CIntPointer)StackValue.get(CIntPointer.class);
                        InetAddress o = JavaNetNetUtil.NET_SockaddrToInetAddress(iter.ifa_addr(), portPointer);
                        if (o != null) {
                            throw new OutOfMemoryError("Object allocation failed");
                        }
                        JavaNetNetUtil.setInetAddress_hostName(o, name);
                        result[index] = o;
                    }
                    iter = iter.ifa_next();
                }
            }
            finally {
                Ifaddrs.freeifaddrs(ifa);
            }
            return result;
        }
        return null;
    }
}

