/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Sched;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class PosixJavaThreads
extends JavaThreads {
    private static final CEntryPointLiteral<CFunctionPointer> pthreadStartRoutine = CEntryPointLiteral.create(PosixJavaThreads.class, (String)"pthreadStartRoutine", (Class[])new Class[]{JavaThreads.ThreadStartData.class});

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    private static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PosixJavaThreads() {
    }

    @Override
    protected void doStartThread(Thread thread, long stackSize) {
        Pthread.pthread_attr_t attributes = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_init(attributes), "PosixJavaThreads.start0: pthread_attr_init");
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_setdetachstate(attributes, Pthread.PTHREAD_CREATE_DETACHED()), "PosixJavaThreads.start0: pthread_attr_init");
        long threadStackSize = stackSize;
        if (threadStackSize != 0L) {
            if (threadStackSize < 0L || threadStackSize < (long)Pthread.PTHREAD_STACK_MIN()) {
                threadStackSize = Pthread.PTHREAD_STACK_MIN();
            }
            PosixUtils.checkStatusIs0(Pthread.pthread_attr_setstacksize(attributes, WordFactory.unsigned((long)threadStackSize)), "PosixJavaThreads.start0: pthread_attr_setstacksize");
        }
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_setguardsize(attributes, VirtualMemoryProvider.get().getGranularity()), "PosixJavaThreads.start0: pthread_attr_setguardsize");
        JavaThreads.ThreadStartData startData = (JavaThreads.ThreadStartData)UnmanagedMemory.malloc((int)SizeOf.get(JavaThreads.ThreadStartData.class));
        PosixJavaThreads.prepareStartData(thread, startData);
        Pthread.pthread_tPointer newThread = (Pthread.pthread_tPointer)StackValue.get(Pthread.pthread_tPointer.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_create(newThread, attributes, (WordBase)pthreadStartRoutine.getFunctionPointer(), (WordBase)startData), "PosixJavaThreads.start0: pthread_create");
        PosixJavaThreads.setPthreadIdentifier(thread, newThread.read());
        Pthread.pthread_attr_destroy(attributes);
    }

    private static void setPthreadIdentifier(Thread thread, Pthread.pthread_t pthread) {
        PosixJavaThreads.toTarget((Thread)thread).hasPthreadIdentifier = true;
        PosixJavaThreads.toTarget((Thread)thread).pthreadIdentifier = pthread;
    }

    private static Pthread.pthread_t getPthreadIdentifier(Thread thread) {
        return PosixJavaThreads.toTarget((Thread)thread).pthreadIdentifier;
    }

    private static boolean hasThreadIdentifier(Thread thread) {
        return PosixJavaThreads.toTarget((Thread)thread).hasPthreadIdentifier;
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
        if (!PosixJavaThreads.hasThreadIdentifier(thread)) {
            return;
        }
        if (IsDefined.isDarwin() && thread != Thread.currentThread()) {
            return;
        }
        int startIndex = Math.max(0, name.length() - 15);
        String pthreadName = name.substring(startIndex);
        assert (pthreadName.length() < 16) : "thread name for pthread has a maximum length of 16 characters including the terminating 0";
        try (CTypeConversion.CCharPointerHolder threadNameHolder = CTypeConversion.toCString((CharSequence)pthreadName);){
            if (IsDefined.isLinux()) {
                LinuxPthread.pthread_setname_np(PosixJavaThreads.getPthreadIdentifier(thread), threadNameHolder.get());
            } else if (IsDefined.isDarwin()) {
                assert (thread == Thread.currentThread()) : "Darwin only allows setting the name of the current thread";
                DarwinPthread.pthread_setname_np(threadNameHolder.get());
            } else {
                VMError.unsupportedFeature("PosixJavaThreads.setNativeName on unknown OS");
            }
        }
    }

    @Override
    protected void yield() {
        Sched.sched_yield();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=PthreadStartRoutinePrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static WordBase pthreadStartRoutine(JavaThreads.ThreadStartData data) {
        ObjectHandle threadHandle = data.getThreadHandle();
        UnmanagedMemory.free((PointerBase)data);
        PosixJavaThreads.threadStartRoutine(threadHandle);
        return WordFactory.nullPointer();
    }

    @Override
    protected void noteThreadStart(Thread thread) {
        PosixJavaThreads.setPthreadIdentifier(thread, Pthread.pthread_self());
        this.setNativeName(thread, thread.getName());
        super.noteThreadStart(thread);
    }

    private static class PthreadStartRoutinePrologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to attach a newly launched thread.");

        private PthreadStartRoutinePrologue() {
        }

        static void enter(JavaThreads.ThreadStartData data) {
            int code = CEntryPointActions.enterAttachThread(data.getIsolate());
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }
}

