/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import org.graalvm.word.LocationIdentity;

public class ImplicitExceptions {
    private static final String NO_STACK_MSG = "[no exception stack trace available because exception is thrown from code that must be allocation free]";
    public static final NullPointerException CACHED_NULL_POINTER_EXCEPTION = new NullPointerException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayIndexOutOfBoundsException CACHED_OUT_OF_BOUNDS_EXCEPTION = new ArrayIndexOutOfBoundsException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ClassCastException CACHED_CLASS_CAST_EXCEPTION = new ClassCastException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayStoreException CACHED_ARRAY_STORE_EXCEPTION = new ArrayStoreException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArithmeticException CACHED_ARITHMETIC_EXCEPTION = new ArithmeticException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createNullPointerException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createClassCastException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createArrayStoreException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_DIVISION_BY_ZERO_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createDivisionByZeroException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_NULL_POINTER_EXCEPTION, CREATE_OUT_OF_BOUNDS_EXCEPTION, CREATE_CLASS_CAST_EXCEPTION, CREATE_ARRAY_STORE_EXCEPTION, CREATE_DIVISION_BY_ZERO_EXCEPTION, THROW_NEW_NULL_POINTER_EXCEPTION, THROW_NEW_OUT_OF_BOUNDS_EXCEPTION, THROW_NEW_CLASS_CAST_EXCEPTION, THROW_NEW_ARRAY_STORE_EXCEPTION, THROW_NEW_ARITHMETIC_EXCEPTION, THROW_CACHED_NULL_POINTER_EXCEPTION, THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION, THROW_CACHED_CLASS_CAST_EXCEPTION, THROW_CACHED_ARRAY_STORE_EXCEPTION, THROW_CACHED_ARITHMETIC_EXCEPTION};

    @SubstrateForeignCallTarget
    private static NullPointerException createNullPointerException() {
        return new NullPointerException();
    }

    @SubstrateForeignCallTarget
    private static ArrayIndexOutOfBoundsException createOutOfBoundsException(int index, int length) {
        return new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @SubstrateForeignCallTarget
    private static ClassCastException createClassCastException(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        return new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @SubstrateForeignCallTarget
    private static ArrayStoreException createArrayStoreException(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        return new ArrayStoreException(value.getClass().getTypeName());
    }

    @SubstrateForeignCallTarget
    private static ArithmeticException createDivisionByZeroException() {
        return new ArithmeticException("/ by zero");
    }

    @SubstrateForeignCallTarget
    private static void throwNewNullPointerException() {
        throw new NullPointerException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewOutOfBoundsException() {
        throw new ArrayIndexOutOfBoundsException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewClassCastException() {
        throw new ClassCastException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewArrayStoreException() {
        throw new ArrayStoreException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewArithmeticException() {
        throw new ArithmeticException();
    }

    @SubstrateForeignCallTarget
    private static void throwCachedNullPointerException() {
        throw CACHED_NULL_POINTER_EXCEPTION;
    }

    @SubstrateForeignCallTarget
    private static void throwCachedOutOfBoundsException() {
        throw CACHED_OUT_OF_BOUNDS_EXCEPTION;
    }

    @SubstrateForeignCallTarget
    private static void throwCachedClassCastException() {
        throw CACHED_CLASS_CAST_EXCEPTION;
    }

    @SubstrateForeignCallTarget
    private static void throwCachedArrayStoreException() {
        throw CACHED_ARRAY_STORE_EXCEPTION;
    }

    @SubstrateForeignCallTarget
    private static void throwCachedArithmeticException() {
        throw CACHED_ARITHMETIC_EXCEPTION;
    }
}

