/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.AbstractCodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class ThreadStackPrinter {
    public static final StackFrameVisitor AllocationFreeStackFrameVisitor = new AllocationFreeStackFrameVisitor();

    @NeverInline(value="debugger breakpoint")
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void printBacktrace() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free Stacktrace printing")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints", calleeMustBe=false)
    public static void printStacktrace(Pointer startSP, CodePointer startIP) {
        JavaStackWalker.walkCurrentThread(startSP, startIP, AllocationFreeStackFrameVisitor);
    }

    public static class Stage1StackFrameVisitor
    extends Stage0StackFrameVisitor {
        protected static void logFrameInfo(Log log, FrameInfoQueryResult frameInfo, String runtimeMethodInfoName) {
            log.string("  ");
            if (runtimeMethodInfoName != null) {
                log.string("[").string(runtimeMethodInfoName).string("] ");
            }
            frameInfo.log(log);
        }

        protected static void logVirtualFrames(Log log, Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                Stage1StackFrameVisitor.logFrameRaw(log, sp, ip);
                Stage1StackFrameVisitor.logFrameInfo(log, frame.getFrameInfo(), "image code, deopt");
                if (frame.getCaller() == null) continue;
                log.newline();
            }
        }

        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                Stage1StackFrameVisitor.logVirtualFrames(log, sp, ip, deoptFrame);
            } else {
                Stage1StackFrameVisitor.logFrameRaw(log, sp, ip);
                log.spaces(2);
                CodeInfoTable.logCodeInfoResult(log, ip);
            }
        }
    }

    public static class Stage0StackFrameVisitor
    implements StackFrameVisitor {
        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
        public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            Log log = Log.log();
            this.logFrame(log, sp, ip, deoptFrame);
            log.newline();
            return true;
        }

        protected void logFrame(Log log, Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            Stage0StackFrameVisitor.logFrameRaw(log, sp, ip);
            Log.log().string(" FrameSize ").signed(CodeInfoTable.lookupTotalFrameSize(ip));
        }

        protected static void logFrameRaw(Log log, Pointer sp, CodePointer ip) {
            log.string("RSP ").zhex(sp.rawValue());
            log.string(" RIP ").zhex(ip.rawValue());
        }
    }

    public static class AllocationFreeStackFrameVisitor
    extends Stage1StackFrameVisitor {
        private static ReusableTypeReader frameInfoReader = new ReusableTypeReader();
        private static SingleShotFrameInfoQueryResultAllocator SingleShotFrameInfoQueryResultAllocator = new SingleShotFrameInfoQueryResultAllocator();
        private static DummyValueInfoAllocator DummyValueInfoAllocator = new DummyValueInfoAllocator();

        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                com.oracle.svm.core.stack.ThreadStackPrinter$AllocationFreeStackFrameVisitor.logVirtualFrames(log, sp, ip, deoptFrame);
            } else {
                AbstractCodeInfo codeInfo = CodeInfoTable.lookupCodeInfo(ip);
                if (codeInfo != null) {
                    frameInfoReader.reset();
                    long entryOffset = codeInfo.initFrameInfoReader(ip, frameInfoReader);
                    if (entryOffset >= 0L) {
                        FrameInfoQueryResult validResult;
                        boolean isFirst = true;
                        SingleShotFrameInfoQueryResultAllocator.reload();
                        while ((validResult = codeInfo.nextFrameInfo(entryOffset, frameInfoReader, SingleShotFrameInfoQueryResultAllocator, DummyValueInfoAllocator, isFirst)) != null) {
                            SingleShotFrameInfoQueryResultAllocator.reload();
                            if (!isFirst) {
                                log.newline();
                            }
                            com.oracle.svm.core.stack.ThreadStackPrinter$AllocationFreeStackFrameVisitor.logFrameRaw(log, sp, ip);
                            com.oracle.svm.core.stack.ThreadStackPrinter$AllocationFreeStackFrameVisitor.logFrameInfo(log, validResult, codeInfo.getName());
                            isFirst = false;
                        }
                    }
                }
            }
        }

        private static class DummyValueInfoAllocator
        implements FrameInfoDecoder.ValueInfoAllocator {
            private DummyValueInfoAllocator() {
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo newValueInfo() {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int len) {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int len) {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public void decodeConstant(FrameInfoQueryResult.ValueInfo valueInfo, Object[] frameInfoObjectConstants) {
            }
        }

        private static class SingleShotFrameInfoQueryResultAllocator
        implements FrameInfoDecoder.FrameInfoQueryResultAllocator {
            private static FrameInfoQueryResult frameInfoQueryResult = new FrameInfoQueryResult();
            private boolean fired;

            private SingleShotFrameInfoQueryResultAllocator() {
            }

            void reload() {
                this.fired = false;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult newFrameInfoQueryResult() {
                if (this.fired) {
                    return null;
                }
                this.fired = true;
                frameInfoQueryResult.init();
                return frameInfoQueryResult;
            }
        }
    }
}

