/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.UnsafePartitionKind;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.RuntimeReflection;

public class FeatureImpl {

    public static class AfterImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterImageWriteAccess {
        private final HostedUniverse hUniverse;
        protected final Path imagePath;
        protected final Path tempDirectory;
        protected final AbstractBootImage.NativeImageKind imageKind;

        AfterImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, HostedUniverse hUniverse, Path imagePath, Path tempDirectory, AbstractBootImage.NativeImageKind imageKind, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hUniverse = hUniverse;
            this.imagePath = imagePath;
            this.tempDirectory = tempDirectory;
            this.imageKind = imageKind;
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Path getImagePath() {
            return this.imagePath;
        }

        public Path getTempDirectory() {
            return this.tempDirectory;
        }

        public AbstractBootImage.NativeImageKind getImageKind() {
            return this.imageKind;
        }
    }

    public static class BeforeImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.BeforeImageWriteAccess {
        private List<Function<LinkerInvocation, LinkerInvocation>> linkerInvocationTransformers = null;
        protected final String imageName;
        protected final AbstractBootImage image;
        protected final RuntimeConfiguration runtimeConfig;
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final HostedOptionProvider optionProvider;
        protected final HostedMetaAccess hMetaAccess;

        BeforeImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, String imageName, AbstractBootImage image, RuntimeConfiguration runtimeConfig, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedOptionProvider optionProvider, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.imageName = imageName;
            this.image = image;
            this.runtimeConfig = runtimeConfig;
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.optionProvider = optionProvider;
            this.hMetaAccess = hMetaAccess;
        }

        public String getImageName() {
            return this.imageName;
        }

        public AbstractBootImage getImage() {
            return this.image;
        }

        public RuntimeConfiguration getRuntimeConfiguration() {
            return this.runtimeConfig;
        }

        public HostedUniverse getHostedUniverse() {
            return this.hUniverse;
        }

        public HostedOptionProvider getHostedOptionProvider() {
            return this.optionProvider;
        }

        public HostedMetaAccess getHostedMetaAccess() {
            return this.hMetaAccess;
        }

        public Iterable<Function<LinkerInvocation, LinkerInvocation>> getLinkerInvocationTransformers() {
            if (this.linkerInvocationTransformers == null) {
                return Collections.emptyList();
            }
            return this.linkerInvocationTransformers;
        }

        public void registerLinkerInvocationTransformer(Function<LinkerInvocation, LinkerInvocation> transformer) {
            if (this.linkerInvocationTransformers == null) {
                this.linkerInvocationTransformers = new ArrayList<Function<LinkerInvocation, LinkerInvocation>>();
            }
            this.linkerInvocationTransformers.add(transformer);
        }
    }

    public static class AfterHeapLayoutAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterHeapLayoutAccess {
        protected final HostedMetaAccess hMetaAccess;

        AfterHeapLayoutAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hMetaAccess = hMetaAccess;
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }
    }

    public static class AfterCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.AfterCompilationAccess {
        AfterCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, NativeImageHeap heap, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, hMetaAccess, heap, debugContext);
        }
    }

    public static class BeforeCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.BeforeCompilationAccess {
        BeforeCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, NativeImageHeap heap, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, hMetaAccess, heap, debugContext);
        }
    }

    public static class CompilationAccessImpl
    extends FeatureAccessImpl
    implements Feature.CompilationAccess {
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final HostedMetaAccess hMetaAccess;
        protected final NativeImageHeap heap;

        CompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, NativeImageHeap heap, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.hMetaAccess = hMetaAccess;
            this.heap = heap;
        }

        public long objectFieldOffset(Field field) {
            return this.objectFieldOffset(this.getMetaAccess().lookupJavaField(field));
        }

        public long objectFieldOffset(HostedField hField) {
            int result = hField.getLocation();
            assert (result > 0);
            return result;
        }

        public void registerAsImmutable(Object object) {
            this.heap.registerAsImmutable(object);
        }

        public void registerAsImmutable(Object root, Predicate<Object> includeObject) {
            ArrayDeque<Object> worklist = new ArrayDeque<Object>();
            IdentityHashMap<Object, Boolean> registeredObjects = new IdentityHashMap<Object, Boolean>();
            worklist.push(root);
            while (!worklist.isEmpty()) {
                Object cur = worklist.pop();
                this.registerAsImmutable(cur);
                if (!this.getMetaAccess().optionalLookupJavaType(cur.getClass()).isPresent()) continue;
                if (cur instanceof Object[]) {
                    for (Object element : (Object[])cur) {
                        CompilationAccessImpl.addToWorklist(this.aUniverse.replaceObject(element), includeObject, worklist, registeredObjects);
                    }
                    continue;
                }
                JavaConstant constant = SubstrateObjectConstant.forObject(cur);
                for (HostedField field : ((HostedType)this.getMetaAccess().lookupJavaType(constant)).getInstanceFields(true)) {
                    if (!field.isAccessed() || field.getStorageKind() != JavaKind.Object) continue;
                    Object fieldValue = SubstrateObjectConstant.asObject((Constant)field.readValue(constant));
                    CompilationAccessImpl.addToWorklist(fieldValue, includeObject, worklist, registeredObjects);
                }
            }
        }

        private static void addToWorklist(Object object, Predicate<Object> includeObject, Deque<Object> worklist, IdentityHashMap<Object, Boolean> registeredObjects) {
            if (object == null || registeredObjects.containsKey(object)) {
                return;
            }
            if (object instanceof DynamicHub || object instanceof Class) {
                return;
            }
            if (!includeObject.test(object)) {
                return;
            }
            registeredObjects.put(object, Boolean.TRUE);
            worklist.push(object);
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Collection<? extends SharedType> getTypes() {
            return this.hUniverse.getTypes();
        }

        public Collection<? extends SharedField> getFields() {
            return this.hUniverse.getFields();
        }

        public Collection<? extends SharedMethod> getMethods() {
            return this.hUniverse.getMethods();
        }
    }

    public static class OnAnalysisExitAccessImpl
    extends AnalysisAccessBase
    implements Feature.OnAnalysisExitAccess {
        OnAnalysisExitAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class AfterAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.AfterAnalysisAccess {
        AfterAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class DuringAnalysisAccessImpl
    extends BeforeAnalysisAccessImpl
    implements Feature.DuringAnalysisAccess {
        private boolean requireAnalysisIteration;

        DuringAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, SVMHost hostVM, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, hostVM, nativeLibraries, debugContext);
        }

        public void requireAnalysisIteration() {
            this.requireAnalysisIteration = true;
        }

        public boolean getAndResetRequireAnalysisIteration() {
            boolean result = this.requireAnalysisIteration;
            this.requireAnalysisIteration = false;
            return result;
        }
    }

    public static class BeforeAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.BeforeAnalysisAccess {
        private final SVMHost hostVM;
        private final NativeLibraries nativeLibraries;

        BeforeAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, SVMHost hostVM, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
            this.hostVM = hostVM;
            this.nativeLibraries = nativeLibraries;
        }

        public NativeLibraries getNativeLibraries() {
            return this.nativeLibraries;
        }

        public void registerAsUsed(Class<?> clazz) {
            this.registerAsUsed(this.getMetaAccess().lookupJavaType(clazz));
        }

        public void registerAsUsed(AnalysisType aType) {
            aType.registerAsInTypeCheck();
        }

        public void registerAsInHeap(Class<?> clazz) {
            this.registerAsInHeap(this.getMetaAccess().lookupJavaType(clazz));
        }

        public void registerAsInHeap(AnalysisType aType) {
            aType.registerAsInHeap();
        }

        public void registerAsAccessed(Field field) {
            this.registerAsAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public void registerAsAccessed(AnalysisField aField) {
            aField.registerAsAccessed();
        }

        public void registerAsUnsafeAccessed(Field field) {
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public boolean registerAsUnsafeAccessed(AnalysisField aField) {
            if (!aField.isUnsafeAccessed()) {
                aField.registerAsAccessed();
                aField.registerAsUnsafeAccessed();
                this.bb.forceUnsafeUpdate(aField);
                return true;
            }
            return false;
        }

        public void registerAsFrozenUnsafeAccessed(Field field) {
            this.registerAsFrozenUnsafeAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public void registerAsFrozenUnsafeAccessed(AnalysisField aField) {
            aField.setUnsafeFrozenTypeState(true);
            this.registerAsUnsafeAccessed(aField);
        }

        public void registerAsUnsafeAccessed(Field field, UnsafePartitionKind partitionKind) {
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field), partitionKind);
        }

        public void registerAsUnsafeAccessed(AnalysisField aField, UnsafePartitionKind partitionKind) {
            this.registerAsAccessed(aField);
            aField.registerAsUnsafeAccessed(partitionKind);
        }

        public void registerAsInvoked(Executable method) {
            this.registerAsInvoked(this.getMetaAccess().lookupJavaMethod(method));
        }

        public void registerAsInvoked(AnalysisMethod aMethod) {
            this.bb.addRootMethod(aMethod).registerAsImplementationInvoked(null);
        }

        public void registerAsCompiled(Executable method) {
            this.registerAsCompiled(this.getMetaAccess().lookupJavaMethod(method));
        }

        public void registerAsCompiled(AnalysisMethod aMethod) {
            this.registerAsInvoked(aMethod);
            CompilationInfoSupport.singleton().registerForcedCompilation((ResolvedJavaMethod)aMethod);
        }

        public void registerUnsafeFieldsRecomputed(Class<?> clazz) {
            this.getMetaAccess().lookupJavaType(clazz).registerUnsafeFieldsRecomputed();
        }

        public SVMHost getHostVM() {
            return this.hostVM;
        }

        public void registerHierarchyForReflectiveInstantiation(Class<?> c) {
            this.findSubclasses(c).stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz}));
        }
    }

    public static class DuringSetupAccessImpl
    extends AnalysisAccessBase
    implements Feature.DuringSetupAccess {
        private final SVMHost hostVM;

        DuringSetupAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, SVMHost hostVM, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
            this.hostVM = hostVM;
        }

        public void registerObjectReplacer(Function<Object, Object> replacer) {
            this.getUniverse().registerObjectReplacer(replacer);
        }

        public void registerSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureSubstitution(substitution);
        }

        public void registerNativeSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureNativeSubstitution(substitution);
        }

        public SVMHost getHostVM() {
            return this.hostVM;
        }
    }

    static abstract class AnalysisAccessBase
    extends FeatureAccessImpl {
        protected final BigBang bb;

        AnalysisAccessBase(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, BigBang bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.bb = bb;
        }

        public BigBang getBigBang() {
            return this.bb;
        }

        public AnalysisUniverse getUniverse() {
            return this.bb.getUniverse();
        }

        public AnalysisMetaAccess getMetaAccess() {
            return this.bb.getMetaAccess();
        }
    }

    public static class AfterRegistrationAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterRegistrationAccess {
        private final MetaAccessProvider metaAccess;

        AfterRegistrationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, MetaAccessProvider metaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.metaAccess = metaAccess;
        }

        public MetaAccessProvider getMetaAccess() {
            return this.metaAccess;
        }
    }

    public static class IsInConfigurationAccessImpl
    extends FeatureAccessImpl
    implements Feature.IsInConfigurationAccess {
        IsInConfigurationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
        }
    }

    public static abstract class FeatureAccessImpl
    implements Feature.FeatureAccess {
        protected final FeatureHandler featureHandler;
        protected final ImageClassLoader imageClassLoader;
        protected final DebugContext debugContext;

        FeatureAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            this.featureHandler = featureHandler;
            this.imageClassLoader = imageClassLoader;
            this.debugContext = debugContext;
        }

        public ImageClassLoader getImageClassLoader() {
            return this.imageClassLoader;
        }

        public Class<?> findClassByName(String className) {
            return this.imageClassLoader.findClassByName(className, false);
        }

        public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass) {
            return this.imageClassLoader.findSubclasses(baseClass);
        }

        public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedClasses(annotationClass);
        }

        public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedMethods(annotationClass);
        }

        public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedFields(annotationClass);
        }

        public FeatureHandler getFeatureHandler() {
            return this.featureHandler;
        }

        public DebugContext getDebugContext() {
            return this.debugContext;
        }
    }
}

