/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;

public abstract class SizableInfo
extends ElementInfo {
    private final ElementKind kind;
    private final PropertyInfo<Integer> sizeInfo;
    private final PropertyInfo<SignednessValue> signednessInfo;

    public SizableInfo(String name, ElementKind kind) {
        super(name);
        this.kind = kind;
        this.sizeInfo = this.adoptChild(new PropertyInfo("size"));
        this.signednessInfo = kind == ElementKind.INTEGER ? this.adoptChild(new PropertyInfo("signedness")) : null;
    }

    public ElementKind getKind() {
        return this.kind;
    }

    public PropertyInfo<Integer> getSizeInfo() {
        return this.sizeInfo;
    }

    public PropertyInfo<SignednessValue> getSignednessInfo() {
        assert (this.signednessInfo != null);
        return this.signednessInfo;
    }

    public boolean isUnsigned() {
        return this.getKind() == ElementKind.POINTER || this.getKind() == ElementKind.INTEGER && this.getSignednessInfo().getProperty() == SignednessValue.UNSIGNED;
    }

    public static enum SignednessValue {
        SIGNED,
        UNSIGNED;

    }

    public static enum ElementKind {
        INTEGER,
        POINTER,
        FLOAT,
        STRING,
        BYTEARRAY,
        UNKNOWN;

    }
}

