/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.code.CEntryPointJavaCallStubs;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CEntryPointJavaCallStubMethod;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Executable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;

public final class CEntryPointCallStubSupport {
    private final BigBang bigbang;
    private final Map<AnalysisMethod, AnalysisMethod> methodToStub = new ConcurrentHashMap<AnalysisMethod, AnalysisMethod>();
    private final Map<AnalysisMethod, AnalysisMethod> methodToJavaStub = new ConcurrentHashMap<AnalysisMethod, AnalysisMethod>();
    private NativeLibraries nativeLibraries;

    static void initialize(BigBang bigbang) {
        ImageSingletons.add(CEntryPointCallStubSupport.class, (Object)new CEntryPointCallStubSupport(bigbang));
    }

    public static CEntryPointCallStubSupport singleton() {
        return (CEntryPointCallStubSupport)ImageSingletons.lookup(CEntryPointCallStubSupport.class);
    }

    private CEntryPointCallStubSupport(BigBang bigbang) {
        this.bigbang = bigbang;
    }

    public AnalysisMethod getStubForMethod(Executable reflectionMethod) {
        AnalysisMethod method = this.bigbang.getMetaAccess().lookupJavaMethod(reflectionMethod);
        return this.getStubForMethod(method);
    }

    public AnalysisMethod registerStubForMethod(Executable reflectionMethod, Supplier<CEntryPointData> entryPointDataSupplier) {
        AnalysisMethod method = this.bigbang.getMetaAccess().lookupJavaMethod(reflectionMethod);
        return this.registerStubForMethod(method, entryPointDataSupplier);
    }

    public AnalysisMethod getStubForMethod(AnalysisMethod method) {
        return this.methodToStub.get(method);
    }

    public AnalysisMethod getMethodForStub(CEntryPointCallStubMethod method) {
        return method.lookupTargetMethod(this.bigbang.getMetaAccess());
    }

    public AnalysisMethod registerStubForMethod(AnalysisMethod method, Supplier<CEntryPointData> entryPointDataSupplier) {
        return this.methodToStub.compute(method, (key, existingValue) -> {
            AnalysisMethod value = existingValue;
            if (value == null) {
                assert (!this.bigbang.getUniverse().sealed());
                CEntryPointData entryPointData = (CEntryPointData)entryPointDataSupplier.get();
                CEntryPointCallStubMethod stub = CEntryPointCallStubMethod.create(method, entryPointData, this.bigbang.getMetaAccess());
                AnalysisMethod wrapped = this.bigbang.getUniverse().lookup((JavaMethod)stub);
                this.bigbang.addRootMethod(wrapped).registerAsEntryPoint((Object)entryPointData);
                value = wrapped;
            }
            return value;
        });
    }

    public AnalysisMethod registerJavaStubForMethod(AnalysisMethod method) {
        return this.methodToJavaStub.compute(method, (key, existingValue) -> {
            AnalysisMethod value = existingValue;
            if (value == null) {
                assert (!this.bigbang.getUniverse().sealed());
                AnalysisMethod nativeStub = this.registerStubForMethod(method, () -> CEntryPointData.create((ResolvedJavaMethod)method));
                CFunctionPointer nativeStubAddress = MethodPointer.factory((ResolvedJavaMethod)nativeStub);
                String stubName = NativeBootImage.globalSymbolNameForMethod((ResolvedJavaMethod)method);
                ResolvedJavaType holderClass = this.bigbang.getMetaAccess().lookupJavaType(CEntryPointJavaCallStubs.class).getWrapped();
                CEntryPointJavaCallStubMethod stub = new CEntryPointJavaCallStubMethod(method.getWrapped(), stubName, holderClass, (CodePointer)nativeStubAddress);
                value = this.bigbang.getUniverse().lookup((JavaMethod)stub);
            }
            return value;
        });
    }

    void setNativeLibraries(NativeLibraries nativeLibraries) {
        this.nativeLibraries = nativeLibraries;
    }

    NativeLibraries getNativeLibraries() {
        assert (this.nativeLibraries != null);
        return this.nativeLibraries;
    }
}

